/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.spark.data.BasicSupplier;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.DataLayer;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.data.SSTablesSupplier;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.sparksql.filters.PartitionKeyFilter;
import org.apache.cassandra.spark.sparksql.filters.SparkRangeFilter;
import org.apache.cassandra.spark.utils.TimeProvider;
import org.apache.cassandra.spark.utils.test.TestSSTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDataLayer
extends DataLayer {
    public static final ExecutorService FILE_IO_EXECUTOR = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("test-file-io-%d").setDaemon(true).build());
    @NotNull
    CassandraBridge bridge;
    @NotNull
    Collection<Path> dataDbFiles;
    @Nullable
    CqlTable table;
    final String jobId;

    public TestDataLayer(@NotNull CassandraBridge bridge, @NotNull Collection<Path> dataDbFiles, @Nullable CqlTable table) {
        this.bridge = bridge;
        this.dataDbFiles = dataDbFiles;
        this.table = table;
        this.jobId = UUID.randomUUID().toString();
    }

    public CassandraBridge bridge() {
        return this.bridge;
    }

    public int partitionCount() {
        return 0;
    }

    public CqlTable cqlTable() {
        return this.table;
    }

    public boolean isInPartition(int partitionId, BigInteger token, ByteBuffer key) {
        return true;
    }

    public TimeProvider timeProvider() {
        return TimeProvider.DEFAULT;
    }

    protected ExecutorService executorService() {
        return FILE_IO_EXECUTOR;
    }

    @NotNull
    public SSTablesSupplier sstables(int partitionId, @Nullable SparkRangeFilter sparkRangeFilter, @NotNull List<PartitionKeyFilter> partitionKeyFilters) {
        return new BasicSupplier(this.listSSTables().collect(Collectors.toSet()));
    }

    public Stream<SSTable> listSSTables() {
        return this.dataDbFiles.stream().map(TestSSTable::at);
    }

    public Partitioner partitioner() {
        return Partitioner.Murmur3Partitioner;
    }

    public String jobId() {
        return this.jobId;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.version());
        out.writeObject(this.dataDbFiles);
        this.bridge.javaSerialize(out, (Serializable)this.table);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.bridge = CassandraBridgeFactory.get((CassandraVersion)((CassandraVersion)in.readObject()));
        this.dataDbFiles = (Collection)in.readObject();
        this.table = (CqlTable)this.bridge.javaDeserialize(in, CqlTable.class);
    }
}

