/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.clients;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import o.a.c.sidecar.client.shaded.client.HttpClientConfig;
import o.a.c.sidecar.client.shaded.client.RequestExecutor;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.client.SidecarClientConfig;
import o.a.c.sidecar.client.shaded.client.SidecarClientConfigImpl;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.client.SidecarInstanceImpl;
import o.a.c.sidecar.client.shaded.client.SidecarInstancesProvider;
import o.a.c.sidecar.client.shaded.client.VertxHttpClient;
import o.a.c.sidecar.client.shaded.client.VertxRequestExecutor;
import o.a.c.sidecar.client.shaded.client.retry.ExponentialBackoffRetryPolicy;
import o.a.c.sidecar.client.shaded.client.retry.RetryPolicy;
import o.a.c.sidecar.client.shaded.common.response.NodeSettings;
import o.a.c.sidecar.client.shaded.io.vertx.core.Vertx;
import o.a.c.sidecar.client.shaded.io.vertx.core.VertxOptions;
import org.apache.cassandra.secrets.SecretsProvider;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.utils.BuildInfo;
import org.apache.cassandra.spark.utils.MapUtils;
import org.apache.cassandra.spark.utils.Properties;
import org.apache.cassandra.spark.validation.KeyStoreValidation;
import org.apache.cassandra.spark.validation.StartupValidator;
import org.apache.cassandra.spark.validation.TrustStoreValidation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Sidecar {
    private static final Logger LOGGER = LoggerFactory.getLogger(Sidecar.class);

    private Sidecar() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static SidecarClient from(SidecarInstancesProvider sidecarInstancesProvider, ClientConfig config, SecretsProvider secretsProvider) throws IOException {
        Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions().setUseDaemonThread(Boolean.valueOf(true)).setWorkerPoolSize(config.maxPoolSize()));
        HttpClientConfig.Builder builder = new HttpClientConfig.Builder().ssl(false).timeoutMillis(TimeUnit.SECONDS.toMillis(config.timeoutSeconds())).idleTimeoutMillis((int)TimeUnit.SECONDS.toMillis(config.timeoutSeconds())).receiveBufferSize((int)config.chunkBufferSize()).maxChunkSize((int)config.maxBufferSize()).userAgent(BuildInfo.READER_USER_AGENT).cassandraRole(config.cassandraRole());
        if (secretsProvider != null) {
            builder = builder.ssl(true).keyStoreInputStream(secretsProvider.keyStoreInputStream()).keyStorePassword(String.valueOf(secretsProvider.keyStorePassword())).keyStoreType(secretsProvider.keyStoreType()).trustStoreInputStream(secretsProvider.trustStoreInputStream()).trustStorePassword(String.valueOf(secretsProvider.trustStorePassword())).trustStoreType(secretsProvider.trustStoreType());
            StartupValidator.instance().register(new KeyStoreValidation(secretsProvider));
            StartupValidator.instance().register(new TrustStoreValidation(secretsProvider));
        }
        HttpClientConfig httpClientConfig = builder.build();
        SidecarClientConfig sidecarConfig = SidecarClientConfigImpl.builder().maxRetries(config.maxRetries()).retryDelayMillis(config.millisToSleep()).maxRetryDelayMillis(config.maxMillisToSleep()).build();
        return Sidecar.buildClient(sidecarConfig, vertx, httpClientConfig, sidecarInstancesProvider);
    }

    public static SidecarClient buildClient(SidecarClientConfig sidecarConfig, Vertx vertx, HttpClientConfig httpClientConfig, SidecarInstancesProvider clusterConfig) {
        ExponentialBackoffRetryPolicy defaultRetryPolicy = new ExponentialBackoffRetryPolicy(sidecarConfig.maxRetries(), sidecarConfig.retryDelayMillis(), sidecarConfig.maxRetryDelayMillis());
        VertxHttpClient vertxHttpClient = new VertxHttpClient(vertx, httpClientConfig);
        VertxRequestExecutor requestExecutor = new VertxRequestExecutor(vertxHttpClient);
        return new SidecarClient(clusterConfig, (RequestExecutor)requestExecutor, sidecarConfig, (RetryPolicy)defaultRetryPolicy);
    }

    public static List<CompletableFuture<NodeSettings>> allNodeSettings(SidecarClient client, Set<SidecarInstance> instances) {
        return instances.stream().map(instance -> client.nodeSettings(instance).exceptionally(throwable -> {
            LOGGER.warn(String.format("Failed to execute node settings on instance=%s", instance), throwable);
            return null;
        })).collect(Collectors.toList());
    }

    public static SidecarInstance toSidecarInstance(CassandraInstance instance, int sidecarPort) {
        return new SidecarInstanceImpl(instance.nodeName(), sidecarPort);
    }

    public static final class ClientConfig {
        public static final String SIDECAR_PORT = "sidecar_port";
        public static final String MAX_RETRIES_KEY = "maxRetries";
        public static final String DEFAULT_MILLIS_TO_SLEEP_KEY = "defaultMillisToSleep";
        public static final String MAX_MILLIS_TO_SLEEP_KEY = "maxMillisToSleep";
        public static final String MAX_BUFFER_SIZE_BYTES_KEY = "maxBufferSizeBytes";
        public static final String CHUNK_BUFFER_SIZE_BYTES_KEY = "chunkBufferSizeBytes";
        public static final String MAX_POOL_SIZE_KEY = "maxPoolSize";
        public static final String TIMEOUT_SECONDS_KEY = "timeoutSeconds";
        public static final String CASSANDRA_ROLE_KEY = "cassandra_role";
        public static final String DEFAULT_CASSANDRA_ROLE = null;
        private final int userProvidedPort;
        private final int maxRetries;
        private final int maxPoolSize;
        private final int timeoutSeconds;
        private final long millisToSleep;
        private final long maxMillisToSleep;
        private final long maxBufferSize;
        private final long chunkSize;
        private final String cassandraRole;
        private final Map<FileType, Long> maxBufferOverride;
        private final Map<FileType, Long> chunkBufferOverride;

        private ClientConfig(int userProvidedPort, int maxRetries, long millisToSleep, long maxMillisToSleep, long maxBufferSize, long chunkSize, int maxPoolSize, int timeoutSeconds, String cassandraRole, Map<FileType, Long> maxBufferOverride, Map<FileType, Long> chunkBufferOverride) {
            this.userProvidedPort = userProvidedPort;
            this.maxRetries = maxRetries;
            this.millisToSleep = millisToSleep;
            this.maxMillisToSleep = maxMillisToSleep;
            this.maxBufferSize = maxBufferSize;
            this.chunkSize = chunkSize;
            this.maxPoolSize = maxPoolSize;
            this.timeoutSeconds = timeoutSeconds;
            this.cassandraRole = cassandraRole;
            this.maxBufferOverride = maxBufferOverride;
            this.chunkBufferOverride = chunkBufferOverride;
        }

        public int userProvidedPort() {
            return this.userProvidedPort;
        }

        public int effectivePort() {
            return this.userProvidedPort == -1 ? 9043 : this.userProvidedPort;
        }

        public int maxRetries() {
            return this.maxRetries;
        }

        public long millisToSleep() {
            return this.millisToSleep;
        }

        public long maxMillisToSleep() {
            return this.maxMillisToSleep;
        }

        public long maxBufferSize() {
            return this.maxBufferSize(FileType.DATA);
        }

        public long maxBufferSize(FileType fileType) {
            return this.maxBufferOverride.getOrDefault(fileType, this.maxBufferSize);
        }

        public Map<FileType, Long> maxBufferOverride() {
            return this.maxBufferOverride;
        }

        public long chunkBufferSize() {
            return this.chunkBufferSize(FileType.DATA);
        }

        public long chunkBufferSize(FileType fileType) {
            return this.chunkBufferOverride.getOrDefault(fileType, this.chunkSize);
        }

        public Map<FileType, Long> chunkBufferOverride() {
            return this.chunkBufferOverride;
        }

        public int maxPoolSize() {
            return this.maxPoolSize;
        }

        public int timeoutSeconds() {
            return this.timeoutSeconds;
        }

        @Nullable
        public String cassandraRole() {
            return this.cassandraRole;
        }

        public static ClientConfig create() {
            return ClientConfig.create(-1, 10, 500L);
        }

        public static ClientConfig create(int userProvidedPort, int effectivePort) {
            return ClientConfig.create(userProvidedPort, 10, 500L);
        }

        public static ClientConfig create(int userProvidedPort, int maxRetries, long millisToSleep) {
            return ClientConfig.create(userProvidedPort, maxRetries, millisToSleep, Properties.DEFAULT_MAX_MILLIS_TO_SLEEP, 0x600000L, 0x400000L, 64, Properties.DEFAULT_TIMEOUT_SECONDS, DEFAULT_CASSANDRA_ROLE, Properties.DEFAULT_MAX_BUFFER_OVERRIDE, Properties.DEFAULT_CHUNK_BUFFER_OVERRIDE);
        }

        public static ClientConfig create(Map<String, String> options) {
            Optional userProvidedPort = MapUtils.getOptionalInt(options, (String)SIDECAR_PORT, (String)SIDECAR_PORT);
            return ClientConfig.create(userProvidedPort.orElse(-1), MapUtils.getInt(options, (String)MAX_RETRIES_KEY, (int)10), MapUtils.getLong(options, (String)DEFAULT_MILLIS_TO_SLEEP_KEY, (long)500L), MapUtils.getLong(options, (String)MAX_MILLIS_TO_SLEEP_KEY, (long)Properties.DEFAULT_MAX_MILLIS_TO_SLEEP), MapUtils.getLong(options, (String)MAX_BUFFER_SIZE_BYTES_KEY, (long)0x600000L), MapUtils.getLong(options, (String)CHUNK_BUFFER_SIZE_BYTES_KEY, (long)0x400000L), MapUtils.getInt(options, (String)MAX_POOL_SIZE_KEY, (int)64), MapUtils.getInt(options, (String)TIMEOUT_SECONDS_KEY, (int)Properties.DEFAULT_TIMEOUT_SECONDS), MapUtils.getOrDefault(options, (String)CASSANDRA_ROLE_KEY, (String)DEFAULT_CASSANDRA_ROLE), ClientConfig.buildMaxBufferOverride(options, Properties.DEFAULT_MAX_BUFFER_OVERRIDE), ClientConfig.buildChunkBufferOverride(options, Properties.DEFAULT_CHUNK_BUFFER_OVERRIDE));
        }

        public static Map<FileType, Long> buildMaxBufferOverride(Map<String, String> options, Map<FileType, Long> defaultValue) {
            return ClientConfig.buildOverrideMap(MAX_BUFFER_SIZE_BYTES_KEY, options, defaultValue);
        }

        public static Map<FileType, Long> buildChunkBufferOverride(Map<String, String> options, Map<FileType, Long> defaultValue) {
            return ClientConfig.buildOverrideMap(CHUNK_BUFFER_SIZE_BYTES_KEY, options, defaultValue);
        }

        private static Map<FileType, Long> buildOverrideMap(String keyPrefix, Map<String, String> options, Map<FileType, Long> defaultValue) {
            HashMap<FileType, Long> result = new HashMap<FileType, Long>(defaultValue);
            for (FileType type : FileType.values()) {
                String key = MapUtils.lowerCaseKey((String)String.format("%s_%s", keyPrefix, type.getFileSuffix()));
                Optional.ofNullable(options.get(key)).map(Long::parseLong).ifPresent(s -> result.put(type, (Long)s));
            }
            return result;
        }

        public static ClientConfig create(int userProvidedPort, int maxRetries, long millisToSleep, long maxMillisToSleep, long maxBufferSizeBytes, long chunkSizeBytes, int maxPoolSize, int timeoutSeconds, String cassandraRole, Map<FileType, Long> maxBufferOverride, Map<FileType, Long> chunkBufferOverride) {
            return new ClientConfig(userProvidedPort, maxRetries, millisToSleep, maxMillisToSleep, maxBufferSizeBytes, chunkSizeBytes, maxPoolSize, timeoutSeconds, cassandraRole, maxBufferOverride, chunkBufferOverride);
        }
    }
}

