/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.reader.SSTableCache;
import org.apache.cassandra.spark.sparksql.filters.PartitionKeyFilter;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.apache.cassandra.spark.utils.Pair;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.BloomFilterSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.TokenUtils;
import org.apache.cassandra.utils.vint.VIntCoding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReaderUtils
extends TokenUtils {
    private static final int CHECKSUM_LENGTH = 4;
    private static final Constructor<?> SERIALIZATION_HEADER = Arrays.stream(SerializationHeader.Component.class.getDeclaredConstructors()).filter(constructor -> constructor.getParameterCount() == 5).findFirst().orElseThrow(() -> new RuntimeException("Could not find SerializationHeader.Component constructor"));
    public static final ByteBuffer SUPER_COLUMN_MAP_COLUMN = ByteBufferUtil.EMPTY_BYTE_BUFFER;

    public static Descriptor constructDescriptor(@NotNull String keyspace, @NotNull String table, @NotNull SSTable ssTable) {
        File file = ReaderUtils.constructFilename(keyspace, table, ssTable.getDataFileName());
        return Descriptor.fromFilename((File)file);
    }

    @VisibleForTesting
    @NotNull
    public static File constructFilename(@NotNull String keyspace, @NotNull String table, @NotNull String filename) {
        String[] components = filename.split("-");
        if (components.length == 6 && components[0].equals(keyspace) && components[1].equals(table)) {
            filename = filename.substring(keyspace.length() + table.length() + 2);
        }
        return new File(String.format("./%s/%s", keyspace, table), filename);
    }

    private ReaderUtils() {
        throw new IllegalStateException(String.valueOf(((Object)((Object)this)).getClass()) + " is static utility class and shall not be instantiated");
    }

    static ByteBuffer encodeCellName(TableMetadata metadata, ClusteringPrefix clustering, ByteBuffer columnName, ByteBuffer collectionElement) {
        boolean isStatic;
        boolean bl = isStatic = clustering == Clustering.STATIC_CLUSTERING;
        if (!TableMetadata.Flag.isCompound((Set)metadata.flags)) {
            if (isStatic) {
                return columnName;
            }
            assert (clustering.size() == 1) : "Expected clustering size to be 1, but was " + clustering.size();
            return clustering.bufferAt(0);
        }
        int clusteringSize = metadata.comparator.size();
        int size = clusteringSize + (TableMetadata.Flag.isDense((Set)metadata.flags) ? 0 : 1) + (collectionElement == null ? 0 : 1);
        if (TableMetadata.Flag.isSuper((Set)metadata.flags)) {
            size = clusteringSize + 1;
        }
        Object[] values = new ByteBuffer[size];
        for (int index = 0; index < clusteringSize; ++index) {
            if (isStatic) {
                values[index] = ByteBufferUtil.EMPTY_BYTE_BUFFER;
                continue;
            }
            ByteBuffer value = clustering.bufferAt(index);
            if (value == null) {
                return (ByteBuffer)CompositeType.build((ValueAccessor)ByteBufferAccessor.instance, (Object[])Arrays.copyOfRange(values, 0, index));
            }
            values[index] = value;
        }
        if (TableMetadata.Flag.isSuper((Set)metadata.flags)) {
            assert (columnName != null);
            values[clusteringSize] = columnName.equals(SUPER_COLUMN_MAP_COLUMN) ? collectionElement : columnName;
        } else {
            if (!TableMetadata.Flag.isDense((Set)metadata.flags)) {
                values[clusteringSize] = columnName;
            }
            if (collectionElement != null) {
                values[clusteringSize + 1] = collectionElement;
            }
        }
        return (ByteBuffer)CompositeType.build((ValueAccessor)ByteBufferAccessor.instance, (boolean)isStatic, (Object[])values);
    }

    @Nullable
    public static Pair<DecoratedKey, DecoratedKey> keysFromIndex(@NotNull TableMetadata metadata, @NotNull SSTable ssTable) throws IOException {
        return ReaderUtils.keysFromIndex(metadata.partitioner, ssTable);
    }

    @Nullable
    public static Pair<DecoratedKey, DecoratedKey> keysFromIndex(@NotNull IPartitioner partitioner, @NotNull SSTable ssTable) throws IOException {
        try (InputStream primaryIndex = ssTable.openPrimaryIndexStream();){
            if (primaryIndex != null) {
                Pair<ByteBuffer, ByteBuffer> keys = ReaderUtils.primaryIndexReadFirstAndLastKey(primaryIndex);
                Pair pair = Pair.of((Object)partitioner.decorateKey((ByteBuffer)keys.left), (Object)partitioner.decorateKey((ByteBuffer)keys.right));
                return pair;
            }
        }
        return null;
    }

    public static boolean anyFilterKeyInIndex(@NotNull SSTable ssTable, @NotNull List<PartitionKeyFilter> filters) throws IOException {
        if (filters.isEmpty()) {
            return false;
        }
        try (InputStream primaryIndex = ssTable.openPrimaryIndexStream();){
            if (primaryIndex != null) {
                boolean bl = ReaderUtils.primaryIndexContainsAnyKey(primaryIndex, filters);
                return bl;
            }
        }
        return true;
    }

    public static Map<MetadataType, MetadataComponent> deserializeStatsMetadata(String keyspace, String table, SSTable ssTable, EnumSet<MetadataType> selectedTypes) throws IOException {
        return ReaderUtils.deserializeStatsMetadata(ssTable, selectedTypes, ReaderUtils.constructDescriptor(keyspace, table, ssTable));
    }

    public static Map<MetadataType, MetadataComponent> deserializeStatsMetadata(SSTable ssTable, Descriptor descriptor) throws IOException {
        return ReaderUtils.deserializeStatsMetadata(ssTable, EnumSet.of(MetadataType.VALIDATION, MetadataType.STATS, MetadataType.HEADER), descriptor);
    }

    public static Map<MetadataType, MetadataComponent> deserializeStatsMetadata(SSTable ssTable, EnumSet<MetadataType> selectedTypes, Descriptor descriptor) throws IOException {
        try (InputStream statsStream = ssTable.openStatsStream();){
            Map<MetadataType, MetadataComponent> map = ReaderUtils.deserializeStatsMetadata(statsStream, selectedTypes, descriptor);
            return map;
        }
    }

    static Map<MetadataType, MetadataComponent> deserializeStatsMetadata(InputStream is, EnumSet<MetadataType> selectedTypes, Descriptor descriptor) throws IOException {
        byte[] bytes;
        int index;
        DataInputPlus.DataInputStreamPlus in = new DataInputPlus.DataInputStreamPlus(is);
        boolean isChecksummed = descriptor.version.hasMetadataChecksum();
        CRC32 crc = new CRC32();
        int count = in.readInt();
        FBUtilities.updateChecksumInt((Checksum)crc, (int)count);
        ReaderUtils.maybeValidateChecksum(crc, (DataInputStream)in, descriptor);
        int[] ordinals = new int[count];
        int[] offsets = new int[count];
        int[] lengths = new int[count];
        for (index = 0; index < count; ++index) {
            ordinals[index] = in.readInt();
            FBUtilities.updateChecksumInt((Checksum)crc, (int)ordinals[index]);
            offsets[index] = in.readInt();
            FBUtilities.updateChecksumInt((Checksum)crc, (int)offsets[index]);
        }
        ReaderUtils.maybeValidateChecksum(crc, (DataInputStream)in, descriptor);
        for (index = 0; index < count - 1; ++index) {
            lengths[index] = offsets[index + 1] - offsets[index];
        }
        MetadataType[] allMetadataTypes = MetadataType.values();
        EnumMap<MetadataType, MetadataComponent> components = new EnumMap<MetadataType, MetadataComponent>(MetadataType.class);
        for (int index2 = 0; index2 < count - 1; ++index2) {
            MetadataType type = allMetadataTypes[ordinals[index2]];
            if (!selectedTypes.contains(type)) {
                in.skipBytes(lengths[index2]);
                continue;
            }
            bytes = new byte[isChecksummed ? lengths[index2] - 4 : lengths[index2]];
            in.readFully(bytes);
            crc.reset();
            crc.update(bytes);
            ReaderUtils.maybeValidateChecksum(crc, (DataInputStream)in, descriptor);
            components.put(type, ReaderUtils.deserializeMetadataComponent(descriptor.version, bytes, type));
        }
        MetadataType type = allMetadataTypes[ordinals[count - 1]];
        if (!selectedTypes.contains(type)) {
            return components;
        }
        byte[] remainingBytes = ByteBufferUtils.readRemainingBytes((InputStream)in, (int)256);
        if (descriptor.version.hasMetadataChecksum()) {
            ByteBuffer buffer = ByteBuffer.wrap(remainingBytes);
            int length = buffer.remaining() - 4;
            bytes = new byte[length];
            buffer.get(bytes, 0, length);
            crc.reset();
            crc.update(bytes);
            ReaderUtils.validateChecksum(crc, buffer.getInt(), descriptor);
        } else {
            bytes = remainingBytes;
        }
        components.put(type, ReaderUtils.deserializeMetadataComponent(descriptor.version, bytes, type));
        return components;
    }

    private static void maybeValidateChecksum(CRC32 crc, DataInputStream in, Descriptor descriptor) throws IOException {
        if (descriptor.version.hasMetadataChecksum()) {
            ReaderUtils.validateChecksum(crc, in.readInt(), descriptor);
        }
    }

    private static void validateChecksum(CRC32 crc, int expectedChecksum, Descriptor descriptor) {
        int actualChecksum = (int)crc.getValue();
        if (actualChecksum != expectedChecksum) {
            String filename = descriptor.filenameFor(Component.STATS);
            throw new CorruptSSTableException((Throwable)new IOException("Checksums do not match for " + filename), filename);
        }
    }

    private static MetadataComponent deserializeValidationMetaData(@NotNull DataInputBuffer in) throws IOException {
        return new ValidationMetadata(in.readUTF(), in.readDouble());
    }

    private static MetadataComponent deserializeMetadataComponent(@NotNull Version version, @NotNull byte[] buffer, @NotNull MetadataType type) throws IOException {
        DataInputBuffer in = new DataInputBuffer(buffer);
        if (type == MetadataType.HEADER) {
            return ReaderUtils.deserializeSerializationHeader(in);
        }
        if (type == MetadataType.VALIDATION) {
            return ReaderUtils.deserializeValidationMetaData(in);
        }
        return type.serializer.deserialize(version, (DataInputPlus)in);
    }

    private static MetadataComponent deserializeSerializationHeader(@NotNull DataInputBuffer in) throws IOException {
        EncodingStats stats = EncodingStats.serializer.deserialize((DataInputPlus)in);
        AbstractType<?> keyType = ReaderUtils.readType((DataInputPlus)in);
        int size = (int)in.readUnsignedVInt();
        ArrayList clusteringTypes = new ArrayList(size);
        for (int index = 0; index < size; ++index) {
            clusteringTypes.add(ReaderUtils.readType((DataInputPlus)in));
        }
        LinkedHashMap staticColumns = new LinkedHashMap();
        LinkedHashMap regularColumns = new LinkedHashMap();
        ReaderUtils.readColumnsWithType((DataInputPlus)in, staticColumns);
        ReaderUtils.readColumnsWithType((DataInputPlus)in, regularColumns);
        try {
            return (SerializationHeader.Component)SERIALIZATION_HEADER.newInstance(keyType, clusteringTypes, staticColumns, regularColumns, stats);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void readColumnsWithType(@NotNull DataInputPlus in, @NotNull Map<ByteBuffer, AbstractType<?>> typeMap) throws IOException {
        int length = (int)in.readUnsignedVInt();
        for (int index = 0; index < length; ++index) {
            ByteBuffer name = ByteBufferUtil.readWithVIntLength((DataInputPlus)in);
            typeMap.put(name, ReaderUtils.readType(in));
        }
    }

    private static AbstractType<?> readType(@NotNull DataInputPlus in) throws IOException {
        return TypeParser.parse((String)((String)UTF8Type.instance.compose(ByteBufferUtil.readWithVIntLength((DataInputPlus)in))));
    }

    public static Pair<ByteBuffer, ByteBuffer> primaryIndexReadFirstAndLastKey(@NotNull InputStream primaryIndex) throws IOException {
        ByteBuffer[] firstAndLast = new ByteBuffer[]{null, null};
        ReaderUtils.readPrimaryIndex(primaryIndex, buffer -> {
            if (firstAndLast[0] == null) {
                firstAndLast[0] = buffer;
            }
            firstAndLast[1] = buffer;
            return false;
        });
        return Pair.of((Object)firstAndLast[0], (Object)firstAndLast[1]);
    }

    public static boolean primaryIndexContainsAnyKey(@NotNull InputStream primaryIndex, @NotNull List<PartitionKeyFilter> filters) throws IOException {
        boolean[] result = new boolean[]{false};
        ReaderUtils.readPrimaryIndex(primaryIndex, buffer -> {
            boolean anyMatch = filters.stream().anyMatch(filter -> filter.matches(buffer));
            if (anyMatch) {
                result[0] = true;
                return true;
            }
            return false;
        });
        return result[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readPrimaryIndex(@NotNull InputStream primaryIndex, @NotNull Function<ByteBuffer, Boolean> tracker) throws IOException {
        dis = new DataInputStream(primaryIndex);
        while (true) {
            try {
                length = dis.readUnsignedShort();
                array = new byte[length];
                dis.readFully(array);
                buffer = ByteBuffer.wrap(array);
                if (tracker.apply(buffer).booleanValue()) {
                }
                ** GOTO lbl-1000
            }
            catch (EOFException var3_4) {
                dis.close();
                return;
            }
            catch (Throwable var3_5) {
                try {
                    dis.close();
                    throw var3_5;
                }
                catch (Throwable var4_7) {
                    var3_5.addSuppressed(var4_7);
                }
                throw var3_5;
            }
            dis.close();
            return;
lbl-1000:
            // 1 sources

            {
                ReaderUtils.skipRowIndexEntry(dis);
                continue;
            }
            break;
        }
    }

    static void skipRowIndexEntry(DataInputStream dis) throws IOException {
        ReaderUtils.readPosition(dis);
        ReaderUtils.skipPromotedIndex(dis);
    }

    static int vIntSize(long value) {
        return VIntCoding.computeUnsignedVIntSize((long)value);
    }

    static void writePosition(long value, ByteBuffer buffer) {
        VIntCoding.writeUnsignedVInt((long)value, (ByteBuffer)buffer);
    }

    static long readPosition(DataInputStream dis) throws IOException {
        return VIntCoding.readUnsignedVInt((DataInput)dis);
    }

    public static int skipPromotedIndex(DataInputStream dis) throws IOException {
        long val = VIntCoding.readUnsignedVInt((DataInput)dis);
        int size = (int)val;
        if (size > 0) {
            ByteBufferUtils.skipBytesFully((DataInput)dis, (int)size);
        }
        return Math.max(size, 0) + VIntCoding.computeUnsignedVIntSize((long)val);
    }

    static List<PartitionKeyFilter> filterKeyInBloomFilter(@NotNull SSTable ssTable, @NotNull IPartitioner partitioner, Descriptor descriptor, @NotNull List<PartitionKeyFilter> partitionKeyFilters) throws IOException {
        try {
            BloomFilter bloomFilter = SSTableCache.INSTANCE.bloomFilter(ssTable, descriptor);
            return partitionKeyFilters.stream().filter(filter -> bloomFilter.isPresent((IFilter.FilterKey)partitioner.decorateKey(filter.key()))).collect(Collectors.toList());
        }
        catch (Exception exception) {
            if (exception instanceof FileNotFoundException) {
                return partitionKeyFilters;
            }
            throw exception;
        }
    }

    public static BloomFilter readFilter(@NotNull SSTable ssTable, Descriptor descriptor) throws IOException {
        return ReaderUtils.readFilter(ssTable, descriptor.version.hasOldBfFormat());
    }

    public static BloomFilter readFilter(@NotNull SSTable ssTable, boolean hasOldBfFormat) throws IOException {
        block11: {
            try (InputStream filterStream = ssTable.openFilterStream();){
                BloomFilter bloomFilter;
                if (filterStream == null) break block11;
                try (DataInputStream dis = new DataInputStream(filterStream);){
                    bloomFilter = BloomFilterSerializer.deserialize((DataInputStream)dis, (boolean)hasOldBfFormat);
                }
                return bloomFilter;
            }
        }
        throw new FileNotFoundException();
    }

    static {
        SERIALIZATION_HEADER.setAccessible(true);
    }
}

