/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.analytics.DataGenerationUtils;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.spark.bulkwriter.WriterOptions;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class WriterDigestIntegrationTest
extends SharedClusterSparkIntegrationTestBase {
    static final QualifiedName DEFAULT_DIGEST_TABLE = TestUtils.uniqueTestTableFullName((String)"default_digest");
    static final QualifiedName MD5_DIGEST_TABLE = TestUtils.uniqueTestTableFullName((String)"md5_digest");
    static final QualifiedName CORRUPT_SSTABLE_TABLE = TestUtils.uniqueTestTableFullName((String)"corrupt_sstable");
    static final List<QualifiedName> TABLE_NAMES = Arrays.asList(DEFAULT_DIGEST_TABLE, MD5_DIGEST_TABLE, CORRUPT_SSTABLE_TABLE);
    Dataset<Row> df;

    WriterDigestIntegrationTest() {
    }

    @Test
    void testDefaultDigest() {
        this.bulkWriterDataFrameWriter(this.df, DEFAULT_DIGEST_TABLE).save();
        this.sparkTestUtils.validateWrites(this.df.collectAsList(), this.queryAllData(DEFAULT_DIGEST_TABLE));
    }

    @Test
    void testMD5Digest() {
        SparkSession spark = this.getOrCreateSparkSession();
        Dataset<Row> df = DataGenerationUtils.generateCourseData(spark, 1000);
        this.bulkWriterDataFrameWriter(df, MD5_DIGEST_TABLE).option(WriterOptions.DIGEST.name(), "MD5").save();
        this.sparkTestUtils.validateWrites(df.collectAsList(), this.queryAllData(MD5_DIGEST_TABLE));
    }

    @Test
    void failsOnInvalidDigestOption() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.bulkWriterDataFrameWriter(this.df, DEFAULT_DIGEST_TABLE).option(WriterOptions.DIGEST.name(), "invalid").save()).withMessageContaining("Key digest type with value invalid is not a valid Enum of type class org.apache.cassandra.spark.bulkwriter.DigestAlgorithms");
    }

    @Override
    protected void beforeTestStart() {
        super.beforeTestStart();
        SparkSession spark = this.getOrCreateSparkSession();
        this.df = DataGenerationUtils.generateCourseData(spark, 1000);
    }

    protected void initializeSchemaForTest() {
        TABLE_NAMES.forEach(name -> {
            this.createTestKeyspace((QualifiedName)name, TestUtils.DC1_RF1);
            this.createTestTable((QualifiedName)name, "CREATE TABLE IF NOT EXISTS %s (id int, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';");
        });
    }
}

