/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client.request;

import org.apache.cassandra.sidecar.client.RequestContext;
import org.apache.cassandra.sidecar.client.request.RequestTestParameters;
import org.apache.cassandra.sidecar.common.response.SchemaResponse;
import org.assertj.core.api.Assertions;

public class FullSchemaRequestTestParameters
implements RequestTestParameters<SchemaResponse> {
    @Override
    public RequestContext.Builder specificRequest(RequestContext.Builder requestContextBuilder) {
        return requestContextBuilder.schemaRequest();
    }

    @Override
    public String okResponseBody() {
        return "{\"schema\":\"CREATE KEYSPACE system_traces ...\"}";
    }

    @Override
    public String expectedEndpointPath() {
        return "/api/v1/cassandra/schema";
    }

    @Override
    public void validateResponse(SchemaResponse response) {
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((String)response.keyspace()).isNull();
        Assertions.assertThat((String)response.schema()).contains(new CharSequence[]{"CREATE KEYSPACE system_traces"});
    }
}

