/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Condition;
import org.apache.cassandra.utils.concurrent.WaitQueue;

public class SimpleCondition
implements Condition {
    private static final AtomicReferenceFieldUpdater<SimpleCondition, WaitQueue> waitingUpdater = AtomicReferenceFieldUpdater.newUpdater(SimpleCondition.class, WaitQueue.class, "waiting");
    private volatile WaitQueue waiting;
    private volatile boolean signaled = false;

    @Override
    public void await() throws InterruptedException {
        if (this.isSignaled()) {
            return;
        }
        if (this.waiting == null) {
            waitingUpdater.compareAndSet(this, null, new WaitQueue());
        }
        WaitQueue.Signal s2 = this.waiting.register();
        if (this.isSignaled()) {
            s2.cancel();
        } else {
            s2.await();
        }
        assert (this.isSignaled());
    }

    @Override
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        long start = System.nanoTime();
        long until = start + unit.toNanos(time);
        return this.awaitUntil(until);
    }

    public boolean awaitUntil(long deadlineNanos) throws InterruptedException {
        if (this.isSignaled()) {
            return true;
        }
        if (this.waiting == null) {
            waitingUpdater.compareAndSet(this, null, new WaitQueue());
        }
        WaitQueue.Signal s2 = this.waiting.register();
        if (this.isSignaled()) {
            s2.cancel();
            return true;
        }
        return s2.awaitUntil(deadlineNanos) || this.isSignaled();
    }

    @Override
    public void signal() {
        throw new UnsupportedOperationException();
    }

    public boolean isSignaled() {
        return this.signaled;
    }

    @Override
    public void signalAll() {
        this.signaled = true;
        if (this.waiting != null) {
            this.waiting.signalAll();
        }
    }

    @Override
    public void awaitUninterruptibly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long awaitNanos(long nanosTimeout) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean awaitUntil(Date deadline) {
        throw new UnsupportedOperationException();
    }
}

