/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.UUID;
import org.apache.cassandra.diag.DiagnosticEventService;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.schema.SchemaMigrationEvent;

final class SchemaMigrationDiagnostics {
    private static final DiagnosticEventService service = DiagnosticEventService.instance();

    private SchemaMigrationDiagnostics() {
    }

    static void unknownLocalSchemaVersion(InetAddressAndPort endpoint, UUID theirVersion) {
        if (SchemaMigrationDiagnostics.isEnabled(SchemaMigrationEvent.MigrationManagerEventType.UNKNOWN_LOCAL_SCHEMA_VERSION)) {
            service.publish(new SchemaMigrationEvent(SchemaMigrationEvent.MigrationManagerEventType.UNKNOWN_LOCAL_SCHEMA_VERSION, endpoint, theirVersion));
        }
    }

    static void versionMatch(InetAddressAndPort endpoint, UUID theirVersion) {
        if (SchemaMigrationDiagnostics.isEnabled(SchemaMigrationEvent.MigrationManagerEventType.VERSION_MATCH)) {
            service.publish(new SchemaMigrationEvent(SchemaMigrationEvent.MigrationManagerEventType.VERSION_MATCH, endpoint, theirVersion));
        }
    }

    static void skipPull(InetAddressAndPort endpoint, UUID theirVersion) {
        if (SchemaMigrationDiagnostics.isEnabled(SchemaMigrationEvent.MigrationManagerEventType.SKIP_PULL)) {
            service.publish(new SchemaMigrationEvent(SchemaMigrationEvent.MigrationManagerEventType.SKIP_PULL, endpoint, theirVersion));
        }
    }

    static void resetLocalSchema() {
        if (SchemaMigrationDiagnostics.isEnabled(SchemaMigrationEvent.MigrationManagerEventType.RESET_LOCAL_SCHEMA)) {
            service.publish(new SchemaMigrationEvent(SchemaMigrationEvent.MigrationManagerEventType.RESET_LOCAL_SCHEMA, null, null));
        }
    }

    static void taskCreated(InetAddressAndPort endpoint) {
        if (SchemaMigrationDiagnostics.isEnabled(SchemaMigrationEvent.MigrationManagerEventType.TASK_CREATED)) {
            service.publish(new SchemaMigrationEvent(SchemaMigrationEvent.MigrationManagerEventType.TASK_CREATED, endpoint, null));
        }
    }

    static void taskSendAborted(InetAddressAndPort endpoint) {
        if (SchemaMigrationDiagnostics.isEnabled(SchemaMigrationEvent.MigrationManagerEventType.TASK_SEND_ABORTED)) {
            service.publish(new SchemaMigrationEvent(SchemaMigrationEvent.MigrationManagerEventType.TASK_SEND_ABORTED, endpoint, null));
        }
    }

    static void taskRequestSend(InetAddressAndPort endpoint) {
        if (SchemaMigrationDiagnostics.isEnabled(SchemaMigrationEvent.MigrationManagerEventType.TASK_REQUEST_SEND)) {
            service.publish(new SchemaMigrationEvent(SchemaMigrationEvent.MigrationManagerEventType.TASK_REQUEST_SEND, endpoint, null));
        }
    }

    private static boolean isEnabled(SchemaMigrationEvent.MigrationManagerEventType type) {
        return service.isEnabled(SchemaMigrationEvent.class, type);
    }
}

