/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.AbstractUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.DeserializationHelper;
import org.apache.cassandra.db.rows.LazilyInitializedUnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIteratorSerializer;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.transform.FilteredPartitions;
import org.apache.cassandra.db.transform.MorePartitions;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.MergeIterator;

public abstract class UnfilteredPartitionIterators {
    private static final Serializer serializer = new Serializer();
    private static final Comparator<UnfilteredRowIterator> partitionComparator = (p1, p2) -> p1.partitionKey().compareTo(p2.partitionKey());

    private UnfilteredPartitionIterators() {
    }

    public static UnfilteredRowIterator getOnlyElement(UnfilteredPartitionIterator iter2, SinglePartitionReadCommand command) {
        UnfilteredRowIterator toReturn = iter2.hasNext() ? (UnfilteredRowIterator)iter2.next() : EmptyIterators.unfilteredRow(command.metadata(), command.partitionKey(), command.clusteringIndexFilter().isReversed());
        class Close
        extends Transformation {
            final /* synthetic */ UnfilteredPartitionIterator val$iter;

            Close(UnfilteredPartitionIterator unfilteredPartitionIterator) {
                this.val$iter = unfilteredPartitionIterator;
            }

            @Override
            public void onPartitionClose() {
                boolean hadNext = this.val$iter.hasNext();
                this.val$iter.close();
                assert (!hadNext);
            }
        }
        return Transformation.apply(toReturn, new Close(iter2));
    }

    public static UnfilteredPartitionIterator concat(List<UnfilteredPartitionIterator> iterators) {
        if (iterators.size() == 1) {
            return iterators.get(0);
        }
        class Extend
        implements MorePartitions<UnfilteredPartitionIterator> {
            int i = 1;
            final /* synthetic */ List val$iterators;

            Extend(List list) {
                this.val$iterators = list;
            }

            @Override
            public UnfilteredPartitionIterator moreContents() {
                if (this.i >= this.val$iterators.size()) {
                    return null;
                }
                return (UnfilteredPartitionIterator)this.val$iterators.get(this.i++);
            }
        }
        return MorePartitions.extend(iterators.get(0), new Extend(iterators));
    }

    public static PartitionIterator filter(UnfilteredPartitionIterator iterator, int nowInSec) {
        return FilteredPartitions.filter(iterator, nowInSec);
    }

    public static UnfilteredPartitionIterator merge(final List<? extends UnfilteredPartitionIterator> iterators, final MergeListener listener) {
        assert (!iterators.isEmpty());
        final TableMetadata metadata = iterators.get(0).metadata();
        final boolean preserveOrder = listener != null && listener.preserveOrder();
        final MergeIterator<UnfilteredRowIterator, UnfilteredRowIterator> merged = MergeIterator.get(iterators, partitionComparator, new MergeIterator.Reducer<UnfilteredRowIterator, UnfilteredRowIterator>(){
            private final List<UnfilteredRowIterator> toMerge;
            private DecoratedKey partitionKey;
            private boolean isReverseOrder;
            {
                this.toMerge = new ArrayList<UnfilteredRowIterator>(iterators.size());
            }

            @Override
            public void reduce(int idx, UnfilteredRowIterator current) {
                this.partitionKey = current.partitionKey();
                this.isReverseOrder = current.isReverseOrder();
                if (preserveOrder) {
                    this.toMerge.set(idx, current);
                } else {
                    this.toMerge.add(current);
                }
            }

            @Override
            protected UnfilteredRowIterator getReduced() {
                UnfilteredRowIterators.MergeListener rowListener;
                UnfilteredRowIterators.MergeListener mergeListener = rowListener = listener == null ? null : listener.getRowMergeListener(this.partitionKey, this.toMerge);
                if (preserveOrder) {
                    UnfilteredRowIterator empty = null;
                    for (int i = 0; i < this.toMerge.size(); ++i) {
                        if (this.toMerge.get(i) != null) continue;
                        if (null == empty) {
                            empty = EmptyIterators.unfilteredRow(metadata, this.partitionKey, this.isReverseOrder);
                        }
                        this.toMerge.set(i, empty);
                    }
                }
                return UnfilteredRowIterators.merge(this.toMerge, rowListener);
            }

            @Override
            protected void onKeyChange() {
                this.toMerge.clear();
                if (preserveOrder) {
                    for (int i = 0; i < iterators.size(); ++i) {
                        this.toMerge.add(null);
                    }
                }
            }
        });
        return new AbstractUnfilteredPartitionIterator(){

            @Override
            public TableMetadata metadata() {
                return metadata;
            }

            @Override
            public boolean hasNext() {
                return merged.hasNext();
            }

            @Override
            public UnfilteredRowIterator next() {
                return (UnfilteredRowIterator)merged.next();
            }

            @Override
            public void close() {
                merged.close();
                if (listener != null) {
                    listener.close();
                }
            }
        };
    }

    public static UnfilteredPartitionIterator mergeLazily(final List<? extends UnfilteredPartitionIterator> iterators) {
        assert (!iterators.isEmpty());
        if (iterators.size() == 1) {
            return iterators.get(0);
        }
        final TableMetadata metadata = iterators.get(0).metadata();
        final MergeIterator<UnfilteredRowIterator, UnfilteredRowIterator> merged = MergeIterator.get(iterators, partitionComparator, new MergeIterator.Reducer<UnfilteredRowIterator, UnfilteredRowIterator>(){
            private final List<UnfilteredRowIterator> toMerge;
            {
                this.toMerge = new ArrayList<UnfilteredRowIterator>(iterators.size());
            }

            @Override
            public void reduce(int idx, UnfilteredRowIterator current) {
                this.toMerge.add(current);
            }

            @Override
            protected UnfilteredRowIterator getReduced() {
                return new LazilyInitializedUnfilteredRowIterator(this.toMerge.get(0).partitionKey()){

                    @Override
                    protected UnfilteredRowIterator initializeIterator() {
                        return UnfilteredRowIterators.merge(toMerge);
                    }
                };
            }

            @Override
            protected void onKeyChange() {
                this.toMerge.clear();
            }
        });
        return new AbstractUnfilteredPartitionIterator(){

            @Override
            public TableMetadata metadata() {
                return metadata;
            }

            @Override
            public boolean hasNext() {
                return merged.hasNext();
            }

            @Override
            public UnfilteredRowIterator next() {
                return (UnfilteredRowIterator)merged.next();
            }

            @Override
            public void close() {
                merged.close();
            }
        };
    }

    public static void digest(UnfilteredPartitionIterator iterator, Digest digest, int version) {
        while (iterator.hasNext()) {
            UnfilteredRowIterator partition = (UnfilteredRowIterator)iterator.next();
            Throwable throwable = null;
            try {
                UnfilteredRowIterators.digest(partition, digest, version);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (partition == null) continue;
                if (throwable != null) {
                    try {
                        partition.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                partition.close();
            }
        }
    }

    public static Serializer serializerForIntraNode() {
        return serializer;
    }

    public static UnfilteredPartitionIterator loggingIterator(UnfilteredPartitionIterator iterator, final String id, final boolean fullDetails) {
        class Logging
        extends Transformation<UnfilteredRowIterator> {
            Logging() {
            }

            @Override
            public UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
                return UnfilteredRowIterators.loggingIterator(partition, id, fullDetails);
            }
        }
        return Transformation.apply(iterator, new Logging());
    }

    public static class Serializer {
        public void serialize(UnfilteredPartitionIterator iter2, ColumnFilter selection, DataOutputPlus out, int version) throws IOException {
            out.writeBoolean(false);
            while (iter2.hasNext()) {
                out.writeBoolean(true);
                UnfilteredRowIterator partition = (UnfilteredRowIterator)iter2.next();
                Throwable throwable = null;
                try {
                    UnfilteredRowIteratorSerializer.serializer.serialize(partition, selection, out, version);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (partition == null) continue;
                    if (throwable != null) {
                        try {
                            partition.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    partition.close();
                }
            }
            out.writeBoolean(false);
        }

        public UnfilteredPartitionIterator deserialize(final DataInputPlus in, final int version, final TableMetadata metadata, final ColumnFilter selection, final DeserializationHelper.Flag flag) throws IOException {
            in.readBoolean();
            return new AbstractUnfilteredPartitionIterator(){
                private UnfilteredRowIterator next;
                private boolean hasNext;
                private boolean nextReturned = true;

                @Override
                public TableMetadata metadata() {
                    return metadata;
                }

                @Override
                public boolean hasNext() {
                    if (!this.nextReturned) {
                        return this.hasNext;
                    }
                    if (null != this.next) {
                        while (this.next.hasNext()) {
                            this.next.next();
                        }
                    }
                    try {
                        this.hasNext = in.readBoolean();
                        this.nextReturned = false;
                        return this.hasNext;
                    }
                    catch (IOException e) {
                        throw new IOError(e);
                    }
                }

                @Override
                public UnfilteredRowIterator next() {
                    if (this.nextReturned && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        this.nextReturned = true;
                        this.next = UnfilteredRowIteratorSerializer.serializer.deserialize(in, version, metadata, selection, flag);
                        return this.next;
                    }
                    catch (IOException e) {
                        throw new IOError(e);
                    }
                }

                @Override
                public void close() {
                    if (this.next != null) {
                        this.next.close();
                    }
                }
            };
        }
    }

    public static interface MergeListener {
        public static final MergeListener NOOP = new MergeListener(){

            @Override
            public boolean preserveOrder() {
                return false;
            }

            @Override
            public UnfilteredRowIterators.MergeListener getRowMergeListener(DecoratedKey partitionKey, List<UnfilteredRowIterator> versions) {
                return UnfilteredRowIterators.MergeListener.NOOP;
            }
        };

        default public boolean preserveOrder() {
            return true;
        }

        public UnfilteredRowIterators.MergeListener getRowMergeListener(DecoratedKey var1, List<UnfilteredRowIterator> var2);

        default public void close() {
        }
    }
}

