/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.BoundedWeigher;
import com.github.benmanes.caffeine.cache.SingletonWeigher;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@FunctionalInterface
@ThreadSafe
public interface Weigher<K, V> {
    @Nonnegative
    public int weigh(@Nonnull K var1, @Nonnull V var2);

    @Nonnull
    public static <K, V> Weigher<K, V> singletonWeigher() {
        SingletonWeigher self = SingletonWeigher.INSTANCE;
        return self;
    }

    @Nonnull
    public static <K, V> Weigher<K, V> boundedWeigher(@Nonnull Weigher<K, V> delegate) {
        return new BoundedWeigher<K, V>(delegate);
    }
}

