/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.MetricNameFactory;

public class MinMaxAvgMetric {
    private final MetricNameFactory factory;
    private final String namePrefix;
    final Gauge<Long> minGauge;
    final Gauge<Long> maxGauge;
    final Gauge<Double> avgGauge;
    final Gauge<Double> stddevGauge;
    final Gauge<Integer> numSamplesGauge;
    private long min;
    private long max;
    private long sum;
    private long sumSquares;
    private int numSamples;

    public MinMaxAvgMetric(MetricNameFactory factory, String namePrefix) {
        this.factory = factory;
        this.namePrefix = namePrefix;
        this.minGauge = CassandraMetricsRegistry.Metrics.register(factory.createMetricName(namePrefix + "Min"), () -> this.min);
        this.maxGauge = CassandraMetricsRegistry.Metrics.register(factory.createMetricName(namePrefix + "Max"), () -> this.max);
        this.avgGauge = CassandraMetricsRegistry.Metrics.register(factory.createMetricName(namePrefix + "Avg"), () -> this.numSamples > 0 ? (double)this.sum / (double)this.numSamples : 0.0);
        this.stddevGauge = CassandraMetricsRegistry.Metrics.register(factory.createMetricName(namePrefix + "StdDev"), () -> this.stddev());
        this.numSamplesGauge = CassandraMetricsRegistry.Metrics.register(factory.createMetricName(namePrefix + "NumSamples"), () -> this.numSamples);
    }

    public void release() {
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(this.namePrefix + "Min"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(this.namePrefix + "Max"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(this.namePrefix + "Avg"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(this.namePrefix + "StdDev"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(this.namePrefix + "NumSamples"));
    }

    public void reset() {
        this.sum = 0L;
        this.sumSquares = 0L;
        this.max = Long.MIN_VALUE;
        this.min = Long.MAX_VALUE;
        this.numSamples = 0;
    }

    public void update(long value) {
        this.max = this.max > value ? this.max : value;
        this.min = this.min < value ? this.min : value;
        this.sum += value;
        this.sumSquares += value * value;
        ++this.numSamples;
    }

    private Double stddev() {
        if (this.numSamples > 0) {
            double avgSquare = (double)this.sumSquares / (double)this.numSamples;
            double avg = (double)this.sum / (double)this.numSamples;
            return Math.sqrt(avgSquare - avg * avg);
        }
        return 0.0;
    }

    public String toString() {
        return "{min=" + this.min + ", max=" + this.max + ", avg=" + (double)this.sum * 1.0 / (double)this.numSamples + ", stdDev=" + this.stddev() + ", numSamples=" + this.numSamples + "}";
    }
}

