/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.util.Recycler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.function.LongPredicate;
import org.apache.bookkeeper.util.collections.ConcurrentLongLongHashMap;

public class EntryLogMetadata {
    protected long entryLogId;
    protected long totalSize;
    protected long remainingSize;
    protected final ConcurrentLongLongHashMap ledgersMap = ConcurrentLongLongHashMap.newBuilder().expectedItems(256).concurrencyLevel(1).build();
    private static final short DEFAULT_SERIALIZATION_VERSION = 0;

    protected EntryLogMetadata() {
    }

    public EntryLogMetadata(long logId) {
        this();
        this.entryLogId = logId;
        this.remainingSize = 0L;
        this.totalSize = 0L;
    }

    public void addLedgerSize(long ledgerId, long size) {
        this.totalSize += size;
        this.remainingSize += size;
        this.ledgersMap.addAndGet(ledgerId, size);
    }

    public boolean containsLedger(long ledgerId) {
        return this.ledgersMap.containsKey(ledgerId);
    }

    public double getUsage() {
        if (this.totalSize == 0L) {
            return 0.0;
        }
        return (double)this.remainingSize / (double)this.totalSize;
    }

    public boolean isEmpty() {
        return this.ledgersMap.isEmpty();
    }

    public long getEntryLogId() {
        return this.entryLogId;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getRemainingSize() {
        return this.remainingSize;
    }

    public ConcurrentLongLongHashMap getLedgersMap() {
        return this.ledgersMap;
    }

    public void removeLedgerIf(LongPredicate predicate) {
        this.ledgersMap.removeIf((ledgerId, size) -> {
            boolean shouldRemove = predicate.test(ledgerId);
            if (shouldRemove) {
                this.remainingSize -= size;
            }
            return shouldRemove;
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{totalSize = ").append(this.totalSize).append(", remainingSize = ").append(this.remainingSize).append(", ledgersMap = ").append(this.ledgersMap.toString()).append("}");
        return sb.toString();
    }

    public void serialize(DataOutputStream out) throws IOException, IllegalStateException {
        out.writeShort(0);
        out.writeLong(this.entryLogId);
        out.writeLong(this.totalSize);
        out.writeLong(this.remainingSize);
        out.writeLong(this.ledgersMap.size());
        this.ledgersMap.forEach((ledgerId, size) -> {
            try {
                out.writeLong(ledgerId);
                out.writeLong(size);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to serialize entryLogMetadata", e);
            }
        });
        out.flush();
    }

    public static EntryLogMetadataRecyclable deserialize(DataInputStream in) throws IOException {
        EntryLogMetadataRecyclable metadata = EntryLogMetadataRecyclable.get();
        try {
            short serVersion = in.readShort();
            if (serVersion != 0) {
                throw new IOException(String.format("%s. expected =%d, found=%d", "serialization version doesn't match", (short)0, serVersion));
            }
            metadata.entryLogId = in.readLong();
            metadata.totalSize = in.readLong();
            metadata.remainingSize = in.readLong();
            long ledgersMapSize = in.readLong();
            int i = 0;
            while ((long)i < ledgersMapSize) {
                long ledgerId = in.readLong();
                long entryId = in.readLong();
                metadata.ledgersMap.put(ledgerId, entryId);
                ++i;
            }
            return metadata;
        }
        catch (IOException e) {
            metadata.recycle();
            throw e;
        }
        catch (Exception e) {
            metadata.recycle();
            throw new IOException(e);
        }
    }

    public void clear() {
        this.entryLogId = -1L;
        this.totalSize = -1L;
        this.remainingSize = -1L;
        this.ledgersMap.clear();
    }

    public static class EntryLogMetadataRecyclable
    extends EntryLogMetadata {
        private final Recycler.Handle<EntryLogMetadataRecyclable> recyclerHandle;
        private static final Recycler<EntryLogMetadataRecyclable> RECYCLER = new Recycler<EntryLogMetadataRecyclable>(){

            protected EntryLogMetadataRecyclable newObject(Recycler.Handle<EntryLogMetadataRecyclable> handle) {
                return new EntryLogMetadataRecyclable(handle);
            }
        };

        private EntryLogMetadataRecyclable(Recycler.Handle<EntryLogMetadataRecyclable> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        public static EntryLogMetadataRecyclable get() {
            EntryLogMetadataRecyclable metadata = (EntryLogMetadataRecyclable)RECYCLER.get();
            return metadata;
        }

        public void recycle() {
            this.clear();
            this.recyclerHandle.recycle((Object)this);
        }
    }
}

