<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# Apache Parquet Variant Rust Implementation

[![crates.io](https://img.shields.io/crates/v/parquet-variant.svg)](https://crates.io/crates/parquet-variant)
[![docs.rs](https://img.shields.io/docsrs/parquet-variant.svg)](https://docs.rs/parquet/latest/parquet-variant/)

This crate contains an implementation of [Variant Binary Encoding] from
[Apache Parquet]. This software is developed as part of the [Apache Arrow] project.

[Variant Binary Encoding]: https://github.com/apache/parquet-format/blob/master/VariantEncoding.md
[Apache Parquet]: https://parquet.apache.org/
[Apache Arrow]: https://arrow.apache.org/

Please see the [API documentation](https://docs.rs/parquet-variant/latest) for more details.

## 🚧 Work In Progress

NOTE: This crate is under active development and is not yet ready for production use. 
If you are interested in helping, you can find more information on the GitHub [Variant issue]

[Variant issue]: https://github.com/apache/arrow-rs/issues/6736


## License

Licensed under the Apache License, Version 2.0: <http://www.apache.org/licenses/LICENSE-2.0>.
