/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JToolBar;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.util.Arrays;

public final class JToolBarLocation {
    private static String[] VALID_CONSTRAINTS = new String[]{"North", "East", "South", "West"};

    @Nonnull
    @RunsInCurrentThread
    public Point pointToGrab(@Nonnull JToolBar toolBar) {
        Insets insets = toolBar.getInsets();
        int width = toolBar.getWidth();
        int height = toolBar.getHeight();
        if (Math.max(Math.max(Math.max(insets.left, insets.top), insets.right), insets.bottom) == insets.left) {
            return new Point(insets.left / 2, height / 2);
        }
        if (Math.max(Math.max(insets.top, insets.right), insets.bottom) == insets.top) {
            return new Point(width / 2, insets.top / 2);
        }
        if (Math.max(insets.right, insets.bottom) == insets.right) {
            return new Point(width - insets.right / 2, height / 2);
        }
        return new Point(width / 2, height - insets.bottom / 2);
    }

    @Nonnull
    @RunsInCurrentThread
    public Point dockLocation(@Nonnull JToolBar toolBar, @Nonnull Container dock, @Nonnull String constraint) {
        this.checkValid(constraint);
        Insets insets = dock.getInsets();
        int offset = this.isHorizontal(toolBar) ? toolBar.getHeight() : toolBar.getWidth();
        Dimension dockSize = dock.getSize();
        if ("North".equals(constraint)) {
            return new Point(dockSize.width / 2, insets.top);
        }
        if ("East".equals(constraint)) {
            return new Point(dockSize.width - insets.right - 1, this.verticalDockingYCoordinate(dockSize.height, insets, offset));
        }
        if ("West".equals(constraint)) {
            return new Point(insets.left, this.verticalDockingYCoordinate(dockSize.height, insets, offset));
        }
        int x = dockSize.width / 2;
        if (x < insets.left + offset) {
            x = insets.left + offset;
        } else if (x > dockSize.width - insets.right - offset - 1) {
            x = dockSize.width - insets.right - offset - 1;
        }
        return new Point(x, dockSize.height - insets.bottom - 1);
    }

    @RunsInCurrentThread
    private boolean isHorizontal(@Nonnull JToolBar toolBar) {
        return toolBar.getOrientation() == 0;
    }

    private void checkValid(@Nonnull String constraint) {
        for (String validConstraint : VALID_CONSTRAINTS) {
            if (!validConstraint.equals(constraint)) continue;
            return;
        }
        throw this.invalidConstraint(constraint);
    }

    private IllegalArgumentException invalidConstraint(@Nonnull String constraint) {
        String format = "'%s' is not a valid constraint. Valid constraints are %s";
        String msg = String.format(format, constraint, Arrays.format(VALID_CONSTRAINTS));
        throw new IllegalArgumentException(msg);
    }

    private int verticalDockingYCoordinate(int dockHeight, @Nonnull Insets insets, int offset) {
        int y = dockHeight / 2;
        if (y < insets.top + offset) {
            y = insets.top + offset;
        }
        return y;
    }
}

