/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.opensearch.sql.calcite.CalcitePlanContext;

public class SchemaUnifier {
    public static List<RelNode> buildUnifiedSchemaWithConflictResolution(List<RelNode> nodes, CalcitePlanContext context) {
        if (nodes.isEmpty()) {
            return new ArrayList<RelNode>();
        }
        if (nodes.size() == 1) {
            return nodes;
        }
        List<SchemaField> unifiedSchema = SchemaUnifier.buildUnifiedSchema(nodes);
        ArrayList<RelNode> projectedNodes = new ArrayList<RelNode>();
        List fieldNames = unifiedSchema.stream().map(SchemaField::getName).collect(Collectors.toList());
        for (RelNode node : nodes) {
            List<RexNode> projection = SchemaUnifier.buildProjectionForNode(node, unifiedSchema, context);
            RelNode projectedNode = context.relBuilder.push(node).project(projection, fieldNames).build();
            projectedNodes.add(projectedNode);
        }
        return projectedNodes;
    }

    private static List<SchemaField> buildUnifiedSchema(List<RelNode> nodes) {
        ArrayList<SchemaField> schema = new ArrayList<SchemaField>();
        HashMap<String, RelDataType> seenFields = new HashMap<String, RelDataType>();
        for (RelNode node : nodes) {
            for (RelDataTypeField field : node.getRowType().getFieldList()) {
                String fieldName = field.getName();
                RelDataType fieldType = field.getType();
                RelDataType existingType = (RelDataType)seenFields.get(fieldName);
                if (existingType == null) {
                    schema.add(new SchemaField(fieldName, fieldType));
                    seenFields.put(fieldName, fieldType);
                    continue;
                }
                if (SchemaUnifier.areTypesCompatible(existingType, fieldType)) continue;
                throw new IllegalArgumentException(String.format("Unable to process column '%s' due to incompatible types: '%s' and '%s'", fieldName, existingType.getSqlTypeName(), fieldType.getSqlTypeName()));
            }
        }
        return schema;
    }

    private static boolean areTypesCompatible(RelDataType type1, RelDataType type2) {
        return type1.getSqlTypeName() != null && type1.getSqlTypeName().equals((Object)type2.getSqlTypeName());
    }

    private static List<RexNode> buildProjectionForNode(RelNode node, List<SchemaField> unifiedSchema, CalcitePlanContext context) {
        Map<String, RelDataTypeField> nodeFieldMap = node.getRowType().getFieldList().stream().collect(Collectors.toMap(RelDataTypeField::getName, field -> field));
        ArrayList<RexNode> projection = new ArrayList<RexNode>();
        for (SchemaField schemaField : unifiedSchema) {
            String fieldName = schemaField.getName();
            RelDataType expectedType = schemaField.getType();
            RelDataTypeField nodeField = nodeFieldMap.get(fieldName);
            if (nodeField != null && SchemaUnifier.areTypesCompatible(nodeField.getType(), expectedType)) {
                projection.add((RexNode)context.rexBuilder.makeInputRef(node, nodeField.getIndex()));
                continue;
            }
            projection.add((RexNode)context.rexBuilder.makeNullLiteral(expectedType));
        }
        return projection;
    }

    private static class SchemaField {
        private final String name;
        private final RelDataType type;

        SchemaField(String name, RelDataType type) {
            this.name = name;
            this.type = type;
        }

        String getName() {
            return this.name;
        }

        RelDataType getType() {
            return this.type;
        }
    }
}

