/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.selectivem.collections.DeduplicatingCompactSubSetBuilder;
import com.selectivem.collections.ImmutableCompactSubSet;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.UserAttributes;
import org.opensearch.security.securityconf.FlattenedActionGroups;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.securityconf.impl.v7.TenantV7;
import org.opensearch.security.support.WildcardMatcher;

public class TenantPrivileges {
    public static final TenantPrivileges EMPTY = new TenantPrivileges(SecurityDynamicConfiguration.empty(CType.ROLES), SecurityDynamicConfiguration.empty(CType.TENANTS), FlattenedActionGroups.EMPTY);
    private static final List<ActionType> READ = ImmutableList.of((Object)((Object)ActionType.READ));
    private static final List<ActionType> READ_WRITE = ImmutableList.of((Object)((Object)ActionType.READ), (Object)((Object)ActionType.WRITE));
    private static final Logger log = LogManager.getLogger(TenantPrivileges.class);
    private final ImmutableSet<String> allTenantNames;
    private final ImmutableMap<String, ImmutableMap<ActionType, ImmutableCompactSubSet<String>>> tenantToActionTypeToRoles;
    private final ImmutableMap<String, ImmutableMap<ActionType, ImmutableList<String>>> rolesToActionTypeToDynamicTenantPattern;

    public TenantPrivileges(SecurityDynamicConfiguration<RoleV7> roles, SecurityDynamicConfiguration<TenantV7> definedTenants, FlattenedActionGroups actionGroups) {
        this.allTenantNames = ImmutableSet.copyOf(definedTenants.getCEntries().keySet());
        Map<String, RoleV7> roleEntries = roles.getCEntries();
        DeduplicatingCompactSubSetBuilder roleSetBuilder = new DeduplicatingCompactSubSetBuilder(roleEntries.keySet());
        HashMap<String, Map> tenantToActionTypeToRoles = new HashMap<String, Map>();
        HashMap<String, Map> rolesToActionTypeToDynamicTenantPattern = new HashMap<String, Map>();
        for (Map.Entry<String, RoleV7> entry2 : roleEntries.entrySet()) {
            try {
                String roleName = entry2.getKey();
                RoleV7 role = entry2.getValue();
                roleSetBuilder.next((Object)roleName);
                for (RoleV7.Tenant tenantPermissions : role.getTenant_permissions()) {
                    List<ActionType> actionTypes = TenantPrivileges.resolveActionType(tenantPermissions.getAllowed_actions(), actionGroups);
                    for (String tenantPattern : tenantPermissions.getTenant_patterns()) {
                        if (UserAttributes.needsAttributeSubstitution(tenantPattern)) {
                            for (ActionType actionType : actionTypes) {
                                rolesToActionTypeToDynamicTenantPattern.computeIfAbsent(roleName, k -> new EnumMap(ActionType.class)).computeIfAbsent(actionType, k -> new HashSet()).add(tenantPattern);
                            }
                            continue;
                        }
                        for (String tenant : WildcardMatcher.from(tenantPattern).iterateMatching((Iterable<String>)this.allTenantNames)) {
                            for (ActionType actionType : actionTypes) {
                                tenantToActionTypeToRoles.computeIfAbsent(tenant, k -> new EnumMap(ActionType.class)).computeIfAbsent(actionType, k -> roleSetBuilder.createSubSetBuilder()).add((Object)roleName);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("Unexpected exception while processing role: {}\nIgnoring role.", (Object)entry2.getKey(), (Object)e);
            }
        }
        DeduplicatingCompactSubSetBuilder.Completed completedRoleSetBuilder = roleSetBuilder.build();
        this.tenantToActionTypeToRoles = (ImmutableMap)tenantToActionTypeToRoles.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> TenantPrivileges.build((Map)entry.getValue(), (DeduplicatingCompactSubSetBuilder.Completed<String>)completedRoleSetBuilder)));
        this.rolesToActionTypeToDynamicTenantPattern = (ImmutableMap)rolesToActionTypeToDynamicTenantPattern.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> TenantPrivileges.buildDynamicPatternMap((Map)entry.getValue())));
    }

    public boolean hasTenantPrivilege(PrivilegesEvaluationContext context, String tenant, ActionType actionType) {
        ImmutableCompactSubSet roles;
        Map actionTypeToRoles = (Map)this.tenantToActionTypeToRoles.get((Object)tenant);
        if (actionTypeToRoles != null && (roles = (ImmutableCompactSubSet)actionTypeToRoles.get((Object)actionType)) != null && roles.containsAny(context.getMappedRoles())) {
            return true;
        }
        if (!this.allTenantNames.contains((Object)tenant)) {
            return false;
        }
        for (String role : context.getMappedRoles()) {
            ImmutableList dynamicTenantPatterns;
            ImmutableMap actionTypeToDynamicTenantPattern = (ImmutableMap)this.rolesToActionTypeToDynamicTenantPattern.get((Object)role);
            if (actionTypeToDynamicTenantPattern == null || (dynamicTenantPatterns = (ImmutableList)actionTypeToDynamicTenantPattern.get((Object)actionType)) == null) continue;
            for (String dynamicTenantPattern : dynamicTenantPatterns) {
                try {
                    if (!context.getRenderedMatcher(dynamicTenantPattern).test(tenant)) continue;
                    return true;
                }
                catch (Exception e) {
                    log.error("Error while evaluating dynamic tenant pattern {} of role {}. Ignoring pattern.", (Object)dynamicTenantPattern, (Object)role, (Object)e);
                }
            }
        }
        if ("global_tenant".equals(tenant) && context.getMappedRoles().contains((Object)"kibana_user")) {
            if (actionTypeToRoles == null) {
                return true;
            }
            ImmutableCompactSubSet readRoles = (ImmutableCompactSubSet)actionTypeToRoles.get((Object)ActionType.READ);
            if (readRoles == null || !readRoles.containsAny(context.getMappedRoles())) {
                return true;
            }
        }
        return false;
    }

    public ImmutableSet<String> allTenantNames() {
        return this.allTenantNames;
    }

    public Map<String, Boolean> tenantMap(PrivilegesEvaluationContext context) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (String tenant : this.allTenantNames) {
            if (this.hasTenantPrivilege(context, tenant, ActionType.WRITE)) {
                result.put(tenant, true);
                continue;
            }
            if (!this.hasTenantPrivilege(context, tenant, ActionType.READ)) continue;
            result.put(tenant, false);
        }
        result.put(context.getUser().getName(), true);
        return result;
    }

    static List<ActionType> resolveActionType(Collection<String> allowedActions, FlattenedActionGroups actionGroups) {
        ImmutableSet<String> permissions = actionGroups.resolve(allowedActions);
        if (permissions.contains((Object)"kibana:saved_objects/*/write")) {
            return READ_WRITE;
        }
        return READ;
    }

    private static ImmutableMap<ActionType, ImmutableCompactSubSet<String>> build(Map<ActionType, DeduplicatingCompactSubSetBuilder.SubSetBuilder<String>> source, DeduplicatingCompactSubSetBuilder.Completed<String> completedRoleSetBuilder) {
        EnumMap<ActionType, ImmutableCompactSubSet> result = new EnumMap<ActionType, ImmutableCompactSubSet>(ActionType.class);
        for (Map.Entry<ActionType, DeduplicatingCompactSubSetBuilder.SubSetBuilder<String>> sourceEntry : source.entrySet()) {
            result.put(sourceEntry.getKey(), sourceEntry.getValue().build(completedRoleSetBuilder));
        }
        return ImmutableMap.copyOf(result);
    }

    private static ImmutableMap<ActionType, ImmutableList<String>> buildDynamicPatternMap(Map<ActionType, Set<String>> source) {
        EnumMap<ActionType, ImmutableList> result = new EnumMap<ActionType, ImmutableList>(ActionType.class);
        for (Map.Entry<ActionType, Set<String>> sourceEntry : source.entrySet()) {
            result.put(sourceEntry.getKey(), ImmutableList.copyOf((Collection)sourceEntry.getValue()));
        }
        return ImmutableMap.copyOf(result);
    }

    public static enum ActionType {
        READ,
        WRITE;

    }
}

