/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactive;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.reactive.ReactiveDataConsumer;
import org.apache.hc.core5.util.Args;
import org.reactivestreams.Publisher;

@Contract(threading=ThreadingBehavior.SAFE)
public final class ReactiveResponseConsumer
implements AsyncResponseConsumer<Void> {
    private final ReactiveDataConsumer reactiveDataConsumer = new ReactiveDataConsumer();
    private final List<Header> trailers = Collections.synchronizedList(new ArrayList());
    private final BasicFuture<Message<HttpResponse, Publisher<ByteBuffer>>> responseFuture;
    private volatile BasicFuture<Void> responseCompletion;
    private volatile HttpResponse informationResponse;
    private volatile EntityDetails entityDetails;

    public ReactiveResponseConsumer() {
        this.responseFuture = new BasicFuture(null);
    }

    public ReactiveResponseConsumer(FutureCallback<Message<HttpResponse, Publisher<ByteBuffer>>> responseCallback) {
        this.responseFuture = new BasicFuture((FutureCallback)Args.notNull(responseCallback, (String)"responseCallback"));
    }

    public Future<Message<HttpResponse, Publisher<ByteBuffer>>> getResponseFuture() {
        return this.responseFuture;
    }

    public HttpResponse getInformationResponse() {
        return this.informationResponse;
    }

    public EntityDetails getEntityDetails() {
        return this.entityDetails;
    }

    public List<Header> getTrailers() {
        return this.trailers;
    }

    public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext httpContext, FutureCallback<Void> resultCallback) {
        this.entityDetails = entityDetails;
        this.responseCompletion = new BasicFuture(resultCallback);
        this.responseFuture.completed((Object)new Message((MessageHeaders)response, (Object)this.reactiveDataConsumer));
        if (entityDetails == null) {
            this.streamEnd(null);
        }
    }

    public void informationResponse(HttpResponse response, HttpContext httpContext) {
        this.informationResponse = response;
    }

    public void failed(Exception cause) {
        this.reactiveDataConsumer.failed(cause);
        this.responseFuture.failed(cause);
        if (this.responseCompletion != null) {
            this.responseCompletion.failed(cause);
        }
    }

    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.reactiveDataConsumer.updateCapacity(capacityChannel);
    }

    public void consume(ByteBuffer src) throws IOException {
        this.reactiveDataConsumer.consume(src);
    }

    public void streamEnd(List<? extends Header> trailers) {
        if (trailers != null) {
            this.trailers.addAll(trailers);
        }
        this.reactiveDataConsumer.streamEnd(trailers);
        this.responseCompletion.completed(null);
    }

    public void releaseResources() {
        this.reactiveDataConsumer.releaseResources();
        this.responseFuture.cancel();
        if (this.responseCompletion != null) {
            this.responseCompletion.cancel();
        }
    }
}

