/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss.reconstruct;

import java.nio.ByteOrder;
import org.opensearch.knn.memoryoptsearch.faiss.reconstruct.FaissQuantizedValueReconstructor;

public class FaissFP16Reconstructor
extends FaissQuantizedValueReconstructor {
    private final boolean isLittleEndian = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;

    public FaissFP16Reconstructor(int dimension, int oneVectorElementBits) {
        super(dimension, oneVectorElementBits);
    }

    @Override
    public void reconstruct(byte[] quantizedBytes, float[] floats) {
        if (this.isLittleEndian) {
            int i = 0;
            for (int j = 0; j < this.dimension; ++j) {
                short fp16 = (short)(quantizedBytes[i] & 0xFF | (quantizedBytes[i + 1] & 0xFF) << 8);
                floats[j] = Float.float16ToFloat(fp16);
                i += 2;
            }
        } else {
            int i = 0;
            for (int j = 0; j < this.dimension; ++j) {
                short fp16 = (short)((quantizedBytes[i] & 0xFF) << 8 | quantizedBytes[i + 1] & 0xFF);
                floats[j] = Float.float16ToFloat(fp16);
                i += 2;
            }
        }
    }
}

