/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ServiceLinkVirtualInterfaceConfigurationState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceLinkVirtualInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceLinkVirtualInterface> {
    private static final SdkField<String> SERVICE_LINK_VIRTUAL_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceLinkVirtualInterfaceId").getter(ServiceLinkVirtualInterface.getter(ServiceLinkVirtualInterface::serviceLinkVirtualInterfaceId)).setter(ServiceLinkVirtualInterface.setter(Builder::serviceLinkVirtualInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkVirtualInterfaceId").unmarshallLocationName("serviceLinkVirtualInterfaceId").build()}).build();
    private static final SdkField<String> SERVICE_LINK_VIRTUAL_INTERFACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceLinkVirtualInterfaceArn").getter(ServiceLinkVirtualInterface.getter(ServiceLinkVirtualInterface::serviceLinkVirtualInterfaceArn)).setter(ServiceLinkVirtualInterface.setter(Builder::serviceLinkVirtualInterfaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkVirtualInterfaceArn").unmarshallLocationName("serviceLinkVirtualInterfaceArn").build()}).build();
    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostId").getter(ServiceLinkVirtualInterface.getter(ServiceLinkVirtualInterface::outpostId)).setter(ServiceLinkVirtualInterface.setter(Builder::outpostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").unmarshallLocationName("outpostId").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(ServiceLinkVirtualInterface.getter(ServiceLinkVirtualInterface::outpostArn)).setter(ServiceLinkVirtualInterface.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").unmarshallLocationName("outpostArn").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(ServiceLinkVirtualInterface.getter(ServiceLinkVirtualInterface::ownerId)).setter(ServiceLinkVirtualInterface.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> LOCAL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalAddress").getter(ServiceLinkVirtualInterface.getter(ServiceLinkVirtualInterface::localAddress)).setter(ServiceLinkVirtualInterface.setter(Builder::localAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalAddress").unmarshallLocationName("localAddress").build()}).build();
    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerAddress").getter(ServiceLinkVirtualInterface.getter(ServiceLinkVirtualInterface::peerAddress)).setter(ServiceLinkVirtualInterface.setter(Builder::peerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress").unmarshallLocationName("peerAddress").build()}).build();
    private static final SdkField<Long> PEER_BGP_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PeerBgpAsn").getter(ServiceLinkVirtualInterface.getter(ServiceLinkVirtualInterface::peerBgpAsn)).setter(ServiceLinkVirtualInterface.setter(Builder::peerBgpAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerBgpAsn").unmarshallLocationName("peerBgpAsn").build()}).build();
    private static final SdkField<Integer> VLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Vlan").getter(ServiceLinkVirtualInterface.getter(ServiceLinkVirtualInterface::vlan)).setter(ServiceLinkVirtualInterface.setter(Builder::vlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vlan").unmarshallLocationName("vlan").build()}).build();
    private static final SdkField<String> OUTPOST_LAG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostLagId").getter(ServiceLinkVirtualInterface.getter(ServiceLinkVirtualInterface::outpostLagId)).setter(ServiceLinkVirtualInterface.setter(Builder::outpostLagId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostLagId").unmarshallLocationName("outpostLagId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ServiceLinkVirtualInterface.getter(ServiceLinkVirtualInterface::tags)).setter(ServiceLinkVirtualInterface.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CONFIGURATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationState").getter(ServiceLinkVirtualInterface.getter(ServiceLinkVirtualInterface::configurationStateAsString)).setter(ServiceLinkVirtualInterface.setter(Builder::configurationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationState").unmarshallLocationName("configurationState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_LINK_VIRTUAL_INTERFACE_ID_FIELD, SERVICE_LINK_VIRTUAL_INTERFACE_ARN_FIELD, OUTPOST_ID_FIELD, OUTPOST_ARN_FIELD, OWNER_ID_FIELD, LOCAL_ADDRESS_FIELD, PEER_ADDRESS_FIELD, PEER_BGP_ASN_FIELD, VLAN_FIELD, OUTPOST_LAG_ID_FIELD, TAGS_FIELD, CONFIGURATION_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceLinkVirtualInterface.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceLinkVirtualInterfaceId;
    private final String serviceLinkVirtualInterfaceArn;
    private final String outpostId;
    private final String outpostArn;
    private final String ownerId;
    private final String localAddress;
    private final String peerAddress;
    private final Long peerBgpAsn;
    private final Integer vlan;
    private final String outpostLagId;
    private final List<Tag> tags;
    private final String configurationState;

    private ServiceLinkVirtualInterface(BuilderImpl builder) {
        this.serviceLinkVirtualInterfaceId = builder.serviceLinkVirtualInterfaceId;
        this.serviceLinkVirtualInterfaceArn = builder.serviceLinkVirtualInterfaceArn;
        this.outpostId = builder.outpostId;
        this.outpostArn = builder.outpostArn;
        this.ownerId = builder.ownerId;
        this.localAddress = builder.localAddress;
        this.peerAddress = builder.peerAddress;
        this.peerBgpAsn = builder.peerBgpAsn;
        this.vlan = builder.vlan;
        this.outpostLagId = builder.outpostLagId;
        this.tags = builder.tags;
        this.configurationState = builder.configurationState;
    }

    public final String serviceLinkVirtualInterfaceId() {
        return this.serviceLinkVirtualInterfaceId;
    }

    public final String serviceLinkVirtualInterfaceArn() {
        return this.serviceLinkVirtualInterfaceArn;
    }

    public final String outpostId() {
        return this.outpostId;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String localAddress() {
        return this.localAddress;
    }

    public final String peerAddress() {
        return this.peerAddress;
    }

    public final Long peerBgpAsn() {
        return this.peerBgpAsn;
    }

    public final Integer vlan() {
        return this.vlan;
    }

    public final String outpostLagId() {
        return this.outpostLagId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ServiceLinkVirtualInterfaceConfigurationState configurationState() {
        return ServiceLinkVirtualInterfaceConfigurationState.fromValue(this.configurationState);
    }

    public final String configurationStateAsString() {
        return this.configurationState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceLinkVirtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceLinkVirtualInterfaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerBgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostLagId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLinkVirtualInterface)) {
            return false;
        }
        ServiceLinkVirtualInterface other = (ServiceLinkVirtualInterface)obj;
        return Objects.equals(this.serviceLinkVirtualInterfaceId(), other.serviceLinkVirtualInterfaceId()) && Objects.equals(this.serviceLinkVirtualInterfaceArn(), other.serviceLinkVirtualInterfaceArn()) && Objects.equals(this.outpostId(), other.outpostId()) && Objects.equals(this.outpostArn(), other.outpostArn()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.localAddress(), other.localAddress()) && Objects.equals(this.peerAddress(), other.peerAddress()) && Objects.equals(this.peerBgpAsn(), other.peerBgpAsn()) && Objects.equals(this.vlan(), other.vlan()) && Objects.equals(this.outpostLagId(), other.outpostLagId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.configurationStateAsString(), other.configurationStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceLinkVirtualInterface").add("ServiceLinkVirtualInterfaceId", (Object)this.serviceLinkVirtualInterfaceId()).add("ServiceLinkVirtualInterfaceArn", (Object)this.serviceLinkVirtualInterfaceArn()).add("OutpostId", (Object)this.outpostId()).add("OutpostArn", (Object)this.outpostArn()).add("OwnerId", (Object)this.ownerId()).add("LocalAddress", (Object)this.localAddress()).add("PeerAddress", (Object)this.peerAddress()).add("PeerBgpAsn", (Object)this.peerBgpAsn()).add("Vlan", (Object)this.vlan()).add("OutpostLagId", (Object)this.outpostLagId()).add("Tags", this.hasTags() ? this.tags() : null).add("ConfigurationState", (Object)this.configurationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceLinkVirtualInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.serviceLinkVirtualInterfaceId()));
            }
            case "ServiceLinkVirtualInterfaceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceLinkVirtualInterfaceArn()));
            }
            case "OutpostId": {
                return Optional.ofNullable(clazz.cast(this.outpostId()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "LocalAddress": {
                return Optional.ofNullable(clazz.cast(this.localAddress()));
            }
            case "PeerAddress": {
                return Optional.ofNullable(clazz.cast(this.peerAddress()));
            }
            case "PeerBgpAsn": {
                return Optional.ofNullable(clazz.cast(this.peerBgpAsn()));
            }
            case "Vlan": {
                return Optional.ofNullable(clazz.cast(this.vlan()));
            }
            case "OutpostLagId": {
                return Optional.ofNullable(clazz.cast(this.outpostLagId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ConfigurationState": {
                return Optional.ofNullable(clazz.cast(this.configurationStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceLinkVirtualInterfaceId", SERVICE_LINK_VIRTUAL_INTERFACE_ID_FIELD);
        map.put("ServiceLinkVirtualInterfaceArn", SERVICE_LINK_VIRTUAL_INTERFACE_ARN_FIELD);
        map.put("OutpostId", OUTPOST_ID_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("LocalAddress", LOCAL_ADDRESS_FIELD);
        map.put("PeerAddress", PEER_ADDRESS_FIELD);
        map.put("PeerBgpAsn", PEER_BGP_ASN_FIELD);
        map.put("Vlan", VLAN_FIELD);
        map.put("OutpostLagId", OUTPOST_LAG_ID_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("ConfigurationState", CONFIGURATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceLinkVirtualInterface, T> g) {
        return obj -> g.apply((ServiceLinkVirtualInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceLinkVirtualInterfaceId;
        private String serviceLinkVirtualInterfaceArn;
        private String outpostId;
        private String outpostArn;
        private String ownerId;
        private String localAddress;
        private String peerAddress;
        private Long peerBgpAsn;
        private Integer vlan;
        private String outpostLagId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String configurationState;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLinkVirtualInterface model) {
            this.serviceLinkVirtualInterfaceId(model.serviceLinkVirtualInterfaceId);
            this.serviceLinkVirtualInterfaceArn(model.serviceLinkVirtualInterfaceArn);
            this.outpostId(model.outpostId);
            this.outpostArn(model.outpostArn);
            this.ownerId(model.ownerId);
            this.localAddress(model.localAddress);
            this.peerAddress(model.peerAddress);
            this.peerBgpAsn(model.peerBgpAsn);
            this.vlan(model.vlan);
            this.outpostLagId(model.outpostLagId);
            this.tags(model.tags);
            this.configurationState(model.configurationState);
        }

        public final String getServiceLinkVirtualInterfaceId() {
            return this.serviceLinkVirtualInterfaceId;
        }

        public final void setServiceLinkVirtualInterfaceId(String serviceLinkVirtualInterfaceId) {
            this.serviceLinkVirtualInterfaceId = serviceLinkVirtualInterfaceId;
        }

        @Override
        public final Builder serviceLinkVirtualInterfaceId(String serviceLinkVirtualInterfaceId) {
            this.serviceLinkVirtualInterfaceId = serviceLinkVirtualInterfaceId;
            return this;
        }

        public final String getServiceLinkVirtualInterfaceArn() {
            return this.serviceLinkVirtualInterfaceArn;
        }

        public final void setServiceLinkVirtualInterfaceArn(String serviceLinkVirtualInterfaceArn) {
            this.serviceLinkVirtualInterfaceArn = serviceLinkVirtualInterfaceArn;
        }

        @Override
        public final Builder serviceLinkVirtualInterfaceArn(String serviceLinkVirtualInterfaceArn) {
            this.serviceLinkVirtualInterfaceArn = serviceLinkVirtualInterfaceArn;
            return this;
        }

        public final String getOutpostId() {
            return this.outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getLocalAddress() {
            return this.localAddress;
        }

        public final void setLocalAddress(String localAddress) {
            this.localAddress = localAddress;
        }

        @Override
        public final Builder localAddress(String localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public final String getPeerAddress() {
            return this.peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final Long getPeerBgpAsn() {
            return this.peerBgpAsn;
        }

        public final void setPeerBgpAsn(Long peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
        }

        @Override
        public final Builder peerBgpAsn(Long peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
            return this;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final String getOutpostLagId() {
            return this.outpostLagId;
        }

        public final void setOutpostLagId(String outpostLagId) {
            this.outpostLagId = outpostLagId;
        }

        @Override
        public final Builder outpostLagId(String outpostLagId) {
            this.outpostLagId = outpostLagId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConfigurationState() {
            return this.configurationState;
        }

        public final void setConfigurationState(String configurationState) {
            this.configurationState = configurationState;
        }

        @Override
        public final Builder configurationState(String configurationState) {
            this.configurationState = configurationState;
            return this;
        }

        @Override
        public final Builder configurationState(ServiceLinkVirtualInterfaceConfigurationState configurationState) {
            this.configurationState(configurationState == null ? null : configurationState.toString());
            return this;
        }

        public ServiceLinkVirtualInterface build() {
            return new ServiceLinkVirtualInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceLinkVirtualInterface> {
        public Builder serviceLinkVirtualInterfaceId(String var1);

        public Builder serviceLinkVirtualInterfaceArn(String var1);

        public Builder outpostId(String var1);

        public Builder outpostArn(String var1);

        public Builder ownerId(String var1);

        public Builder localAddress(String var1);

        public Builder peerAddress(String var1);

        public Builder peerBgpAsn(Long var1);

        public Builder vlan(Integer var1);

        public Builder outpostLagId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder configurationState(String var1);

        public Builder configurationState(ServiceLinkVirtualInterfaceConfigurationState var1);
    }
}

