/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FleetStateCode {
    SUBMITTED("submitted"),
    ACTIVE("active"),
    DELETED("deleted"),
    FAILED("failed"),
    DELETED_RUNNING("deleted_running"),
    DELETED_TERMINATING("deleted_terminating"),
    MODIFYING("modifying"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FleetStateCode> VALUE_MAP;
    private final String value;

    private FleetStateCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FleetStateCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FleetStateCode> knownValues() {
        EnumSet<FleetStateCode> knownValues = EnumSet.allOf(FleetStateCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FleetStateCode.class, FleetStateCode::toString);
    }
}

