/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.RegionalSummary;
import software.amazon.awssdk.services.ec2.model.RegionalSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttributeSummary> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(AttributeSummary.getter(AttributeSummary::attributeName)).setter(AttributeSummary.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").unmarshallLocationName("attributeName").build()}).build();
    private static final SdkField<String> MOST_FREQUENT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MostFrequentValue").getter(AttributeSummary.getter(AttributeSummary::mostFrequentValue)).setter(AttributeSummary.setter(Builder::mostFrequentValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MostFrequentValue").unmarshallLocationName("mostFrequentValue").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_MATCHED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfMatchedAccounts").getter(AttributeSummary.getter(AttributeSummary::numberOfMatchedAccounts)).setter(AttributeSummary.setter(Builder::numberOfMatchedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfMatchedAccounts").unmarshallLocationName("numberOfMatchedAccounts").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_UNMATCHED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfUnmatchedAccounts").getter(AttributeSummary.getter(AttributeSummary::numberOfUnmatchedAccounts)).setter(AttributeSummary.setter(Builder::numberOfUnmatchedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfUnmatchedAccounts").unmarshallLocationName("numberOfUnmatchedAccounts").build()}).build();
    private static final SdkField<List<RegionalSummary>> REGIONAL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionalSummaries").getter(AttributeSummary.getter(AttributeSummary::regionalSummaries)).setter(AttributeSummary.setter(Builder::regionalSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionalSummarySet").unmarshallLocationName("regionalSummarySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegionalSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD, MOST_FREQUENT_VALUE_FIELD, NUMBER_OF_MATCHED_ACCOUNTS_FIELD, NUMBER_OF_UNMATCHED_ACCOUNTS_FIELD, REGIONAL_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AttributeSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attributeName;
    private final String mostFrequentValue;
    private final Integer numberOfMatchedAccounts;
    private final Integer numberOfUnmatchedAccounts;
    private final List<RegionalSummary> regionalSummaries;

    private AttributeSummary(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.mostFrequentValue = builder.mostFrequentValue;
        this.numberOfMatchedAccounts = builder.numberOfMatchedAccounts;
        this.numberOfUnmatchedAccounts = builder.numberOfUnmatchedAccounts;
        this.regionalSummaries = builder.regionalSummaries;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final String mostFrequentValue() {
        return this.mostFrequentValue;
    }

    public final Integer numberOfMatchedAccounts() {
        return this.numberOfMatchedAccounts;
    }

    public final Integer numberOfUnmatchedAccounts() {
        return this.numberOfUnmatchedAccounts;
    }

    public final boolean hasRegionalSummaries() {
        return this.regionalSummaries != null && !(this.regionalSummaries instanceof SdkAutoConstructList);
    }

    public final List<RegionalSummary> regionalSummaries() {
        return this.regionalSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mostFrequentValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfMatchedAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfUnmatchedAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionalSummaries() ? this.regionalSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeSummary)) {
            return false;
        }
        AttributeSummary other = (AttributeSummary)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.mostFrequentValue(), other.mostFrequentValue()) && Objects.equals(this.numberOfMatchedAccounts(), other.numberOfMatchedAccounts()) && Objects.equals(this.numberOfUnmatchedAccounts(), other.numberOfUnmatchedAccounts()) && this.hasRegionalSummaries() == other.hasRegionalSummaries() && Objects.equals(this.regionalSummaries(), other.regionalSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"AttributeSummary").add("AttributeName", (Object)this.attributeName()).add("MostFrequentValue", (Object)this.mostFrequentValue()).add("NumberOfMatchedAccounts", (Object)this.numberOfMatchedAccounts()).add("NumberOfUnmatchedAccounts", (Object)this.numberOfUnmatchedAccounts()).add("RegionalSummaries", this.hasRegionalSummaries() ? this.regionalSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "MostFrequentValue": {
                return Optional.ofNullable(clazz.cast(this.mostFrequentValue()));
            }
            case "NumberOfMatchedAccounts": {
                return Optional.ofNullable(clazz.cast(this.numberOfMatchedAccounts()));
            }
            case "NumberOfUnmatchedAccounts": {
                return Optional.ofNullable(clazz.cast(this.numberOfUnmatchedAccounts()));
            }
            case "RegionalSummaries": {
                return Optional.ofNullable(clazz.cast(this.regionalSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("MostFrequentValue", MOST_FREQUENT_VALUE_FIELD);
        map.put("NumberOfMatchedAccounts", NUMBER_OF_MATCHED_ACCOUNTS_FIELD);
        map.put("NumberOfUnmatchedAccounts", NUMBER_OF_UNMATCHED_ACCOUNTS_FIELD);
        map.put("RegionalSummarySet", REGIONAL_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeSummary, T> g) {
        return obj -> g.apply((AttributeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private String mostFrequentValue;
        private Integer numberOfMatchedAccounts;
        private Integer numberOfUnmatchedAccounts;
        private List<RegionalSummary> regionalSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeSummary model) {
            this.attributeName(model.attributeName);
            this.mostFrequentValue(model.mostFrequentValue);
            this.numberOfMatchedAccounts(model.numberOfMatchedAccounts);
            this.numberOfUnmatchedAccounts(model.numberOfUnmatchedAccounts);
            this.regionalSummaries(model.regionalSummaries);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getMostFrequentValue() {
            return this.mostFrequentValue;
        }

        public final void setMostFrequentValue(String mostFrequentValue) {
            this.mostFrequentValue = mostFrequentValue;
        }

        @Override
        public final Builder mostFrequentValue(String mostFrequentValue) {
            this.mostFrequentValue = mostFrequentValue;
            return this;
        }

        public final Integer getNumberOfMatchedAccounts() {
            return this.numberOfMatchedAccounts;
        }

        public final void setNumberOfMatchedAccounts(Integer numberOfMatchedAccounts) {
            this.numberOfMatchedAccounts = numberOfMatchedAccounts;
        }

        @Override
        public final Builder numberOfMatchedAccounts(Integer numberOfMatchedAccounts) {
            this.numberOfMatchedAccounts = numberOfMatchedAccounts;
            return this;
        }

        public final Integer getNumberOfUnmatchedAccounts() {
            return this.numberOfUnmatchedAccounts;
        }

        public final void setNumberOfUnmatchedAccounts(Integer numberOfUnmatchedAccounts) {
            this.numberOfUnmatchedAccounts = numberOfUnmatchedAccounts;
        }

        @Override
        public final Builder numberOfUnmatchedAccounts(Integer numberOfUnmatchedAccounts) {
            this.numberOfUnmatchedAccounts = numberOfUnmatchedAccounts;
            return this;
        }

        public final List<RegionalSummary.Builder> getRegionalSummaries() {
            List<RegionalSummary.Builder> result = RegionalSummaryListCopier.copyToBuilder(this.regionalSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegionalSummaries(Collection<RegionalSummary.BuilderImpl> regionalSummaries) {
            this.regionalSummaries = RegionalSummaryListCopier.copyFromBuilder(regionalSummaries);
        }

        @Override
        public final Builder regionalSummaries(Collection<RegionalSummary> regionalSummaries) {
            this.regionalSummaries = RegionalSummaryListCopier.copy(regionalSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionalSummaries(RegionalSummary ... regionalSummaries) {
            this.regionalSummaries(Arrays.asList(regionalSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionalSummaries(Consumer<RegionalSummary.Builder> ... regionalSummaries) {
            this.regionalSummaries(Stream.of(regionalSummaries).map(c -> (RegionalSummary)((RegionalSummary.Builder)RegionalSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AttributeSummary build() {
            return new AttributeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttributeSummary> {
        public Builder attributeName(String var1);

        public Builder mostFrequentValue(String var1);

        public Builder numberOfMatchedAccounts(Integer var1);

        public Builder numberOfUnmatchedAccounts(Integer var1);

        public Builder regionalSummaries(Collection<RegionalSummary> var1);

        public Builder regionalSummaries(RegionalSummary ... var1);

        public Builder regionalSummaries(Consumer<RegionalSummary.Builder> ... var1);
    }
}

