/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import java.io.Reader;

public class LabeledScoredTreeReaderFactory
implements TreeReaderFactory {
    private final LabelFactory lf;
    private final TreeNormalizer tm;

    public LabeledScoredTreeReaderFactory() {
        this.lf = CoreLabel.factory();
        this.tm = new BobChrisTreeNormalizer();
    }

    public LabeledScoredTreeReaderFactory(LabelFactory lf) {
        this.lf = lf;
        this.tm = new BobChrisTreeNormalizer();
    }

    public LabeledScoredTreeReaderFactory(TreeNormalizer tm) {
        this.lf = CoreLabel.factory();
        this.tm = tm;
    }

    public TreeReader newTreeReader(Reader in) {
        return new PennTreeReader(in, new LabeledScoredTreeFactory(this.lf), this.tm);
    }
}

