/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.Rule;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.Pair;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearGrammarSmoother
implements Function<Pair<UnaryGrammar, BinaryGrammar>, Pair<UnaryGrammar, BinaryGrammar>> {
    private static final boolean DEBUG = false;
    private double ALPHA = 0.01;
    private final String[] annotationIntroducingChars = new String[]{"-", "=", "|", "#", "^", "~", "_"};
    private final Set<String> annoteChars = new HashSet<String>(Arrays.asList(this.annotationIntroducingChars));
    protected transient Numberer tagNumberer;
    protected transient Numberer stateNumberer;

    @Override
    public Pair<UnaryGrammar, BinaryGrammar> apply(Pair<UnaryGrammar, BinaryGrammar> bgug) {
        this.ALPHA = Train.ruleSmoothingAlpha;
        ClassicCounter<String> symWeights = new ClassicCounter<String>();
        ClassicCounter<String> symCounts = new ClassicCounter<String>();
        for (Rule rule : bgug.first()) {
            if (this.tagNumberer().hasSeen(rule.parent)) continue;
            this.updateCounters(rule, symWeights, symCounts);
        }
        for (Rule rule : bgug.second()) {
            this.updateCounters(rule, symWeights, symCounts);
        }
        for (Rule rule : bgug.first()) {
            if (this.tagNumberer().hasSeen(rule.parent)) continue;
            rule.score = this.smoothRuleWeight(rule, symWeights, symCounts);
        }
        for (Rule rule : bgug.second()) {
            rule.score = this.smoothRuleWeight(rule, symWeights, symCounts);
        }
        return bgug;
    }

    private void updateCounters(Rule rule, Counter<String> symWeights, Counter<String> symCounts) {
        String label = (String)this.stateNumberer().object(rule.parent);
        String basicCat = this.basicCategory(label);
        symWeights.incrementCount(basicCat, Math.exp(rule.score()));
        symCounts.incrementCount(basicCat);
    }

    private float smoothRuleWeight(Rule rule, Counter<String> symWeights, Counter<String> symCounts) {
        String label = (String)this.stateNumberer().object(rule.parent);
        String basicCat = this.basicCategory(label);
        double pSum = symWeights.getCount(basicCat);
        double n = symCounts.getCount(basicCat);
        double pRule = Math.exp(rule.score());
        double pSmooth = (1.0 - this.ALPHA) * pRule;
        pSmooth += this.ALPHA * (pSum / n);
        pSmooth = Math.log(pSmooth);
        return (float)pSmooth;
    }

    private int postBasicCategoryIndex(String category) {
        int i;
        boolean sawAtZero = false;
        String seenAtZero = "\u0000";
        for (i = 0; i < category.length(); ++i) {
            String ch = category.substring(i, i + 1);
            if (!this.annoteChars.contains(ch)) continue;
            if (i == 0) {
                sawAtZero = true;
                seenAtZero = ch;
                continue;
            }
            if (!sawAtZero || ch != seenAtZero) break;
            sawAtZero = false;
        }
        return i;
    }

    public String basicCategory(String category) {
        if (category == null) {
            return null;
        }
        String basicCat = category.substring(0, this.postBasicCategoryIndex(category));
        return basicCat;
    }

    protected Numberer tagNumberer() {
        if (this.tagNumberer == null) {
            this.tagNumberer = Numberer.getGlobalNumberer("tags");
        }
        return this.tagNumberer;
    }

    protected Numberer stateNumberer() {
        if (this.stateNumberer == null) {
            this.stateNumberer = Numberer.getGlobalNumberer("states");
        }
        return this.stateNumberer;
    }
}

