/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.PermissionService;
import org.keycloak.authorization.admin.PolicyService;
import org.keycloak.authorization.admin.ResourceSetService;
import org.keycloak.authorization.admin.ScopeService;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;

@Extension(name="x-smallrye-profile-admin", value="")
public class ResourceServerService {
    private final AuthorizationProvider authorization;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;
    private final KeycloakSession session;
    private ResourceServer resourceServer;
    private final ClientModel client;

    public ResourceServerService(AuthorizationProvider authorization, ResourceServer resourceServer, ClientModel client, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.authorization = authorization;
        this.session = authorization.getKeycloakSession();
        this.client = client;
        this.resourceServer = resourceServer;
        this.auth = auth;
        this.adminEvent = adminEvent;
    }

    public ResourceServer create(boolean newClient) {
        AdminPermissionsSchema.SCHEMA.throwExceptionIfAdminPermissionClient(this.session, this.client.getId());
        this.auth.realm().requireManageAuthorization(this.resourceServer);
        UserModel serviceAccount = this.session.users().getServiceAccount(this.client);
        if (serviceAccount == null) {
            throw new RuntimeException("Client does not have a service account.");
        }
        if (this.resourceServer == null) {
            this.resourceServer = RepresentationToModel.createResourceServer((ClientModel)this.client, (KeycloakSession)this.session, (boolean)true);
            this.audit(ModelToRepresentation.toRepresentation((ResourceServer)this.resourceServer, (ClientModel)this.client), OperationType.CREATE, (UriInfo)this.session.getContext().getUri(), newClient);
        }
        return this.resourceServer;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @APIResponse(responseCode="204", description="No Content")
    public Response update(ResourceServerRepresentation server) {
        AdminPermissionsSchema.SCHEMA.throwExceptionIfAdminPermissionClient(this.session, this.client.getId());
        this.auth.realm().requireManageAuthorization(this.resourceServer);
        this.resourceServer.setAllowRemoteResourceManagement(server.isAllowRemoteResourceManagement());
        this.resourceServer.setPolicyEnforcementMode(server.getPolicyEnforcementMode());
        this.resourceServer.setDecisionStrategy(server.getDecisionStrategy());
        this.audit(ModelToRepresentation.toRepresentation((ResourceServer)this.resourceServer, (ClientModel)this.client), OperationType.UPDATE, (UriInfo)this.session.getContext().getUri(), false);
        return Response.noContent().build();
    }

    public void delete() {
        AdminPermissionsSchema.SCHEMA.throwExceptionIfAdminPermissionClient(this.session, this.client.getId());
        this.auth.realm().requireManageAuthorization(this.resourceServer);
        ResourceServerRepresentation rep = ModelToRepresentation.toRepresentation((ResourceServer)this.resourceServer, (ClientModel)this.client);
        this.authorization.getStoreFactory().getResourceServerStore().delete(this.client);
        this.audit(rep, OperationType.DELETE, (UriInfo)this.session.getContext().getUri(), false);
    }

    @GET
    @Produces(value={"application/json"})
    public ResourceServerRepresentation findById() {
        this.auth.realm().requireViewAuthorization(this.resourceServer);
        return ModelToRepresentation.toRepresentation((ResourceServer)this.resourceServer, (ClientModel)this.client);
    }

    @Path(value="/settings")
    @GET
    @Produces(value={"application/json"})
    public ResourceServerRepresentation exportSettings() {
        AdminPermissionsSchema.SCHEMA.throwExceptionIfAdminPermissionClient(this.session, this.client.getId());
        this.auth.realm().requireManageAuthorization(this.resourceServer);
        return ModelToRepresentation.toResourceServerRepresentation((KeycloakSession)this.session, (ClientModel)this.client);
    }

    @Path(value="/import")
    @POST
    @Consumes(value={"application/json"})
    @APIResponse(responseCode="204", description="No Content")
    public Response importSettings(ResourceServerRepresentation rep) {
        AdminPermissionsSchema.SCHEMA.throwExceptionIfAdminPermissionClient(this.session, this.client.getId());
        this.auth.realm().requireManageAuthorization(this.resourceServer);
        rep.setClientId(this.client.getId());
        this.resourceServer = RepresentationToModel.toModel((ResourceServerRepresentation)rep, (AuthorizationProvider)this.authorization, (ClientModel)this.client);
        this.audit(ModelToRepresentation.toRepresentation((ResourceServer)this.resourceServer, (ClientModel)this.client), OperationType.UPDATE, (UriInfo)this.session.getContext().getUri(), false);
        return Response.noContent().build();
    }

    @Path(value="/resource")
    public ResourceSetService getResourceSetResource() {
        return new ResourceSetService(this.session, this.resourceServer, this.authorization, this.auth, this.adminEvent);
    }

    @Path(value="/scope")
    public ScopeService getScopeResource() {
        return new ScopeService(this.session, this.resourceServer, this.authorization, this.auth, this.adminEvent);
    }

    @Path(value="/policy")
    public PolicyService getPolicyResource() {
        return new PolicyService(this.resourceServer, this.authorization, this.auth, this.adminEvent);
    }

    @Path(value="/permission")
    public PermissionService getPermissionTypeResource() {
        this.auth.realm().requireViewAuthorization(this.resourceServer);
        return new PermissionService(this.resourceServer, this.authorization, this.auth, this.adminEvent);
    }

    private void audit(ResourceServerRepresentation rep, OperationType operation, UriInfo uriInfo, boolean newClient) {
        if (newClient) {
            this.adminEvent.resource(ResourceType.AUTHORIZATION_RESOURCE_SERVER).operation(operation).resourcePath(uriInfo, this.client.getId()).representation(rep).success();
        } else {
            this.adminEvent.resource(ResourceType.AUTHORIZATION_RESOURCE_SERVER).operation(operation).resourcePath(uriInfo).representation(rep).success();
        }
    }
}

