/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import jakarta.persistence.AttributeConverter;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.boot.model.convert.internal.ConverterDescriptors;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.model.relational.internal.SqlStringGenerationContextImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.generator.Generator;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.GeneratorCreator;
import org.hibernate.mapping.GeneratorSettings;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappingHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.MappingContext;
import org.hibernate.type.TimeZoneStorageStrategy;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.LobTypeMappings;
import org.hibernate.type.descriptor.jdbc.NationalizedTypeMappings;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;
import org.hibernate.type.internal.ParameterizedTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.DynamicParameterizedType;

public abstract class SimpleValue
implements KeyValue {
    @Deprecated(since="7.0", forRemoval=true)
    public static final String DEFAULT_ID_GEN_STRATEGY = "assigned";
    private final MetadataBuildingContext buildingContext;
    private final MetadataImplementor metadata;
    private final List<Selectable> columns = new ArrayList<Selectable>();
    private final List<Boolean> insertability = new ArrayList<Boolean>();
    private final List<Boolean> updatability = new ArrayList<Boolean>();
    private boolean partitionKey;
    private String typeName;
    private Properties typeParameters;
    private boolean isVersion;
    private boolean isNationalized;
    private boolean isLob;
    private KeyValue.NullValueSemantic nullValueSemantic;
    private String nullValue;
    private Table table;
    private String foreignKeyName;
    private String foreignKeyDefinition;
    private String foreignKeyOptions;
    private boolean alternateUniqueKey;
    private OnDeleteAction onDeleteAction;
    private boolean foreignKeyEnabled = true;
    private ConverterDescriptor<?, ?> attributeConverterDescriptor;
    private Type type;
    private GeneratorCreator customIdGeneratorCreator = GeneratorBinder.ASSIGNED_IDENTIFIER_GENERATOR_CREATOR;
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];

    public SimpleValue(MetadataBuildingContext buildingContext) {
        this.buildingContext = buildingContext;
        this.metadata = buildingContext.getMetadataCollector();
    }

    public SimpleValue(MetadataBuildingContext buildingContext, Table table) {
        this(buildingContext);
        this.table = table;
    }

    protected SimpleValue(SimpleValue original) {
        this.buildingContext = original.buildingContext;
        this.metadata = original.metadata;
        this.columns.addAll(original.columns);
        this.insertability.addAll(original.insertability);
        this.updatability.addAll(original.updatability);
        this.partitionKey = original.partitionKey;
        this.typeName = original.typeName;
        this.typeParameters = original.typeParameters == null ? null : new Properties(original.typeParameters);
        this.isVersion = original.isVersion;
        this.isNationalized = original.isNationalized;
        this.isLob = original.isLob;
        this.nullValue = original.nullValue;
        this.table = original.table;
        this.foreignKeyName = original.foreignKeyName;
        this.foreignKeyDefinition = original.foreignKeyDefinition;
        this.foreignKeyEnabled = original.foreignKeyEnabled;
        this.alternateUniqueKey = original.alternateUniqueKey;
        this.onDeleteAction = original.onDeleteAction;
        this.attributeConverterDescriptor = original.attributeConverterDescriptor;
        this.type = original.type;
        this.customIdGeneratorCreator = original.customIdGeneratorCreator;
        this.nullValueSemantic = original.nullValueSemantic;
        this.foreignKeyOptions = original.foreignKeyOptions;
    }

    @Override
    public MetadataBuildingContext getBuildingContext() {
        return this.buildingContext;
    }

    public MetadataImplementor getMetadata() {
        return this.metadata;
    }

    InFlightMetadataCollector getMetadataCollector() {
        return this.getBuildingContext().getMetadataCollector();
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.getMetadata().getMetadataBuildingOptions().getServiceRegistry();
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.getBuildingContext().getBootstrapContext().getTypeConfiguration();
    }

    public void setOnDeleteAction(OnDeleteAction onDeleteAction) {
        this.onDeleteAction = onDeleteAction;
    }

    public OnDeleteAction getOnDeleteAction() {
        return this.onDeleteAction;
    }

    @Override
    public boolean isCascadeDeleteEnabled() {
        return this.onDeleteAction == OnDeleteAction.CASCADE;
    }

    public void addColumn(Column column) {
        this.addColumn(column, true, true);
    }

    public void addColumn(Column column, boolean isInsertable, boolean isUpdatable) {
        this.justAddColumn(column, isInsertable, isUpdatable);
        column.setValue(this);
        column.setTypeIndex(this.columns.size() - 1);
    }

    public void addFormula(Formula formula) {
        this.justAddFormula(formula);
    }

    protected void justAddColumn(Column column) {
        this.justAddColumn(column, true, true);
    }

    protected void justAddColumn(Column column, boolean insertable, boolean updatable) {
        int index = this.columns.indexOf(column);
        if (index == -1) {
            this.columns.add(column);
            this.insertability.add(insertable);
            this.updatability.add(updatable);
        } else {
            if (this.insertability.get(index) != insertable) {
                throw new IllegalStateException("Same column is added more than once with different values for isInsertable");
            }
            if (this.updatability.get(index) != updatable) {
                throw new IllegalStateException("Same column is added more than once with different values for isUpdatable");
            }
        }
    }

    protected void justAddFormula(Formula formula) {
        this.columns.add(formula);
        this.insertability.add(false);
        this.updatability.add(false);
    }

    public void sortColumns(int[] originalOrder) {
        if (this.columns.size() > 1) {
            Selectable[] originalColumns = this.columns.toArray(new Selectable[0]);
            boolean[] originalInsertability = ArrayHelper.toBooleanArray(this.insertability);
            boolean[] originalUpdatability = ArrayHelper.toBooleanArray(this.updatability);
            for (int i = 0; i < originalOrder.length; ++i) {
                int originalIndex = originalOrder[i];
                Selectable selectable = originalColumns[i];
                if (selectable instanceof Column) {
                    Column column = (Column)selectable;
                    column.setTypeIndex(originalIndex);
                }
                this.columns.set(originalIndex, selectable);
                this.insertability.set(originalIndex, originalInsertability[i]);
                this.updatability.set(originalIndex, originalUpdatability[i]);
            }
        }
    }

    @Override
    public boolean hasFormula() {
        for (Selectable selectable : this.getSelectables()) {
            if (!(selectable instanceof Formula)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getColumnSpan() {
        return this.columns.size();
    }

    protected Selectable getColumn(int position) {
        return this.columns.get(position);
    }

    @Override
    public List<Selectable> getSelectables() {
        return this.columns;
    }

    @Override
    public List<Column> getColumns() {
        if (this.hasFormula()) {
            throw new AssertionFailure("value involves formulas");
        }
        return this.columns;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        if (typeName != null && typeName.startsWith("converted::")) {
            this.setAttributeConverterDescriptor(typeName);
        } else {
            this.typeName = typeName;
        }
    }

    void setAttributeConverterDescriptor(String typeName) {
        String converterClassName = typeName.substring("converted::".length());
        MetadataBuildingContext context = this.getBuildingContext();
        Class<AttributeConverter> clazz = MappingHelper.classForName(AttributeConverter.class, converterClassName, context.getBootstrapContext());
        this.attributeConverterDescriptor = ConverterDescriptors.of(clazz, null, false, context.getBootstrapContext().getClassmateContext());
    }

    ClassLoaderService classLoaderService() {
        return this.getBuildingContext().getBootstrapContext().getClassLoaderService();
    }

    public void makeVersion() {
        this.isVersion = true;
    }

    public boolean isVersion() {
        return this.isVersion;
    }

    public void makeNationalized() {
        this.isNationalized = true;
    }

    public boolean isNationalized() {
        return this.isNationalized;
    }

    public void makeLob() {
        this.isLob = true;
    }

    public boolean isLob() {
        return this.isLob;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public void createForeignKey() throws MappingException {
    }

    public void createForeignKey(PersistentClass referencedEntity, AnnotatedJoinColumns joinColumns) throws MappingException {
    }

    @Override
    public ForeignKey createForeignKeyOfEntity(String entityName) {
        if (this.isConstrained()) {
            ForeignKey foreignKey = this.table.createForeignKey(this.getForeignKeyName(), this.getConstraintColumns(), entityName, this.getForeignKeyDefinition(), this.getForeignKeyOptions());
            foreignKey.setOnDeleteAction(this.onDeleteAction);
            return foreignKey;
        }
        return null;
    }

    @Override
    public ForeignKey createForeignKeyOfEntity(String entityName, List<Column> referencedColumns) {
        if (this.isConstrained()) {
            ForeignKey foreignKey = this.table.createForeignKey(this.getForeignKeyName(), this.getConstraintColumns(), entityName, this.getForeignKeyDefinition(), this.getForeignKeyOptions(), referencedColumns);
            foreignKey.setOnDeleteAction(this.onDeleteAction);
            return foreignKey;
        }
        return null;
    }

    @Override
    public void createUniqueKey(MetadataBuildingContext context) {
        if (this.hasFormula()) {
            throw new MappingException("Unique key constraint involves formulas");
        }
        this.getTable().createUniqueKey(this.getConstraintColumns(), context);
    }

    @Internal
    public void setCustomIdGeneratorCreator(GeneratorCreator customIdGeneratorCreator) {
        this.customIdGeneratorCreator = customIdGeneratorCreator;
    }

    @Internal
    public GeneratorCreator getCustomIdGeneratorCreator() {
        return this.customIdGeneratorCreator;
    }

    @Override
    @Deprecated(since="7.0", forRemoval=true)
    public Generator createGenerator(Dialect dialect, RootClass rootClass) {
        return this.createGenerator(dialect, rootClass, null, new GeneratorSettings(){

            @Override
            public String getDefaultCatalog() {
                return null;
            }

            @Override
            public String getDefaultSchema() {
                return null;
            }

            @Override
            public SqlStringGenerationContext getSqlStringGenerationContext() {
                Database database = SimpleValue.this.buildingContext.getMetadataCollector().getDatabase();
                return SqlStringGenerationContextImpl.fromExplicit(database.getJdbcEnvironment(), database, this.getDefaultCatalog(), this.getDefaultSchema());
            }
        });
    }

    @Override
    public Generator createGenerator(Dialect dialect, RootClass rootClass, Property property, GeneratorSettings defaults) {
        if (this.customIdGeneratorCreator != null) {
            IdGeneratorCreationContext context = new IdGeneratorCreationContext(rootClass, property, defaults);
            Generator generator = this.customIdGeneratorCreator.createGenerator(context);
            if (generator.allowAssignedIdentifiers() && this.nullValue == null) {
                this.setNullValueUndefined();
            }
            return generator;
        }
        return null;
    }

    @Internal
    public void setColumnToIdentity() {
        if (this.getColumnSpan() != 1) {
            throw new MappingException("Identity generation requires exactly one column");
        }
        Selectable selectable = this.getColumn(0);
        if (!(selectable instanceof Column)) {
            throw new MappingException("Identity generation requires a column");
        }
        Column column = (Column)selectable;
        column.setIdentity(true);
    }

    @Override
    public boolean isUpdateable() {
        return true;
    }

    @Override
    public FetchMode getFetchMode() {
        return FetchMode.SELECT;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public String getNullValue() {
        return this.nullValue;
    }

    public void setNullValue(String nullValue) {
        switch (nullValue) {
            case "null": {
                KeyValue.NullValueSemantic nullValueSemantic = KeyValue.NullValueSemantic.NULL;
                break;
            }
            case "none": {
                KeyValue.NullValueSemantic nullValueSemantic = KeyValue.NullValueSemantic.NONE;
                break;
            }
            case "any": {
                KeyValue.NullValueSemantic nullValueSemantic = KeyValue.NullValueSemantic.ANY;
                break;
            }
            case "undefined": {
                KeyValue.NullValueSemantic nullValueSemantic = KeyValue.NullValueSemantic.UNDEFINED;
                break;
            }
            default: {
                KeyValue.NullValueSemantic nullValueSemantic = this.nullValueSemantic = KeyValue.NullValueSemantic.VALUE;
            }
        }
        if (this.nullValueSemantic == KeyValue.NullValueSemantic.VALUE) {
            this.nullValue = nullValue;
        }
    }

    @Override
    public KeyValue.NullValueSemantic getNullValueSemantic() {
        return this.nullValueSemantic;
    }

    public void setNullValueSemantic(KeyValue.NullValueSemantic nullValueSemantic) {
        this.nullValueSemantic = nullValueSemantic;
    }

    public void setNullValueUndefined() {
        this.nullValueSemantic = KeyValue.NullValueSemantic.UNDEFINED;
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public void setForeignKeyName(String foreignKeyName) {
        this.foreignKeyName = foreignKeyName;
    }

    public boolean isForeignKeyEnabled() {
        return this.foreignKeyEnabled;
    }

    public void disableForeignKey() {
        this.foreignKeyEnabled = false;
    }

    public boolean isConstrained() {
        return this.isForeignKeyEnabled() && !this.hasFormula();
    }

    public String getForeignKeyOptions() {
        return this.foreignKeyOptions;
    }

    public void setForeignKeyOptions(String foreignKeyOptions) {
        this.foreignKeyOptions = foreignKeyOptions;
    }

    public String getForeignKeyDefinition() {
        return this.foreignKeyDefinition;
    }

    public void setForeignKeyDefinition(String foreignKeyDefinition) {
        this.foreignKeyDefinition = foreignKeyDefinition;
    }

    @Override
    public boolean isAlternateUniqueKey() {
        return this.alternateUniqueKey;
    }

    public void setAlternateUniqueKey(boolean unique) {
        this.alternateUniqueKey = unique;
    }

    @Override
    public boolean isNullable() {
        for (Selectable selectable : this.getSelectables()) {
            Column column;
            if (selectable instanceof Formula) {
                return true;
            }
            if (!(selectable instanceof Column) || (column = (Column)selectable).isNullable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSimpleValue() {
        return true;
    }

    @Override
    public boolean isValid(MappingContext mappingContext) throws MappingException {
        return this.getColumnSpan() == this.getType().getColumnSpan(mappingContext);
    }

    protected void setAttributeConverterDescriptor(ConverterDescriptor descriptor) {
        this.attributeConverterDescriptor = descriptor;
    }

    protected ConverterDescriptor<?, ?> getAttributeConverterDescriptor() {
        return this.attributeConverterDescriptor;
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
        if (this.typeName != null) {
            return;
        }
        if (this.type != null) {
            return;
        }
        if (this.attributeConverterDescriptor == null) {
            if (className == null) {
                throw new MappingException("Attribute types for a dynamic entity must be explicitly specified: " + propertyName);
            }
            this.typeName = this.getClass(className, propertyName).getName();
            return;
        }
        this.type = this.buildAttributeConverterTypeAdapter();
    }

    private Class<?> getClass(String className, String propertyName) {
        return ReflectHelper.reflectedPropertyClass(className, propertyName, this.classLoaderService());
    }

    private Type buildAttributeConverterTypeAdapter() {
        return this.buildAttributeConverterTypeAdapter(this.attributeConverterDescriptor.createJpaAttributeConverter(new JpaAttributeConverterCreationContext(){

            @Override
            public ManagedBeanRegistry getManagedBeanRegistry() {
                return SimpleValue.this.getBuildingContext().getBootstrapContext().getManagedBeanRegistry();
            }

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return SimpleValue.this.getMetadata().getTypeConfiguration();
            }
        }));
    }

    private <T> Type buildAttributeConverterTypeAdapter(JpaAttributeConverter<T, ?> jpaAttributeConverter) {
        JavaType domainJavaType = jpaAttributeConverter.getDomainJavaType();
        JavaType relationalJavaType = jpaAttributeConverter.getRelationalJavaType();
        JdbcType recommendedJdbcType = relationalJavaType.getRecommendedJdbcType(new JdbcTypeIndicators(){

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return SimpleValue.this.metadata.getTypeConfiguration();
            }

            @Override
            public TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
                return SimpleValue.this.buildingContext.getBuildingOptions().getDefaultTimeZoneStorage();
            }

            @Override
            public Dialect getDialect() {
                return SimpleValue.this.buildingContext.getMetadataCollector().getDatabase().getDialect();
            }
        });
        int jdbcTypeCode = recommendedJdbcType.getDdlTypeCode();
        if (this.isLob()) {
            if (LobTypeMappings.isMappedToKnownLobCode(jdbcTypeCode)) {
                jdbcTypeCode = LobTypeMappings.getLobCodeTypeMapping(jdbcTypeCode);
            } else if (Serializable.class.isAssignableFrom(domainJavaType.getJavaTypeClass())) {
                jdbcTypeCode = 2004;
            } else {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "JDBC type-code [%s (%s)] not known to have a corresponding LOB equivalent, and Java type is not Serializable (to use BLOB)", jdbcTypeCode, JdbcTypeNameMapper.getTypeName(jdbcTypeCode)));
            }
        }
        if (this.isNationalized()) {
            jdbcTypeCode = NationalizedTypeMappings.toNationalizedTypeCode(jdbcTypeCode);
        }
        return new ConvertedBasicTypeImpl<T>("converted::" + jpaAttributeConverter.getConverterJavaType().getTypeName(), String.format("BasicType adapter for AttributeConverter<%s,%s>", domainJavaType.getTypeName(), relationalJavaType.getTypeName()), this.metadata.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(jdbcTypeCode), jpaAttributeConverter);
    }

    public boolean isTypeSpecified() {
        return this.typeName != null;
    }

    public void setTypeParameters(Properties parameterMap) {
        this.typeParameters = parameterMap;
    }

    public void setTypeParameters(Map<String, ?> parameters) {
        if (parameters != null) {
            Properties properties = new Properties();
            properties.putAll(parameters);
            this.setTypeParameters(properties);
        }
    }

    public Properties getTypeParameters() {
        return this.typeParameters;
    }

    public void copyTypeFrom(SimpleValue sourceValue) {
        this.setTypeName(sourceValue.getTypeName());
        this.setTypeParameters(sourceValue.getTypeParameters());
        this.type = sourceValue.type;
        this.attributeConverterDescriptor = sourceValue.attributeConverterDescriptor;
    }

    @Override
    public boolean isSame(Value other) {
        SimpleValue simpleValue;
        return this == other || other instanceof SimpleValue && this.isSame(simpleValue = (SimpleValue)other);
    }

    protected static boolean isSame(Value v1, Value v2) {
        return v1 == v2 || v1 != null && v2 != null && v1.isSame(v2);
    }

    public boolean isSame(SimpleValue other) {
        return Objects.equals(this.columns, other.columns) && Objects.equals(this.typeName, other.typeName) && Objects.equals(this.typeParameters, other.typeParameters) && Objects.equals(this.table, other.table) && Objects.equals(this.foreignKeyName, other.foreignKeyName) && Objects.equals(this.foreignKeyDefinition, other.foreignKeyDefinition);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.columns) + ")";
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean[] getColumnInsertability() {
        return SimpleValue.extractBooleansFromList(this.insertability);
    }

    @Override
    public boolean hasAnyInsertableColumns() {
        for (int i = 0; i < this.insertability.size(); ++i) {
            if (!this.insertability.get(i).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean[] getColumnUpdateability() {
        return SimpleValue.extractBooleansFromList(this.updatability);
    }

    @Override
    public boolean hasAnyUpdatableColumns() {
        for (int i = 0; i < this.updatability.size(); ++i) {
            if (!this.updatability.get(i).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isColumnInsertable(int index) {
        if (!this.insertability.isEmpty()) {
            return this.insertability.get(index);
        }
        return false;
    }

    @Override
    public boolean isColumnUpdateable(int index) {
        if (!this.updatability.isEmpty()) {
            return this.updatability.get(index);
        }
        return false;
    }

    @Override
    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(boolean partitionColumn) {
        this.partitionKey = partitionColumn;
    }

    private static boolean[] extractBooleansFromList(List<Boolean> list) {
        boolean[] array = new boolean[list.size()];
        int i = 0;
        for (Boolean value : list) {
            array[i++] = value;
        }
        return array;
    }

    public ConverterDescriptor<?, ?> getJpaAttributeConverterDescriptor() {
        return this.attributeConverterDescriptor;
    }

    public void setJpaAttributeConverterDescriptor(ConverterDescriptor<?, ?> descriptor) {
        this.attributeConverterDescriptor = descriptor;
    }

    private static Annotation[] getAnnotations(MemberDetails memberDetails) {
        Collection directAnnotationUsages = memberDetails == null ? null : memberDetails.getDirectAnnotationUsages();
        return directAnnotationUsages == null ? NO_ANNOTATIONS : (Annotation[])directAnnotationUsages.toArray(Annotation[]::new);
    }

    protected DynamicParameterizedType.ParameterType createParameterType() {
        try {
            String[] columnNames = new String[this.columns.size()];
            Long[] columnLengths = new Long[this.columns.size()];
            for (int i = 0; i < this.columns.size(); ++i) {
                Selectable selectable = this.columns.get(i);
                if (!(selectable instanceof Column)) continue;
                Column column = (Column)selectable;
                columnNames[i] = column.getName();
                columnLengths[i] = column.getLength();
            }
            return this.createParameterType(columnNames, columnLengths);
        }
        catch (ClassLoadingException e) {
            throw new MappingException("Could not create DynamicParameterizedType for type: " + this.typeName, (Throwable)((Object)e));
        }
    }

    private DynamicParameterizedType.ParameterType createParameterType(String[] columnNames, Long[] columnLengths) {
        MemberDetails attribute = (MemberDetails)this.typeParameters.get("org.hibernate.type.ParameterType.xproperty");
        return new ParameterTypeImpl(this.classLoaderService().classForTypeName(this.typeParameters.getProperty("org.hibernate.type.ParameterType.returnedClass")), attribute != null ? attribute.getType() : null, SimpleValue.getAnnotations(attribute), this.table.getCatalog(), this.table.getSchema(), this.table.getName(), Boolean.parseBoolean(this.typeParameters.getProperty("org.hibernate.type.ParameterType.primaryKey")), columnNames, columnLengths);
    }

    private class IdGeneratorCreationContext
    implements GeneratorCreationContext {
        private final RootClass rootClass;
        private final Property property;
        private final GeneratorSettings defaults;

        public IdGeneratorCreationContext(RootClass rootClass, Property property, GeneratorSettings defaults) {
            this.rootClass = rootClass;
            this.property = property;
            this.defaults = defaults;
        }

        @Override
        public Database getDatabase() {
            return SimpleValue.this.buildingContext.getMetadataCollector().getDatabase();
        }

        @Override
        public ServiceRegistry getServiceRegistry() {
            return SimpleValue.this.buildingContext.getBootstrapContext().getServiceRegistry();
        }

        @Override
        public SqlStringGenerationContext getSqlStringGenerationContext() {
            return this.defaults.getSqlStringGenerationContext();
        }

        @Override
        public String getDefaultCatalog() {
            return this.defaults.getDefaultCatalog();
        }

        @Override
        public String getDefaultSchema() {
            return this.defaults.getDefaultSchema();
        }

        @Override
        public RootClass getRootClass() {
            return this.rootClass;
        }

        @Override
        public PersistentClass getPersistentClass() {
            return this.rootClass;
        }

        @Override
        public Property getProperty() {
            return this.property;
        }

        @Override
        public Type getType() {
            return SimpleValue.this.getType();
        }
    }

    private static final class ParameterTypeImpl
    implements DynamicParameterizedType.ParameterType {
        private final Class<?> returnedClass;
        private final java.lang.reflect.Type returnedJavaType;
        private final Annotation[] annotationsMethod;
        private final String catalog;
        private final String schema;
        private final String table;
        private final boolean primaryKey;
        private final String[] columns;
        private final Long[] columnLengths;

        private ParameterTypeImpl(Class<?> returnedClass, TypeDetails returnedTypeDetails, Annotation[] annotationsMethod, String catalog, String schema, String table, boolean primaryKey, String[] columns, Long[] columnLengths) {
            this.returnedClass = returnedClass;
            this.annotationsMethod = annotationsMethod;
            this.catalog = catalog;
            this.schema = schema;
            this.table = table;
            this.primaryKey = primaryKey;
            this.columns = columns;
            this.columnLengths = columnLengths;
            this.returnedJavaType = returnedTypeDetails != null ? (returnedTypeDetails.getTypeKind() == TypeDetails.Kind.PARAMETERIZED_TYPE ? ParameterizedTypeImpl.from(returnedTypeDetails.asParameterizedType()) : returnedTypeDetails.determineRawClass().toJavaClass()) : null;
        }

        @Override
        public Class<?> getReturnedClass() {
            return this.returnedClass;
        }

        @Override
        public java.lang.reflect.Type getReturnedJavaType() {
            return this.returnedJavaType;
        }

        @Override
        public Annotation[] getAnnotationsMethod() {
            return this.annotationsMethod;
        }

        @Override
        public String getCatalog() {
            return this.catalog;
        }

        @Override
        public String getSchema() {
            return this.schema;
        }

        @Override
        public String getTable() {
            return this.table;
        }

        @Override
        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        @Override
        public String[] getColumns() {
            return this.columns;
        }

        @Override
        public Long[] getColumnLengths() {
            return this.columnLengths;
        }
    }
}

