/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.IdentityProviderCapability;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.IdentityProviderQuery;
import org.keycloak.provider.Provider;
import org.keycloak.util.Booleans;

public interface IdentityProviderStorageProvider
extends Provider {
    public IdentityProviderModel create(IdentityProviderModel var1);

    public void update(IdentityProviderModel var1);

    public boolean remove(String var1);

    public void removeAll();

    public IdentityProviderModel getById(String var1);

    public IdentityProviderModel getByAlias(String var1);

    default public IdentityProviderModel getByIdOrAlias(String key) {
        IdentityProviderModel identityProvider = this.getById(key);
        return identityProvider != null ? identityProvider : this.getByAlias(key);
    }

    @Deprecated
    default public Stream<IdentityProviderModel> getAllStream() {
        return this.getAllStream(IdentityProviderQuery.userAuthentication(), null, null);
    }

    default public Stream<IdentityProviderModel> getAllStream(IdentityProviderQuery query) {
        return this.getAllStream(query, null, null);
    }

    @Deprecated
    default public Stream<IdentityProviderModel> getAllStream(Map<String, String> options, Integer first, Integer max) {
        return this.getAllStream(IdentityProviderQuery.userAuthentication().with(options), first, max);
    }

    public Stream<IdentityProviderModel> getAllStream(IdentityProviderQuery var1, Integer var2, Integer var3);

    default public Stream<IdentityProviderModel> getByOrganization(String orgId, Integer first, Integer max) {
        return this.getAllStream(IdentityProviderQuery.userAuthentication().with("organizationId", orgId != null ? orgId : ""), first, max);
    }

    public Stream<String> getByFlow(String var1, String var2, Integer var3, Integer var4);

    default public Stream<IdentityProviderModel> getForLogin(FetchMode mode, String organizationId) {
        Map<String, String> searchOptions;
        Stream<IdentityProviderModel> result = Stream.of(new IdentityProviderModel[0]);
        if (mode == FetchMode.REALM_ONLY || mode == FetchMode.ALL) {
            searchOptions = LoginFilter.getLoginSearchOptions();
            searchOptions.put("organizationId", null);
            result = Stream.concat(result, this.getAllStream(IdentityProviderQuery.userAuthentication().with(searchOptions), null, null));
        }
        if (mode == FetchMode.ORG_ONLY || mode == FetchMode.ALL) {
            searchOptions = LoginFilter.getLoginSearchOptions();
            if (organizationId != null) {
                searchOptions.put("organizationId", organizationId);
            } else {
                searchOptions.put("organizationIdNotNull", "");
            }
            result = Stream.concat(result, this.getAllStream(IdentityProviderQuery.userAuthentication().with(searchOptions), null, null));
        }
        return result;
    }

    public long count();

    default public boolean isIdentityFederationEnabled() {
        return this.getAllStream(IdentityProviderQuery.capability(IdentityProviderCapability.USER_LINKING), (Integer)0, (Integer)1).findFirst().isPresent();
    }

    public IdentityProviderMapperModel createMapper(IdentityProviderMapperModel var1);

    public void updateMapper(IdentityProviderMapperModel var1);

    public boolean removeMapper(IdentityProviderMapperModel var1);

    public void removeAllMappers();

    public IdentityProviderMapperModel getMapperById(String var1);

    public IdentityProviderMapperModel getMapperByName(String var1, String var2);

    default public Stream<IdentityProviderMapperModel> getMappersStream() {
        return this.getMappersStream(Map.of(), null, null);
    }

    public Stream<IdentityProviderMapperModel> getMappersStream(Map<String, String> var1, Integer var2, Integer var3);

    public Stream<IdentityProviderMapperModel> getMappersByAliasStream(String var1);

    public static enum FetchMode {
        REALM_ONLY,
        ORG_ONLY,
        ALL;

    }

    public static enum LoginFilter {
        ENABLED("enabled", Boolean.TRUE.toString(), IdentityProviderModel::isEnabled),
        LINK_ONLY("linkOnly", Boolean.FALSE.toString(), m -> Booleans.isFalse((Boolean)m.isLinkOnly())),
        HIDE_ON_LOGIN("hideOnLogin", Boolean.FALSE.toString(), m -> Booleans.isFalse((Boolean)m.isHideOnLogin()));

        private final String key;
        private final String value;
        private final Predicate<IdentityProviderModel> filter;

        private LoginFilter(String key, String value, Predicate<IdentityProviderModel> filter) {
            this.key = key;
            this.value = value;
            this.filter = filter;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public Predicate<IdentityProviderModel> getFilter() {
            return this.filter;
        }

        public static Map<String, String> getLoginSearchOptions() {
            return Stream.of(LoginFilter.values()).collect(Collectors.toMap(LoginFilter::getKey, LoginFilter::getValue, (v1, v2) -> v1, LinkedHashMap::new));
        }

        public static Predicate<IdentityProviderModel> getLoginPredicate() {
            return ((Predicate<IdentityProviderModel>)Objects::nonNull).and(Stream.of(LoginFilter.values()).map(LoginFilter::getFilter).reduce(Predicate::and).get());
        }
    }
}

