/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;

@Extension(name="x-smallrye-profile-admin", value="")
public class ScopeService {
    private final AuthorizationProvider authorization;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;
    private final KeycloakSession session;
    private final ResourceServer resourceServer;

    public ScopeService(KeycloakSession session, ResourceServer resourceServer, AuthorizationProvider authorization, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.resourceServer = resourceServer;
        this.authorization = authorization;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.AUTHORIZATION_SCOPE);
    }

    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(ScopeRepresentation scope) {
        AdminPermissionsSchema.SCHEMA.throwExceptionIfAdminPermissionClient(this.session, this.resourceServer.getId());
        this.auth.realm().requireManageAuthorization(this.resourceServer);
        Scope model = RepresentationToModel.toModel((ScopeRepresentation)scope, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization);
        scope.setId(model.getId());
        this.audit(scope, scope.getId(), OperationType.CREATE);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)scope).build();
    }

    @Path(value="{scope-id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="scope-id") String id, ScopeRepresentation scope) {
        AdminPermissionsSchema.SCHEMA.throwExceptionIfAdminPermissionClient(this.session, this.resourceServer.getId());
        this.auth.realm().requireManageAuthorization(this.resourceServer);
        scope.setId(id);
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Scope model = storeFactory.getScopeStore().findById(this.resourceServer, scope.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        RepresentationToModel.toModel((ScopeRepresentation)scope, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization);
        this.audit(scope, OperationType.UPDATE);
        return Response.noContent().build();
    }

    @Path(value="{scope-id}")
    @DELETE
    public Response delete(@PathParam(value="scope-id") String id) {
        AdminPermissionsSchema.SCHEMA.throwExceptionIfAdminPermissionClient(this.session, this.resourceServer.getId());
        this.auth.realm().requireManageAuthorization(this.resourceServer);
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Scope scope = storeFactory.getScopeStore().findById(this.resourceServer, id);
        if (scope == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List resources = storeFactory.getResourceStore().findByScopes(this.resourceServer, Collections.singleton(scope));
        if (!resources.isEmpty()) {
            throw ErrorResponse.error("Scopes can not be removed while associated with resources.", Response.Status.BAD_REQUEST);
        }
        PolicyStore policyStore = storeFactory.getPolicyStore();
        List policies = policyStore.findByScopes(this.resourceServer, Collections.singletonList(scope));
        for (Policy policyModel : policies) {
            if (policyModel.getScopes().size() == 1) {
                policyStore.delete(policyModel.getId());
                continue;
            }
            policyModel.removeScope(scope);
        }
        ScopeRepresentation scopeRep = ModelToRepresentation.toRepresentation((Scope)scope);
        storeFactory.getScopeStore().delete(id);
        this.audit(scopeRep, OperationType.DELETE);
        return Response.noContent().build();
    }

    @Path(value="{scope-id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @APIResponses(value={@APIResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ScopeRepresentation.class))}), @APIResponse(responseCode="404", description="Not found")})
    public Response findById(@PathParam(value="scope-id") String id) {
        this.auth.realm().requireViewAuthorization(this.resourceServer);
        Scope model = this.authorization.getStoreFactory().getScopeStore().findById(this.resourceServer, id);
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)ModelToRepresentation.toRepresentation((Scope)model)).build();
    }

    @Path(value="{scope-id}/resources")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @APIResponses(value={@APIResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ResourceRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="404", description="Not found")})
    public Response getResources(@PathParam(value="scope-id") String id) {
        this.auth.realm().requireViewAuthorization(this.resourceServer);
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Scope model = storeFactory.getScopeStore().findById(this.resourceServer, id);
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(storeFactory.getResourceStore().findByScopes(this.resourceServer, Collections.singleton(model)).stream().map(resource -> {
            ResourceRepresentation representation = new ResourceRepresentation();
            representation.setId(resource.getId());
            representation.setName(resource.getName());
            return representation;
        }).collect(Collectors.toList())).build();
    }

    @Path(value="{scope-id}/permissions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @APIResponses(value={@APIResponse(responseCode="200", content={@Content(schema=@Schema(implementation=PolicyRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="404", description="Not found")})
    public Response getPermissions(@PathParam(value="scope-id") String id) {
        this.auth.realm().requireViewAuthorization(this.resourceServer);
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Scope model = storeFactory.getScopeStore().findById(this.resourceServer, id);
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        PolicyStore policyStore = storeFactory.getPolicyStore();
        return Response.ok(policyStore.findByScopes(this.resourceServer, Collections.singletonList(model)).stream().map(policy -> {
            PolicyRepresentation representation = new PolicyRepresentation();
            representation.setId(policy.getId());
            representation.setName(policy.getName());
            representation.setType(policy.getType());
            return representation;
        }).collect(Collectors.toList())).build();
    }

    @Path(value="/search")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @APIResponses(value={@APIResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ScopeRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request")})
    public Response find(@QueryParam(value="name") String name) {
        this.auth.realm().requireViewAuthorization(this.resourceServer);
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        if (name == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Scope model = storeFactory.getScopeStore().findByName(this.resourceServer, name);
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        return Response.ok((Object)ModelToRepresentation.toRepresentation((Scope)model)).build();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<ScopeRepresentation> findAll(@QueryParam(value="scopeId") String id, @QueryParam(value="name") String name, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResult) {
        this.auth.realm().requireViewAuthorization(this.resourceServer);
        EnumMap<Scope.FilterOption, String[]> search = new EnumMap<Scope.FilterOption, String[]>(Scope.FilterOption.class);
        if (id != null && !"".equals(id.trim())) {
            search.put(Scope.FilterOption.ID, new String[]{id});
        }
        if (name != null && !"".equals(name.trim())) {
            search.put(Scope.FilterOption.NAME, new String[]{name});
        }
        return this.authorization.getStoreFactory().getScopeStore().findByResourceServer(this.resourceServer, search, Integer.valueOf(firstResult != null ? firstResult : -1), Integer.valueOf(maxResult != null ? maxResult : 100)).stream().map(scope -> ModelToRepresentation.toRepresentation((Scope)scope));
    }

    private void audit(ScopeRepresentation resource, OperationType operation) {
        this.audit(resource, null, operation);
    }

    private void audit(ScopeRepresentation resource, String id, OperationType operation) {
        if (id != null) {
            this.adminEvent.operation(operation).resourcePath((UriInfo)this.session.getContext().getUri(), id).representation(resource).success();
        } else {
            this.adminEvent.operation(operation).resourcePath((UriInfo)this.session.getContext().getUri()).representation(resource).success();
        }
    }
}

