/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.runtime.config;

import io.quarkus.arc.InstanceHandle;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.tls.runtime.TrustStoreProvider;
import io.quarkus.tls.runtime.config.JKSTrustStoreConfig;
import io.quarkus.tls.runtime.config.P12TrustStoreConfig;
import io.quarkus.tls.runtime.config.PemCertsConfig;
import io.quarkus.tls.runtime.config.TrustStoreCredentialProviderConfig;
import io.smallrye.config.WithDefault;
import java.util.Optional;

@ConfigGroup
public interface TrustStoreConfig {
    public Optional<PemCertsConfig> pem();

    public Optional<P12TrustStoreConfig> p12();

    public Optional<JKSTrustStoreConfig> jks();

    @WithDefault(value="WARN")
    public CertificateExpiryPolicy certificateExpirationPolicy();

    public TrustStoreCredentialProviderConfig credentialsProvider();

    default public void validate(InstanceHandle<TrustStoreProvider> provider, String name) {
        if (provider.isAvailable() && (this.pem().isPresent() || this.p12().isPresent() || this.jks().isPresent())) {
            throw new IllegalStateException("Invalid truststore '" + name + "' - The truststore cannot be configured with a provider and PEM or PKCS12 or JKS at the same time");
        }
        if (this.pem().isPresent() && (this.p12().isPresent() || this.jks().isPresent())) {
            throw new IllegalStateException("Invalid truststore '" + name + "' - The truststore cannot be configured with PEM and PKCS12 or JKS at the same time");
        }
        if (this.p12().isPresent() && this.jks().isPresent()) {
            throw new IllegalStateException("Invalid truststore '" + name + "' - The truststore cannot be configured with PKCS12 and JKS at the same time");
        }
    }

    public static enum CertificateExpiryPolicy {
        IGNORE,
        WARN,
        REJECT;

    }
}

