/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.remote.updater.helper;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class MapUpdater<K, V>
extends AbstractMap<K, V> {
    private final Map<K, V> map;
    private final List<Consumer<Map<K, V>>> changes;

    public MapUpdater(Map<K, V> map) {
        this.map = map == null ? new HashMap() : map;
        this.changes = new ArrayList<Consumer<Map<K, V>>>(4);
    }

    @Override
    public void clear() {
        this.changes.clear();
        this.addChange(Map::clear);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.addChange(kvMap -> kvMap.put(key, value));
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.addChange(kvMap -> kvMap.remove(key));
        return this.map.remove(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    private void addChange(Consumer<Map<K, V>> change) {
        this.changes.add(change);
    }

    public void applyChanges(Map<K, V> other) {
        this.changes.forEach((? super T consumer) -> consumer.accept(other));
    }

    public boolean isUnchanged() {
        return this.changes.isEmpty();
    }
}

