/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.internal.OrmAnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptor;

public class SpecializedAnnotationDescriptor<A extends Annotation, C extends A>
extends OrmAnnotationDescriptor<A, C> {
    private final Map<Class<? extends Annotation>, ? extends Annotation> usagesMap;

    public SpecializedAnnotationDescriptor(Class<A> annotationType, Class<C> concreteType) {
        super(annotationType, concreteType);
        this.usagesMap = this.extractAnnotationsMap(annotationType);
    }

    public SpecializedAnnotationDescriptor(Class<A> annotationType, Class<C> concreteType, AnnotationDescriptor<? extends Annotation> container) {
        super(annotationType, concreteType, container);
        this.usagesMap = this.extractAnnotationsMap(annotationType);
    }

    public Map<Class<? extends Annotation>, ? extends Annotation> getUsageMap() {
        return this.usagesMap;
    }

    private Map<Class<? extends Annotation>, ? extends Annotation> extractAnnotationsMap(Class<A> annotationType) {
        List<Annotation> annotationTypeAnnotations = OrmAnnotationHelper.extractAnnotationTypeAnnotations(annotationType);
        if (CollectionHelper.isEmpty(annotationTypeAnnotations)) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap();
        annotationTypeAnnotations.forEach(annotationTypeAnnotation -> result.put(annotationTypeAnnotation.annotationType(), annotationTypeAnnotation));
        return result;
    }
}

