/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import com.intellij.gradle.toolingExtension.impl.model.repositoryModel.DefaultFileRepositoryModel;
import com.intellij.gradle.toolingExtension.impl.model.repositoryModel.DefaultProjectRepositoriesModel;
import com.intellij.gradle.toolingExtension.impl.model.repositoryModel.DefaultRepositoryModel;
import com.intellij.gradle.toolingExtension.impl.model.repositoryModel.DefaultUrlRepositoryModel;
import com.intellij.gradle.toolingExtension.model.repositoryModel.ProjectRepositoriesModel;
import com.intellij.gradle.toolingExtension.model.repositoryModel.RepositoryModel;
import com.intellij.gradle.toolingExtension.model.repositoryModel.UrlRepositoryModel;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.UrlArtifactRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005\u001b\u001c\u001d\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder;", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderService;", "<init>", "()V", "canBuild", "", "modelName", "", "buildAll", "", "project", "Lorg/gradle/api/Project;", "reportErrorMessage", "", "context", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "toRepositoryModel", "Lcom/intellij/gradle/toolingExtension/model/repositoryModel/RepositoryModel;", "Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder$Repository;", "toModelRepositoryType", "Lcom/intellij/gradle/toolingExtension/model/repositoryModel/UrlRepositoryModel$Type;", "Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder$UrlRepositoryType;", "getRepositories", "", "Repository", "DeclaredRepositoryImpl", "FileRepository", "UrlRepository", "UrlRepositoryType", "intellij.gradle.toolingExtension.impl"})
@SourceDebugExtension(value={"SMAP\nProjectRepositoriesModelBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectRepositoriesModelBuilder.kt\norg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1563#2:97\n1634#2,3:98\n1563#2:101\n1634#2,2:102\n1563#2:104\n1634#2,3:105\n1636#2:108\n*S KotlinDebug\n*F\n+ 1 ProjectRepositoriesModelBuilder.kt\norg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder\n*L\n30#1:97\n30#1:98,3\n84#1:101\n84#1:102,2\n89#1:104\n89#1:105,3\n84#1:108\n*E\n"})
public final class ProjectRepositoriesModelBuilder
implements ModelBuilderService {
    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)ProjectRepositoriesModel.class.getName(), (Object)modelName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object buildAll(@NotNull String modelName, @NotNull Project project) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable iterable = this.getRepositories(project);
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Repository repository = (Repository)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toRepositoryModel((Repository)it));
        }
        List repositories = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        return new DefaultProjectRepositoriesModel(repositories);
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        context.getMessageReporter().createMessage().withGroup("gradle.mavenRepositoryModel.group").withKind(Message.Kind.WARNING).withTitle("Project repositories import failure").withText("Unable to obtain information about configured repositories in the project").withException(exception).reportMessage(project);
    }

    private final RepositoryModel toRepositoryModel(Repository $this$toRepositoryModel) {
        Repository repository = $this$toRepositoryModel;
        return repository instanceof UrlRepository ? (RepositoryModel)new DefaultUrlRepositoryModel(((UrlRepository)$this$toRepositoryModel).getName(), ((UrlRepository)$this$toRepositoryModel).getUrl(), this.toModelRepositoryType(((UrlRepository)$this$toRepositoryModel).getType())) : (repository instanceof FileRepository ? (RepositoryModel)new DefaultFileRepositoryModel(((FileRepository)$this$toRepositoryModel).getName(), ((FileRepository)$this$toRepositoryModel).getFiles()) : (RepositoryModel)new DefaultRepositoryModel($this$toRepositoryModel.getName()));
    }

    private final UrlRepositoryModel.Type toModelRepositoryType(UrlRepositoryType $this$toModelRepositoryType) {
        UrlRepositoryModel.Type type;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toModelRepositoryType.ordinal()]) {
            case 1: {
                type = UrlRepositoryModel.Type.MAVEN;
                break;
            }
            case 2: {
                type = UrlRepositoryModel.Type.IVY;
                break;
            }
            case 3: {
                type = UrlRepositoryModel.Type.OTHER;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return type;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Repository> getRepositories(Project project) {
        void $this$mapTo$iv$iv;
        boolean isUrlArtifactRepositoryClassAvailable = GradleVersionUtil.isCurrentGradleAtLeast((String)"5.7");
        RepositoryHandler repositoryHandler = project.getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)repositoryHandler, (String)"getRepositories(...)");
        Iterable $this$map$iv = (Iterable)repositoryHandler;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Repository repository;
            void it;
            ArtifactRepository artifactRepository = (ArtifactRepository)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it instanceof MavenArtifactRepository) {
                String string = ((MavenArtifactRepository)it).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                URI uRI = ((MavenArtifactRepository)it).getUrl();
                repository = new UrlRepository(string, uRI != null ? uRI.toString() : null, UrlRepositoryType.MAVEN);
            } else if (it instanceof IvyArtifactRepository) {
                String string = ((IvyArtifactRepository)it).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                URI uRI = ((IvyArtifactRepository)it).getUrl();
                repository = new UrlRepository(string, uRI != null ? uRI.toString() : null, UrlRepositoryType.IVY);
            } else if (isUrlArtifactRepositoryClassAvailable && it instanceof UrlArtifactRepository) {
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                URI uRI = ((UrlArtifactRepository)it).getUrl();
                repository = new UrlRepository(string, uRI != null ? uRI.toString() : null, UrlRepositoryType.OTHER);
            } else if (it instanceof FlatDirectoryArtifactRepository) {
                String string;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Intrinsics.checkNotNullExpressionValue((Object)((FlatDirectoryArtifactRepository)it).getName(), (String)"getName(...)");
                Set set = ((FlatDirectoryArtifactRepository)it).getDirs();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getDirs(...)");
                Iterable iterable2 = set;
                boolean $i$f$map2 = false;
                void var15_15 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void file;
                    File file2 = (File)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(file.getPath());
                }
                List list = (List)destination$iv$iv2;
                String string2 = string;
                repository = new FileRepository(string2, list);
            } else {
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                repository = new DeclaredRepositoryImpl(string);
            }
            collection.add(repository);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder$DeclaredRepositoryImpl;", "Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder$Repository;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "intellij.gradle.toolingExtension.impl"})
    private static final class DeclaredRepositoryImpl
    implements Repository {
        @NotNull
        private final String name;

        public DeclaredRepositoryImpl(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder$FileRepository;", "Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder$Repository;", "name", "", "files", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getFiles", "()Ljava/util/List;", "intellij.gradle.toolingExtension.impl"})
    private static final class FileRepository
    implements Repository {
        @NotNull
        private final String name;
        @NotNull
        private final List<String> files;

        public FileRepository(@NotNull String name, @NotNull List<String> files) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            this.name = name;
            this.files = files;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final List<String> getFiles() {
            return this.files;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0003\u0006\u0007\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder$Repository;", "", "name", "", "getName", "()Ljava/lang/String;", "Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder$DeclaredRepositoryImpl;", "Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder$FileRepository;", "Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder$UrlRepository;", "intellij.gradle.toolingExtension.impl"})
    private static interface Repository {
        @NotNull
        public String getName();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder$UrlRepository;", "Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder$Repository;", "name", "", "url", "type", "Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder$UrlRepositoryType;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder$UrlRepositoryType;)V", "getName", "()Ljava/lang/String;", "getUrl", "getType", "()Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder$UrlRepositoryType;", "intellij.gradle.toolingExtension.impl"})
    private static final class UrlRepository
    implements Repository {
        @NotNull
        private final String name;
        @Nullable
        private final String url;
        @NotNull
        private final UrlRepositoryType type;

        public UrlRepository(@NotNull String name, @Nullable String url, @NotNull UrlRepositoryType type) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.name = name;
            this.url = url;
            this.type = type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final UrlRepositoryType getType() {
            return this.type;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectRepositoriesModelBuilder$UrlRepositoryType;", "", "<init>", "(Ljava/lang/String;I)V", "MAVEN", "IVY", "OTHER", "intellij.gradle.toolingExtension.impl"})
    private static final class UrlRepositoryType
    extends Enum<UrlRepositoryType> {
        public static final /* enum */ UrlRepositoryType MAVEN = new UrlRepositoryType();
        public static final /* enum */ UrlRepositoryType IVY = new UrlRepositoryType();
        public static final /* enum */ UrlRepositoryType OTHER = new UrlRepositoryType();
        private static final /* synthetic */ UrlRepositoryType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UrlRepositoryType[] values() {
            return (UrlRepositoryType[])$VALUES.clone();
        }

        public static UrlRepositoryType valueOf(String value) {
            return Enum.valueOf(UrlRepositoryType.class, value);
        }

        @NotNull
        public static EnumEntries<UrlRepositoryType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = urlRepositoryTypeArray = new UrlRepositoryType[]{UrlRepositoryType.MAVEN, UrlRepositoryType.IVY, UrlRepositoryType.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UrlRepositoryType.values().length];
            try {
                nArray[UrlRepositoryType.MAVEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UrlRepositoryType.IVY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UrlRepositoryType.OTHER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

