/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.searching.usages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHandlerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.base.searching.usages.KotlinClassFindUsagesOptions;
import org.jetbrains.kotlin.idea.base.searching.usages.KotlinFunctionFindUsagesOptions;
import org.jetbrains.kotlin.idea.base.searching.usages.KotlinPropertyFindUsagesOptions;
import org.jetbrains.kotlin.idea.base.searching.usages.handlers.DelegatingFindMemberUsagesHandler;
import org.jetbrains.kotlin.idea.base.searching.usages.handlers.KotlinFindClassUsagesHandler;
import org.jetbrains.kotlin.idea.base.searching.usages.handlers.KotlinFindMemberUsagesHandler;
import org.jetbrains.kotlin.idea.base.searching.usages.handlers.KotlinTypeParameterFindUsagesHandler;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001bH\u0016J\u001e\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0%H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/base/searching/usages/KotlinFindUsagesHandlerFactory;", "Lcom/intellij/find/findUsages/FindUsagesHandlerFactory;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "javaHandlerFactory", "Lcom/intellij/find/findUsages/JavaFindUsagesHandlerFactory;", "getJavaHandlerFactory", "()Lcom/intellij/find/findUsages/JavaFindUsagesHandlerFactory;", "findFunctionOptions", "Lorg/jetbrains/kotlin/idea/base/searching/usages/KotlinFunctionFindUsagesOptions;", "getFindFunctionOptions", "()Lorg/jetbrains/kotlin/idea/base/searching/usages/KotlinFunctionFindUsagesOptions;", "findPropertyOptions", "Lorg/jetbrains/kotlin/idea/base/searching/usages/KotlinPropertyFindUsagesOptions;", "getFindPropertyOptions", "()Lorg/jetbrains/kotlin/idea/base/searching/usages/KotlinPropertyFindUsagesOptions;", "findClassOptions", "Lorg/jetbrains/kotlin/idea/base/searching/usages/KotlinClassFindUsagesOptions;", "getFindClassOptions", "()Lorg/jetbrains/kotlin/idea/base/searching/usages/KotlinClassFindUsagesOptions;", "defaultOptions", "Lcom/intellij/find/findUsages/FindUsagesOptions;", "getDefaultOptions", "()Lcom/intellij/find/findUsages/FindUsagesOptions;", "canFindUsages", "", "element", "Lcom/intellij/psi/PsiElement;", "createFindUsagesHandler", "Lcom/intellij/find/findUsages/FindUsagesHandler;", "forHighlightUsages", "handlerForMultiple", "originalDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "declarations", "", "intellij.kotlin.searching.base"})
public final class KotlinFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    @NotNull
    private final JavaFindUsagesHandlerFactory javaHandlerFactory;
    @NotNull
    private final KotlinFunctionFindUsagesOptions findFunctionOptions;
    @NotNull
    private final KotlinPropertyFindUsagesOptions findPropertyOptions;
    @NotNull
    private final KotlinClassFindUsagesOptions findClassOptions;
    @NotNull
    private final FindUsagesOptions defaultOptions;

    public KotlinFindUsagesHandlerFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.javaHandlerFactory = new JavaFindUsagesHandlerFactory(project);
        this.findFunctionOptions = new KotlinFunctionFindUsagesOptions(project);
        this.findPropertyOptions = new KotlinPropertyFindUsagesOptions(project);
        this.findClassOptions = new KotlinClassFindUsagesOptions(project);
        this.defaultOptions = new FindUsagesOptions(project);
    }

    @NotNull
    public final JavaFindUsagesHandlerFactory getJavaHandlerFactory() {
        return this.javaHandlerFactory;
    }

    @NotNull
    public final KotlinFunctionFindUsagesOptions getFindFunctionOptions() {
        return this.findFunctionOptions;
    }

    @NotNull
    public final KotlinPropertyFindUsagesOptions getFindPropertyOptions() {
        return this.findPropertyOptions;
    }

    @NotNull
    public final KotlinClassFindUsagesOptions getFindClassOptions() {
        return this.findClassOptions;
    }

    @NotNull
    public final FindUsagesOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public boolean canFindUsages(@NotNull PsiElement element) {
        KtImportDirective ktImportDirective;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof KtClassOrObject || element instanceof KtNamedFunction || element instanceof KtProperty || element instanceof KtParameter || element instanceof KtTypeParameter || element instanceof KtConstructor || element instanceof KtImportAlias && ((ktImportDirective = ((KtImportAlias)element).getImportDirective()) != null && (ktImportDirective = ktImportDirective.getImportedReference()) != null && (ktImportDirective = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktImportDirective))) != null && (ktImportDirective = ReferenceUtilsKt.getMainReference((KtElement)ktImportDirective)) != null ? ktImportDirective.resolve() : null) != null;
    }

    @NotNull
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (psiElement instanceof KtImportAlias) {
            FindUsagesHandler findUsagesHandler;
            PsiElement resolvedElement;
            KtImportDirective ktImportDirective = ((KtImportAlias)element).getImportDirective();
            PsiElement psiElement2 = ktImportDirective != null && (ktImportDirective = ktImportDirective.getImportedReference()) != null && (ktImportDirective = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktImportDirective))) != null && (ktImportDirective = ReferenceUtilsKt.getMainReference((KtElement)ktImportDirective)) != null ? ktImportDirective.resolve() : (resolvedElement = null);
            if (resolvedElement instanceof KtClassOrObject) {
                if (!forHighlightUsages) {
                    findUsagesHandler = this.createFindUsagesHandler(resolvedElement, false);
                } else {
                    FindUsagesHandler findUsagesHandler2 = FindUsagesHandler.NULL_HANDLER;
                    findUsagesHandler = findUsagesHandler2;
                    Intrinsics.checkNotNullExpressionValue((Object)findUsagesHandler2, (String)"NULL_HANDLER");
                }
            } else if (resolvedElement instanceof KtNamedFunction || resolvedElement instanceof KtProperty || resolvedElement instanceof KtConstructor) {
                findUsagesHandler = this.createFindUsagesHandler(resolvedElement, forHighlightUsages);
            } else {
                FindUsagesHandler findUsagesHandler3 = FindUsagesHandler.NULL_HANDLER;
                findUsagesHandler = findUsagesHandler3;
                Intrinsics.checkNotNullExpressionValue((Object)findUsagesHandler3, (String)"NULL_HANDLER");
            }
            return findUsagesHandler;
        }
        if (psiElement instanceof KtClassOrObject) {
            return new KotlinFindClassUsagesHandler((KtClassOrObject)element, this);
        }
        if (psiElement instanceof KtParameter) {
            return !forHighlightUsages ? this.handlerForMultiple((KtNamedDeclaration)element, CollectionsKt.listOf((Object)element)) : (FindUsagesHandler)KotlinFindMemberUsagesHandler.Companion.getInstance$default(KotlinFindMemberUsagesHandler.Companion, (KtNamedDeclaration)element, null, this, 2, null);
        }
        if (psiElement instanceof KtNamedFunction || psiElement instanceof KtProperty || psiElement instanceof KtConstructor) {
            KtNamedDeclaration declaration = (KtNamedDeclaration)element;
            if (forHighlightUsages) {
                return KotlinFindMemberUsagesHandler.Companion.getInstance$default(KotlinFindMemberUsagesHandler.Companion, declaration, null, this, 2, null);
            }
            return this.handlerForMultiple(declaration, CollectionsKt.listOf((Object)declaration));
        }
        if (psiElement instanceof KtTypeParameter) {
            return new KotlinTypeParameterFindUsagesHandler((KtTypeParameter)element, this);
        }
        throw new IllegalArgumentException("unexpected element type: " + element);
    }

    private final FindUsagesHandler handlerForMultiple(KtNamedDeclaration originalDeclaration, Collection<? extends PsiElement> declarations2) {
        FindUsagesHandler findUsagesHandler;
        switch (declarations2.size()) {
            case 0: {
                FindUsagesHandler findUsagesHandler2 = FindUsagesHandler.NULL_HANDLER;
                findUsagesHandler = findUsagesHandler2;
                Intrinsics.checkNotNullExpressionValue((Object)findUsagesHandler2, (String)"NULL_HANDLER");
                break;
            }
            case 1: {
                PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)CollectionsKt.single((Iterable)declarations2)));
                if (psiElement == null) {
                    FindUsagesHandler findUsagesHandler3 = FindUsagesHandler.NULL_HANDLER;
                    Intrinsics.checkNotNullExpressionValue((Object)findUsagesHandler3, (String)"NULL_HANDLER");
                    return findUsagesHandler3;
                }
                PsiElement target = psiElement;
                if (target instanceof KtNamedDeclaration) {
                    findUsagesHandler = KotlinFindMemberUsagesHandler.Companion.getInstance$default(KotlinFindMemberUsagesHandler.Companion, (KtNamedDeclaration)target, null, this, 2, null);
                    break;
                }
                FindUsagesHandler findUsagesHandler4 = this.javaHandlerFactory.createFindUsagesHandler(target, false);
                findUsagesHandler = findUsagesHandler4;
                Intrinsics.checkNotNull((Object)findUsagesHandler4);
                break;
            }
            default: {
                findUsagesHandler = new DelegatingFindMemberUsagesHandler(originalDeclaration, declarations2, this);
            }
        }
        return findUsagesHandler;
    }
}

