/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.DfaType;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.dfa.DataFlowVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Flow;
import org.jetbrains.kotlin.fir.resolve.dfa.Implication;
import org.jetbrains.kotlin.fir.resolve.dfa.LogicSystemKt;
import org.jetbrains.kotlin.fir.resolve.dfa.ModelKt;
import org.jetbrains.kotlin.fir.resolve.dfa.MutableFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.MutableTypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.Operation;
import org.jetbrains.kotlin.fir.resolve.dfa.OperationStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentTypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.RealVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Statement;
import org.jetbrains.kotlin.fir.resolve.dfa.SyntheticVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.TypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.VariableStorage;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeIntersector;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0014J*\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001a\u001a\u00020\u0012J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ\u0018\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\"J,\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0%2\u0006\u0010\u001d\u001a\u00020\u00152\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)J\u0016\u0010*\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,J\u0014\u0010-\u001a\u00020\u0012*\u00020\u00152\u0006\u0010.\u001a\u00020\"H\u0002J6\u0010/\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u00100\u001a\u00020(2\u0006\u00101\u001a\u00020(2\u0016\b\u0002\u00102\u001a\u0010\u0012\u0004\u0012\u00020,\u0012\u0006\u0012\u0004\u0018\u00010,03J&\u00104\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010#\u001a\u000205J.\u00104\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010#\u001a\u0002052\u0006\u00106\u001a\u00020\u0012J\u001e\u00107\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u00108\u001a\u00020\u001f2\u0006\u00109\u001a\u00020:J\u001e\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u001fJ\u001e\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\u00152\u0006\u00108\u001a\u00020\u001fJ\u001a\u0010>\u001a\u00020\u001c*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001a\u0010?\u001a\u00020\u001c*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\"\u0010@\u001a\u00020\u001c*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010A\u001a\u00020\u0018H\u0002J*\u0010B\u001a\u00020\u001c*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010A\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u001a\u0010C\u001a\u00020\u001c*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001e\u0010D\u001a\u00020\u001c*\u00020\u00152\u0006\u00108\u001a\u00020\u001f2\b\u0010E\u001a\u0004\u0018\u00010\u001fH\u0002JB\u00104\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)2\u0018\u0010F\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0G0'2\u0006\u0010H\u001a\u0002052\u0006\u00106\u001a\u00020\u0012H\u0002J\u0016\u0010I\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020J2\u0006\u0010#\u001a\u00020\"JF\u0010K\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)2\u0016\u0010L\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)2\u0016\u0010M\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)JF\u0010N\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)2\u0016\u0010L\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)2\u0016\u0010M\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)J\u0015\u0010O\u001a\u00020\u001c*\u00020P2\u0006\u0010Q\u001a\u00020\"H\u0082\u0002J\u0018\u0010R\u001a\u00020\"2\b\u0010<\u001a\u0004\u0018\u00010\"2\u0006\u0010=\u001a\u00020\"J\u0016\u0010R\u001a\u0004\u0018\u00010\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0\u0017J\u0016\u0010S\u001a\u0004\u0018\u00010\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0\u0017J\u0014\u0010T\u001a\u0004\u0018\u00010\u0013*\b\u0012\u0004\u0012\u00020\"0\u0017H\u0002J\u0014\u0010U\u001a\u0004\u0018\u00010\u0013*\b\u0012\u0004\u0012\u00020\"0\u0017H\u0002J\u0018\u0010V\u001a\b\u0012\u0004\u0012\u00020X0W*\b\u0012\u0004\u0012\u00020\"0\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006Y"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/LogicSystem;", "", "context", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;)V", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "nullableNothingType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "anyType", "variableStorage", "Lorg/jetbrains/kotlin/fir/resolve/dfa/VariableStorage;", "getVariableStorage", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/VariableStorage;", "isAcceptableForSmartcast", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "joinFlow", "Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;", "flows", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;", "statementFlows", "union", "addLocalVariableAlias", "", "flow", "alias", "Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;", "underlyingVariable", "addTypeStatement", "Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatement;", "statement", "addTypeStatements", "", "statements", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatements;", "addImplication", "implication", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Implication;", "containsAlready", "effect", "translateVariableFromConditionInStatements", "originalVariable", "newVariable", "transform", "Lkotlin/Function1;", "approveOperationStatement", "Lorg/jetbrains/kotlin/fir/resolve/dfa/OperationStatement;", "removeApprovedOrImpossible", "recordNewAssignment", "variable", "index", "", "isSameValueIn", "a", "b", "mergeAssignments", "copyCommonAliases", "copyNonConflictingAliases", "commonFlow", "copyStatements", "copyImplications", "replaceVariable", "replacement", "logicStatements", "Lkotlinx/collections/immutable/PersistentList;", "approvedStatement", "approveTypeStatement", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Flow;", "orForTypeStatements", "left", "right", "andForTypeStatements", "plusAssign", "Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableTypeStatement;", "other", "and", "or", "getUnifiedUpperType", "getIntersectedLowerType", "getCommonExcludedValues", "", "Lorg/jetbrains/kotlin/fir/DfaType$Symbol;", "semantics"})
@SourceDebugExtension(value={"SMAP\nLogicSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogicSystem.kt\norg/jetbrains/kotlin/fir/resolve/dfa/LogicSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n*L\n1#1,507:1\n2829#2,7:508\n1642#2,10:516\n1915#2:526\n1916#2:528\n1652#2:529\n1651#2:530\n1915#2:531\n1916#2:533\n1652#2:534\n1786#2,3:535\n1480#2,5:538\n1915#2:543\n1661#2,3:544\n1651#2:547\n1915#2:548\n1916#2:550\n1652#2:551\n1557#2,3:552\n1560#2,3:562\n1661#2,3:565\n1916#2:568\n1315#2,4:570\n1786#2,3:581\n1807#2,3:584\n1586#2:587\n1661#2,3:588\n1391#2:591\n1480#2,2:592\n1642#2,10:594\n1915#2:604\n1916#2:606\n1652#2:607\n1482#2,3:608\n1391#2:611\n1480#2,2:612\n812#2,12:614\n1482#2,3:626\n1573#2:629\n1#3:515\n1#3:527\n1#3:532\n1#3:549\n1#3:605\n383#4,7:555\n383#4,7:574\n507#4,7:630\n383#4,7:637\n231#5:569\n*S KotlinDebug\n*F\n+ 1 LogicSystem.kt\norg/jetbrains/kotlin/fir/resolve/dfa/LogicSystem\n*L\n45#1:508,7\n78#1:516,10\n78#1:526\n78#1:528\n78#1:529\n112#1:530\n112#1:531\n112#1:533\n112#1:534\n164#1:535,3\n192#1:538,5\n192#1:543\n197#1:544,3\n200#1:547\n200#1:548\n200#1:550\n200#1:551\n204#1:552,3\n204#1:562,3\n213#1:565,3\n192#1:568\n258#1:570,4\n391#1:581,3\n392#1:584,3\n410#1:587\n410#1:588,3\n417#1:591\n417#1:592,2\n428#1:594,10\n428#1:604\n428#1:606\n428#1:607\n417#1:608,3\n435#1:611\n435#1:612,2\n435#1:614,12\n435#1:626,3\n436#1:629\n78#1:527\n112#1:532\n200#1:549\n428#1:605\n204#1:555,7\n282#1:574,7\n438#1:630,7\n300#1:637,7\n256#1:569\n*E\n"})
public abstract class LogicSystem {
    @NotNull
    private final ConeInferenceContext context;
    @NotNull
    private final ConeClassLikeType nullableNothingType;
    @NotNull
    private final ConeClassLikeType anyType;

    public LogicSystem(@NotNull ConeInferenceContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.nullableNothingType = this.getSession().getBuiltinTypes().getNullableNothingType().getConeType();
        this.anyType = this.getSession().getBuiltinTypes().getAnyType().getConeType();
    }

    @NotNull
    public final FirSession getSession() {
        return this.context.getSession();
    }

    @NotNull
    public abstract VariableStorage getVariableStorage();

    protected boolean isAcceptableForSmartcast(@NotNull ConeKotlinType $this$isAcceptableForSmartcast) {
        Intrinsics.checkNotNullParameter((Object)$this$isAcceptableForSmartcast, (String)"<this>");
        return !ConeBuiltinTypeUtilsKt.isNullableNothing($this$isAcceptableForSmartcast);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MutableFlow joinFlow(@NotNull Collection<PersistentFlow> flows, @NotNull Collection<PersistentFlow> statementFlows, boolean union) {
        Intrinsics.checkNotNullParameter(flows, (String)"flows");
        Intrinsics.checkNotNullParameter(statementFlows, (String)"statementFlows");
        switch (flows.size()) {
            case 0: {
                return new MutableFlow();
            }
            case 1: {
                return ((PersistentFlow)CollectionsKt.first((Iterable)flows)).fork();
            }
        }
        Iterable $this$reduce$iv = flows;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b;
            PersistentFlow persistentFlow = (PersistentFlow)iterator$iv.next();
            PersistentFlow a = (PersistentFlow)accumulator$iv;
            boolean bl = false;
            if (a.lowestCommonAncestor((PersistentFlow)b) != null) continue;
            throw new IllegalStateException(("no common ancestor in " + a + ", " + b).toString());
        }
        PersistentFlow commonFlow = (PersistentFlow)accumulator$iv;
        MutableFlow result2 = commonFlow.fork();
        this.mergeAssignments(result2, flows);
        if (union) {
            this.copyNonConflictingAliases(result2, flows, commonFlow);
        } else {
            this.copyCommonAliases(result2, flows);
        }
        this.copyStatements(result2, statementFlows, commonFlow, union);
        this.copyImplications(result2, statementFlows);
        return result2;
    }

    public final void addLocalVariableAlias(@NotNull MutableFlow flow, @NotNull RealVariable alias, @NotNull RealVariable underlyingVariable) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)underlyingVariable, (String)"underlyingVariable");
        if (Intrinsics.areEqual((Object)underlyingVariable, (Object)alias)) {
            return;
        }
        ((Map)flow.getDirectAliasMap$semantics()).put(alias, underlyingVariable);
        Map map2 = (Map)flow.getBackwardsAliasMap$semantics();
        PersistentSet persistentSet = (PersistentSet)flow.getBackwardsAliasMap$semantics().get((Object)underlyingVariable);
        if (persistentSet == null || (persistentSet = persistentSet.add((Object)alias)) == null) {
            Object[] objectArray = new RealVariable[]{alias};
            persistentSet = ExtensionsKt.persistentSetOf((Object[])objectArray);
        }
        PersistentSet persistentSet2 = persistentSet;
        map2.put(underlyingVariable, persistentSet2);
    }

    @Nullable
    public final TypeStatement addTypeStatement(@NotNull MutableFlow flow, @NotNull TypeStatement statement) {
        PersistentTypeStatement persistentTypeStatement;
        PersistentSet newLowerTypes;
        PersistentSet persistentSet;
        PersistentSet newUpperTypes;
        PersistentTypeStatement oldStatement;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        if (statement.isEmpty()) {
            return null;
        }
        DataFlowVariable variable = statement.getVariable();
        PersistentTypeStatement persistentTypeStatement2 = oldStatement = (PersistentTypeStatement)flow.getApprovedTypeStatements$semantics().get((Object)variable);
        PersistentSet oldUpperTypes = persistentTypeStatement2 != null ? persistentTypeStatement2.getUpperTypes() : null;
        PersistentTypeStatement persistentTypeStatement3 = oldStatement;
        PersistentSet oldLowerTypes = persistentTypeStatement3 != null ? persistentTypeStatement3.getLowerTypes() : null;
        PersistentSet persistentSet2 = oldUpperTypes;
        if (persistentSet2 == null || (persistentSet2 = persistentSet2.addAll((Collection)statement.getUpperTypes())) == null) {
            persistentSet2 = newUpperTypes = ExtensionsKt.toPersistentSet((Iterable)statement.getUpperTypes());
        }
        if ((persistentSet = oldLowerTypes) == null || (persistentSet = persistentSet.addAll((Collection)statement.getLowerTypes())) == null) {
            persistentSet = newLowerTypes = ExtensionsKt.toPersistentSet((Iterable)statement.getLowerTypes());
        }
        if (newUpperTypes == oldUpperTypes && newLowerTypes == oldLowerTypes) {
            return null;
        }
        PersistentTypeStatement it = persistentTypeStatement = new PersistentTypeStatement(variable, (PersistentSet<? extends ConeKotlinType>)newUpperTypes, (PersistentSet<? extends DfaType>)newLowerTypes);
        boolean bl = false;
        ((Map)flow.getApprovedTypeStatements$semantics()).put(variable, it);
        return persistentTypeStatement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TypeStatement> addTypeStatements(@NotNull MutableFlow flow, @NotNull Map<DataFlowVariable, ? extends TypeStatement> statements2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter(statements2, (String)"statements");
        Iterable $this$mapNotNull$iv = statements2.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TypeStatement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            TypeStatement it = (TypeStatement)element$iv$iv;
            boolean bl2 = false;
            if (this.addTypeStatement(flow, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void addImplication(@NotNull MutableFlow flow, @NotNull Implication implication) {
        boolean redundant;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)implication, (String)"implication");
        Statement effect = implication.getEffect();
        if (Intrinsics.areEqual((Object)effect, (Object)implication.getCondition())) return;
        if (effect instanceof TypeStatement) {
            if (((TypeStatement)effect).isEmpty()) return;
            if (this.containsAlready(flow, (TypeStatement)effect)) {
                return;
            }
            bl = false;
        } else {
            if (effect.getVariable() instanceof SyntheticVariable && !((Map)flow.getImplications$semantics()).containsKey(effect.getVariable())) {
                return;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        boolean bl2 = redundant = false;
        if (redundant) {
            return;
        }
        DataFlowVariable variable = implication.getCondition().getVariable();
        Map map2 = (Map)flow.getImplications$semantics();
        PersistentList persistentList = (PersistentList)flow.getImplications$semantics().get((Object)variable);
        if (persistentList == null || (persistentList = persistentList.add((Object)implication)) == null) {
            Object[] objectArray = new Implication[]{implication};
            persistentList = ExtensionsKt.persistentListOf((Object[])objectArray);
        }
        PersistentList persistentList2 = persistentList;
        map2.put(variable, persistentList2);
    }

    private final boolean containsAlready(MutableFlow $this$containsAlready, TypeStatement effect) {
        PersistentTypeStatement persistentTypeStatement = (PersistentTypeStatement)$this$containsAlready.getApprovedTypeStatements$semantics().get((Object)effect.getVariable());
        if (persistentTypeStatement == null) {
            return false;
        }
        PersistentTypeStatement approved = persistentTypeStatement;
        return approved.getUpperTypes().containsAll((Collection)effect.getUpperTypes()) && approved.getLowerTypes().containsAll((Collection)effect.getLowerTypes());
    }

    /*
     * WARNING - void declaration
     */
    public final void translateVariableFromConditionInStatements(@NotNull MutableFlow flow, @NotNull DataFlowVariable originalVariable, @NotNull DataFlowVariable newVariable, @NotNull Function1<? super Implication, Implication> transform2) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)originalVariable, (String)"originalVariable");
        Intrinsics.checkNotNullParameter((Object)newVariable, (String)"newVariable");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        PersistentList statements2 = ModelKt.isSynthetic(originalVariable) ? (PersistentList)flow.getImplications$semantics().remove((Object)originalVariable) : (PersistentList)flow.getImplications$semantics().get((Object)originalVariable);
        Collection collection = (Collection)statements2;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        PersistentList persistentList = (PersistentList)flow.getImplications$semantics().get((Object)newVariable);
        if (persistentList == null) {
            persistentList = ExtensionsKt.persistentListOf();
        }
        PersistentList existing = persistentList;
        Map map2 = (Map)flow.getImplications$semantics();
        Iterable iterable = (Iterable)statements2;
        Collection destination$iv = (Collection)existing.builder();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Implication it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Implication it = (Implication)element$iv;
            boolean bl2 = false;
            if ((Implication)transform2.invoke((Object)ModelKt.implies(new OperationStatement(newVariable, it.getCondition().getOperation()), it.getEffect())) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        iterable = ((PersistentList.Builder)destination$iv).build();
        map2.put(newVariable, iterable);
    }

    public static /* synthetic */ void translateVariableFromConditionInStatements$default(LogicSystem logicSystem2, MutableFlow mutableFlow, DataFlowVariable dataFlowVariable, DataFlowVariable dataFlowVariable2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: translateVariableFromConditionInStatements");
        }
        if ((n & 8) != 0) {
            function1 = LogicSystem::translateVariableFromConditionInStatements$lambda$0;
        }
        logicSystem2.translateVariableFromConditionInStatements(mutableFlow, dataFlowVariable, dataFlowVariable2, (Function1<? super Implication, Implication>)function1);
    }

    @NotNull
    public final Map<DataFlowVariable, TypeStatement> approveOperationStatement(@NotNull PersistentFlow flow, @NotNull OperationStatement statement) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        return this.approveOperationStatement(MapsKt.toMutableMap((Map)((Map)flow.getImplications$semantics())), statement, false);
    }

    @NotNull
    public final Map<DataFlowVariable, TypeStatement> approveOperationStatement(@NotNull MutableFlow flow, @NotNull OperationStatement statement, boolean removeApprovedOrImpossible) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        return this.approveOperationStatement((Map)flow.getImplications$semantics(), statement, removeApprovedOrImpossible);
    }

    public final void recordNewAssignment(@NotNull MutableFlow flow, @NotNull RealVariable variable, int index2) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.replaceVariable(flow, variable, null);
        ((Map)flow.getAssignmentIndex$semantics()).put(variable, index2);
    }

    public final boolean isSameValueIn(@NotNull PersistentFlow a, @NotNull PersistentFlow b, @NotNull RealVariable variable) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return Intrinsics.areEqual((Object)a.getAssignmentIndex$semantics().get((Object)variable), (Object)b.getAssignmentIndex$semantics().get((Object)variable));
    }

    public final boolean isSameValueIn(@NotNull PersistentFlow a, @NotNull MutableFlow b, @NotNull RealVariable variable) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return Intrinsics.areEqual((Object)a.getAssignmentIndex$semantics().get((Object)variable), (Object)b.getAssignmentIndex$semantics().get((Object)variable));
    }

    private final void mergeAssignments(MutableFlow $this$mergeAssignments, Collection<PersistentFlow> flows) {
        Map reassignedVariables = new LinkedHashMap();
        for (PersistentFlow entry : flows) {
            for (Map.Entry entry2 : ((Map)entry.getAssignmentIndex$semantics()).entrySet()) {
                RealVariable variable = (RealVariable)entry2.getKey();
                int index2 = ((Number)entry2.getValue()).intValue();
                Integer n = (Integer)$this$mergeAssignments.getAssignmentIndex$semantics().get((Object)variable);
                int n2 = index2;
                if (n != null && n == n2) continue;
                Map map2 = reassignedVariables;
                Integer n3 = (Integer)reassignedVariables.get(variable);
                int n4 = n3 != null ? n3 : 0;
                Integer n5 = Math.max(index2, n4);
                map2.put(variable, n5);
            }
        }
        for (Map.Entry entry : reassignedVariables.entrySet()) {
            RealVariable variable = (RealVariable)entry.getKey();
            int index3 = ((Number)entry.getValue()).intValue();
            this.recordNewAssignment($this$mergeAssignments, variable, index3);
        }
    }

    private final void copyCommonAliases(MutableFlow $this$copyCommonAliases, Collection<PersistentFlow> flows) {
        for (Map.Entry entry : ((Map)((PersistentFlow)CollectionsKt.first((Iterable)flows)).getDirectAliasMap$semantics()).entrySet()) {
            boolean bl;
            RealVariable to2;
            RealVariable from;
            block4: {
                from = (RealVariable)entry.getKey();
                to2 = (RealVariable)entry.getValue();
                if (Intrinsics.areEqual((Object)$this$copyCommonAliases.getDirectAliasMap$semantics().get((Object)from), (Object)to2)) continue;
                Iterable $this$all$iv = flows;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PersistentFlow it = (PersistentFlow)element$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it.unwrapVariable(from), (Object)to2)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            this.addLocalVariableAlias($this$copyCommonAliases, from, to2);
        }
    }

    private final void copyNonConflictingAliases(MutableFlow $this$copyNonConflictingAliases, Collection<PersistentFlow> flows, PersistentFlow commonFlow) {
        Map candidates2 = new LinkedHashMap();
        for (PersistentFlow entry : flows) {
            for (Map.Entry entry2 : ((Map)entry.getDirectAliasMap$semantics()).entrySet()) {
                RealVariable from = (RealVariable)entry2.getKey();
                RealVariable to2 = (RealVariable)entry2.getValue();
                Map map2 = candidates2;
                if (Intrinsics.areEqual((Object)commonFlow.getAssignmentIndex$semantics().get((Object)from), (Object)entry.getAssignmentIndex$semantics().get((Object)from))) continue;
                RealVariable realVariable = candidates2.containsKey(from) && !Intrinsics.areEqual(candidates2.get(from), (Object)to2) ? null : to2;
                map2.put(from, realVariable);
            }
        }
        for (Map.Entry entry : candidates2.entrySet()) {
            RealVariable from = (RealVariable)entry.getKey();
            RealVariable to3 = (RealVariable)entry.getValue();
            RealVariable realVariable = to3;
            if (realVariable == null) continue;
            this.addLocalVariableAlias($this$copyNonConflictingAliases, from, realVariable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void copyStatements(MutableFlow $this$copyStatements, Collection<PersistentFlow> flows, PersistentFlow commonFlow, boolean union) {
        void $this$forEach$iv;
        void destination$iv;
        Iterable $this$flatMapTo$iv;
        Iterable iterable = flows;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            PersistentFlow it = (PersistentFlow)element$iv;
            boolean bl2 = false;
            Iterable list$iv = it.getKnownVariables();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        $this$flatMapTo$iv = (Iterable)destination$iv;
        boolean $i$f$forEach = false;
        block1: for (Object element$iv : $this$forEach$iv) {
            TypeStatement statement;
            PersistentFlow it;
            TypeStatement typeStatement;
            Iterator it2;
            Iterable iterable2;
            Iterable destination$iv2;
            Iterable $this$mapTo$iv;
            Object object;
            DataFlowVariable variable = (DataFlowVariable)element$iv;
            boolean bl = false;
            if (((Map)$this$copyStatements.getDirectAliasMap$semantics()).containsKey(variable)) continue;
            if (!union) {
                Iterable bl2 = flows;
                Collection collection2 = new LinkedHashSet();
                object = this;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    PersistentFlow persistentFlow = (PersistentFlow)item$iv;
                    iterable2 = destination$iv2;
                    boolean bl3 = false;
                    TypeStatement typeStatement2 = ((PersistentFlow)((Object)it2)).getTypeStatement(variable);
                    if (typeStatement2 == null) continue block1;
                    iterable2.add(typeStatement2);
                }
                typeStatement = ((LogicSystem)object).or((Collection<? extends TypeStatement>)destination$iv2);
            } else if (Intrinsics.areEqual(((Map)$this$copyStatements.getAssignmentIndex$semantics()).get(variable), ((Map)commonFlow.getAssignmentIndex$semantics()).get(variable))) {
                void $this$mapNotNullTo$iv;
                $this$mapTo$iv = flows;
                destination$iv2 = new LinkedHashSet();
                object = this;
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach2 = false;
                it2 = $this$forEach$iv$iv.iterator();
                while (it2.hasNext()) {
                    TypeStatement it$iv;
                    Object element$iv$iv;
                    Object element$iv2 = element$iv$iv = it2.next();
                    boolean bl4 = false;
                    it = (PersistentFlow)element$iv2;
                    boolean bl5 = false;
                    if (it.getTypeStatement(variable) == null) continue;
                    boolean bl6 = false;
                    destination$iv2.add(it$iv);
                }
                typeStatement = ((LogicSystem)object).and((Collection<? extends TypeStatement>)destination$iv2);
            } else {
                void $this$mapTo$iv2;
                Collection destination$iv3;
                Iterable $this$groupByTo$iv;
                destination$iv2 = flows;
                Map $i$f$mapNotNullTo = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv3 : $this$groupByTo$iv) {
                    Object object2;
                    void $this$getOrPut$iv$iv;
                    PersistentFlow it3 = (PersistentFlow)element$iv3;
                    boolean bl7 = false;
                    Integer n = (Integer)((Map)it3.getAssignmentIndex$semantics()).get(variable);
                    Integer key$iv = n != null ? n : -1;
                    it = destination$iv3;
                    Integer key$iv$iv = key$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                    if (value$iv$iv == null) {
                        boolean bl8 = false;
                        List answer$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                        object2 = answer$iv$iv;
                    } else {
                        object2 = value$iv$iv;
                    }
                    List list$iv = (List)object2;
                    it3 = (PersistentFlow)element$iv3;
                    object = list$iv;
                    boolean bl9 = false;
                    object.add(it3.getTypeStatement(variable));
                }
                void byAssignment = destination$iv3;
                Integer n = (Integer)((Map)commonFlow.getAssignmentIndex$semantics()).get(variable);
                byAssignment.remove(n != null ? n : -1);
                $this$groupByTo$iv = byAssignment.values();
                destination$iv3 = new LinkedHashSet();
                object = this;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv2) {
                    List it4 = (List)item$iv;
                    iterable2 = destination$iv3;
                    boolean bl10 = false;
                    TypeStatement typeStatement3 = this.and(CollectionsKt.filterNotNull((Iterable)it4));
                    if (typeStatement3 == null) continue block1;
                    iterable2.add(typeStatement3);
                }
                typeStatement = ((LogicSystem)object).or(destination$iv3);
            }
            TypeStatement typeStatement4 = statement = typeStatement;
            boolean bl11 = typeStatement4 != null ? typeStatement4.isNotEmpty() : false;
            if (!bl11) continue;
            ((Map)$this$copyStatements.getApprovedTypeStatements$semantics()).put(variable, LogicSystemKt.access$toPersistent(statement));
        }
    }

    private final void copyImplications(MutableFlow $this$copyImplications, Collection<PersistentFlow> flows) {
        switch (flows.size()) {
            case 0: {
                break;
            }
            case 1: {
                ((Map)$this$copyImplications.getImplications$semantics()).putAll((Map)((PersistentFlow)CollectionsKt.first((Iterable)flows)).getImplications$semantics());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceVariable(MutableFlow $this$replaceVariable, RealVariable variable, RealVariable replacement) {
        RealVariable original = (RealVariable)$this$replaceVariable.getDirectAliasMap$semantics().remove((Object)variable);
        if (original != null) {
            PersistentSet siblings;
            if (AbstractTypeChecker.RUN_SLOW_ASSERTIONS) {
                boolean bl;
                boolean bl2 = bl = !((Map)$this$replaceVariable.getBackwardsAliasMap$semantics()).containsKey(variable);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                boolean bl3 = bl = !((Map)$this$replaceVariable.getImplications$semantics()).containsKey(variable);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                boolean bl4 = bl = !((Map)$this$replaceVariable.getApprovedTypeStatements$semantics()).containsKey(variable);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
            if ((siblings = (PersistentSet)MapsKt.getValue((Map)((Map)$this$replaceVariable.getBackwardsAliasMap$semantics()), (Object)original)).size() > 1) {
                ((Map)$this$replaceVariable.getBackwardsAliasMap$semantics()).put(original, siblings.remove((Object)variable));
            } else {
                $this$replaceVariable.getBackwardsAliasMap$semantics().remove((Object)original);
            }
            if (replacement != null) {
                this.addLocalVariableAlias($this$replaceVariable, replacement, original);
            }
        } else {
            PersistentSet aliases = (PersistentSet)$this$replaceVariable.getBackwardsAliasMap$semantics().remove((Object)variable);
            RealVariable realVariable = replacement;
            if (realVariable == null) {
                PersistentSet persistentSet = aliases;
                realVariable = persistentSet != null ? (RealVariable)CollectionsKt.first((Iterable)((Iterable)persistentSet)) : null;
            }
            RealVariable replacementOrNext = realVariable;
            this.getVariableStorage().replaceReceiverReferencesInMembers(variable, replacementOrNext, (Function2<? super RealVariable, ? super RealVariable, Unit>)((Function2)(arg_0, arg_1) -> LogicSystem.replaceVariable$lambda$0(this, $this$replaceVariable, arg_0, arg_1)));
            LogicSystemKt.access$replaceVariableInImplications((Map)$this$replaceVariable.getImplications$semantics(), variable, replacementOrNext);
            LogicSystemKt.access$replaceVariableInStatements((Map)$this$replaceVariable.getApprovedTypeStatements$semantics(), variable, replacementOrNext);
            if (aliases != null && replacementOrNext != null) {
                Iterable $this$minus$iv;
                ((Map)$this$replaceVariable.getDirectAliasMap$semantics()).remove(replacementOrNext);
                Object object = aliases;
                RealVariable element$iv = replacementOrNext;
                boolean $i$f$minus = false;
                PersistentSet withoutSelf = $this$minus$iv.remove(element$iv);
                if (!((Collection)withoutSelf).isEmpty()) {
                    void $this$associateWithTo$iv;
                    $this$minus$iv = (Iterable)withoutSelf;
                    Map destination$iv = (Map)$this$replaceVariable.getDirectAliasMap$semantics();
                    boolean $i$f$associateWithTo = false;
                    for (Object element$iv2 : $this$associateWithTo$iv) {
                        RealVariable realVariable2 = (RealVariable)element$iv2;
                        Object t = element$iv2;
                        Map map2 = destination$iv;
                        boolean bl = false;
                        RealVariable realVariable3 = replacementOrNext;
                        map2.put(t, realVariable3);
                    }
                    object = (Map)$this$replaceVariable.getBackwardsAliasMap$semantics();
                    RealVariable realVariable4 = replacementOrNext;
                    PersistentSet persistentSet = (PersistentSet)$this$replaceVariable.getBackwardsAliasMap$semantics().get((Object)replacementOrNext);
                    if (persistentSet == null || (persistentSet = persistentSet.addAll((Collection)withoutSelf)) == null) {
                        persistentSet = withoutSelf;
                    }
                    PersistentSet persistentSet2 = persistentSet;
                    object.put(realVariable4, persistentSet2);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<DataFlowVariable, TypeStatement> approveOperationStatement(Map<DataFlowVariable, ? extends PersistentList<Implication>> logicStatements, OperationStatement approvedStatement, boolean removeApprovedOrImpossible) {
        LinkedList linkedList;
        Map result2 = new LinkedHashMap();
        LinkedList $this$approveOperationStatement_u24lambda_u240 = linkedList = new LinkedList();
        boolean bl = false;
        ((Collection)$this$approveOperationStatement_u24lambda_u240).add(approvedStatement);
        LinkedList queue = linkedList;
        Set approved = new LinkedHashSet();
        while (!((Collection)queue).isEmpty()) {
            PersistentList<Implication> statements2;
            PersistentList stillUnknown;
            Object object;
            void $this$getOrPut$iv;
            Object e = queue.removeFirst();
            Intrinsics.checkNotNullExpressionValue(e, (String)"removeFirst(...)");
            OperationStatement next2 = (OperationStatement)e;
            if (!removeApprovedOrImpossible && !approved.add(next2)) continue;
            Operation operation = next2.getOperation();
            DataFlowVariable variable = next2.getVariable();
            ConeClassLikeType impliedType = operation == Operation.EqNull ? this.nullableNothingType : this.anyType;
            Map map2 = result2;
            DataFlowVariable key$iv = variable;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                MutableTypeStatement answer$iv = new MutableTypeStatement(variable, null, null, 6, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            MutableTypeStatement resultStatement = (MutableTypeStatement)object;
            resultStatement.getUpperTypes().add(impliedType);
            switch (WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
                case 1: {
                    resultStatement.getLowerTypes().add(new DfaType.BooleanLiteral(false));
                    break;
                }
                case 2: {
                    resultStatement.getLowerTypes().add(new DfaType.BooleanLiteral(true));
                }
            }
            if (logicStatements.get(variable) == null || Intrinsics.areEqual((Object)(stillUnknown = statements2.removeAll(arg_0 -> LogicSystem.approveOperationStatement$lambda$2(operation, queue, this, result2, removeApprovedOrImpossible, arg_0))), statements2) || !TypeIntrinsics.isMutableMap(logicStatements)) continue;
            if (stillUnknown.isEmpty()) {
                logicStatements.remove(variable);
                continue;
            }
            logicStatements.put(variable, (PersistentList<Implication>)stillUnknown);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean approveTypeStatement(@NotNull Flow flow, @NotNull TypeStatement statement) {
        Map map2;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        DataFlowVariable variable = statement.getVariable();
        ConeKotlinType typeFromVar = variable instanceof SyntheticVariable ? ((SyntheticVariable)variable).getFir().getConeTypeOrNull() : variable.getOriginalType();
        TypeStatement known = flow.getTypeStatement(variable);
        if (known != null && typeFromVar != null) {
            void it;
            Object[] objectArray2 = objectArray = LogicSystemKt.access$toMutable(known);
            DataFlowVariable dataFlowVariable = variable;
            boolean bl = false;
            ((Collection)it.getUpperTypes()).add(typeFromVar);
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)dataFlowVariable, (Object)objectArray));
        } else if (known != null && typeFromVar == null) {
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)variable, (Object)known));
        } else if (known == null && typeFromVar != null) {
            objectArray = new ConeKotlinType[]{typeFromVar};
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)variable, (Object)new MutableTypeStatement(variable, SetsKt.mutableSetOf((Object[])objectArray), null, 4, null)));
        } else {
            return false;
        }
        Map approvedStatements = map2;
        ConeKotlinType approvedUpper = this.getUnifiedUpperType(approvedStatements.values());
        ConeKotlinType approvedLower = this.getIntersectedLowerType(approvedStatements.values());
        ConeKotlinType statementUpper = this.getUnifiedUpperType(CollectionsKt.listOf((Object)statement));
        ConeKotlinType statementLower = this.getIntersectedLowerType(CollectionsKt.listOf((Object)statement));
        return !(approvedUpper != null && statementUpper != null && !AbstractTypeChecker.isSubtypeOf$default((AbstractTypeChecker)AbstractTypeChecker.INSTANCE, (TypeCheckerProviderContext)this.context, (KotlinTypeMarker)approvedUpper, (KotlinTypeMarker)statementUpper, (boolean)false, (int)8, null) || approvedLower != null && statementUpper != null && AbstractTypeChecker.isSubtypeOf$default((AbstractTypeChecker)AbstractTypeChecker.INSTANCE, (TypeCheckerProviderContext)this.context, (KotlinTypeMarker)statementUpper, (KotlinTypeMarker)approvedLower, (boolean)false, (int)8, null) || statementLower != null && approvedUpper != null && AbstractTypeChecker.isSubtypeOf$default((AbstractTypeChecker)AbstractTypeChecker.INSTANCE, (TypeCheckerProviderContext)this.context, (KotlinTypeMarker)approvedUpper, (KotlinTypeMarker)statementLower, (boolean)false, (int)8, null));
    }

    @NotNull
    public final Map<DataFlowVariable, TypeStatement> orForTypeStatements(@NotNull Map<DataFlowVariable, ? extends TypeStatement> left, @NotNull Map<DataFlowVariable, ? extends TypeStatement> right) {
        Map map2;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (left.isEmpty()) {
            map2 = left;
        } else if (right.isEmpty()) {
            map2 = right;
        } else {
            Map map3;
            Map $this$orForTypeStatements_u24lambda_u240 = map3 = MapsKt.createMapBuilder();
            boolean bl = false;
            for (Map.Entry<DataFlowVariable, TypeStatement> entry : left.entrySet()) {
                DataFlowVariable variable = entry.getKey();
                TypeStatement leftStatement = entry.getValue();
                Object[] objectArray = new TypeStatement[2];
                objectArray[0] = leftStatement;
                if (right.get(variable) == null) continue;
                objectArray[1] = objectArray[1];
                TypeStatement typeStatement = this.or(CollectionsKt.listOf((Object[])objectArray));
                if (typeStatement == null) continue;
                $this$orForTypeStatements_u24lambda_u240.put(variable, typeStatement);
            }
            map2 = MapsKt.build((Map)map3);
        }
        return map2;
    }

    @NotNull
    public final Map<DataFlowVariable, TypeStatement> andForTypeStatements(@NotNull Map<DataFlowVariable, ? extends TypeStatement> left, @NotNull Map<DataFlowVariable, ? extends TypeStatement> right) {
        Map map2;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (left.isEmpty()) {
            map2 = right;
        } else if (right.isEmpty()) {
            map2 = left;
        } else {
            Map map3;
            Map $this$andForTypeStatements_u24lambda_u240 = map3 = MapsKt.toMutableMap(left);
            boolean bl = false;
            for (Map.Entry<DataFlowVariable, TypeStatement> entry : right.entrySet()) {
                DataFlowVariable variable = entry.getKey();
                TypeStatement rightStatement = entry.getValue();
                $this$andForTypeStatements_u24lambda_u240.put(variable, this.and((TypeStatement)$this$andForTypeStatements_u24lambda_u240.get(variable), rightStatement));
            }
            map2 = map3;
        }
        return map2;
    }

    private final void plusAssign(MutableTypeStatement $this$plusAssign, TypeStatement other) {
        Intrinsics.checkNotNullParameter((Object)$this$plusAssign, (String)"<this>");
        CollectionsKt.addAll((Collection)$this$plusAssign.getUpperTypes(), (Iterable)other.getUpperTypes());
        CollectionsKt.addAll((Collection)$this$plusAssign.getLowerTypes(), (Iterable)other.getLowerTypes());
    }

    @NotNull
    public final TypeStatement and(@Nullable TypeStatement a, @NotNull TypeStatement b) {
        TypeStatement typeStatement;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        TypeStatement typeStatement2 = a;
        if (typeStatement2 != null && (typeStatement2 = LogicSystemKt.access$toMutable(typeStatement2)) != null) {
            TypeStatement typeStatement3;
            TypeStatement $this$and_u24lambda_u240 = typeStatement3 = typeStatement2;
            boolean bl = false;
            this.plusAssign((MutableTypeStatement)$this$and_u24lambda_u240, b);
            typeStatement = typeStatement3;
        } else {
            typeStatement = b;
        }
        return typeStatement;
    }

    @Nullable
    public final TypeStatement and(@NotNull Collection<? extends TypeStatement> statements2) {
        Intrinsics.checkNotNullParameter(statements2, (String)"statements");
        switch (statements2.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (TypeStatement)CollectionsKt.first((Iterable)statements2);
            }
        }
        Iterator<? extends TypeStatement> iterator2 = statements2.iterator();
        MutableTypeStatement result2 = LogicSystemKt.access$toMutable(iterator2.next());
        while (iterator2.hasNext()) {
            this.plusAssign(result2, iterator2.next());
        }
        return result2;
    }

    @Nullable
    public final TypeStatement or(@NotNull Collection<? extends TypeStatement> statements2) {
        DfaType.Cone cone;
        Object[] objectArray;
        PersistentSet persistentSet;
        boolean bl;
        DataFlowVariable variable;
        block23: {
            boolean $this$all$iv2;
            TypeStatement it;
            block22: {
                boolean bl2;
                Intrinsics.checkNotNullParameter(statements2, (String)"statements");
                switch (statements2.size()) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return (TypeStatement)CollectionsKt.first((Iterable)statements2);
                    }
                }
                variable = ((TypeStatement)CollectionsKt.first((Iterable)statements2)).getVariable();
                Iterable $this$all$iv2 = statements2;
                boolean $i$f$all = false;
                if (((Collection)$this$all$iv2).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        it = (TypeStatement)element$iv;
                        boolean bl3 = false;
                        if (Intrinsics.areEqual((Object)it.getVariable(), (Object)variable)) continue;
                        bl2 = false;
                        break block22;
                    }
                    bl2 = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                boolean $i$a$-assert-LogicSystem$or$32 = false;
                String $i$a$-assert-LogicSystem$or$32 = "folding statements for different variables";
                throw new AssertionError((Object)$i$a$-assert-LogicSystem$or$32);
            }
            Iterable $this$any$iv = statements2;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (TypeStatement)element$iv;
                    boolean bl4 = false;
                    if (!it.isEmpty()) continue;
                    bl = true;
                    break block23;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        ConeKotlinType unifiedUpperType = this.getUnifiedUpperType(statements2);
        if (unifiedUpperType == null) {
            persistentSet = ExtensionsKt.persistentSetOf();
        } else if (ConeBuiltinTypeUtilsKt.isNullableAny(unifiedUpperType)) {
            persistentSet = ExtensionsKt.persistentSetOf();
        } else if (this.isAcceptableForSmartcast(unifiedUpperType)) {
            objectArray = new ConeKotlinType[]{unifiedUpperType};
            persistentSet = ExtensionsKt.persistentSetOf((Object[])objectArray);
        } else if (TypeUtilsKt.canBeNull$default(unifiedUpperType, this.context.getSession(), false, null, 6, null)) {
            persistentSet = ExtensionsKt.persistentSetOf();
        } else {
            objectArray = new ConeClassLikeType[]{this.context.anyType()};
            persistentSet = ExtensionsKt.persistentSetOf((Object[])objectArray);
        }
        PersistentSet newUpperTypes = persistentSet;
        ConeKotlinType coneKotlinType = this.getIntersectedLowerType(statements2);
        if (coneKotlinType != null) {
            ConeKotlinType p0 = coneKotlinType;
            boolean bl5 = false;
            cone = new DfaType.Cone(p0);
        } else {
            cone = null;
        }
        Set newLowerTypes = SetsKt.plus((Set)SetsKt.setOfNotNull(cone), (Iterable)this.getCommonExcludedValues(statements2));
        return !((Collection)newUpperTypes).isEmpty() || !((Collection)newLowerTypes).isEmpty() ? (TypeStatement)new PersistentTypeStatement(variable, (PersistentSet<? extends ConeKotlinType>)newUpperTypes, (PersistentSet<? extends DfaType>)ExtensionsKt.toPersistentSet((Iterable)newLowerTypes)) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeKotlinType getUnifiedUpperType(Collection<? extends TypeStatement> $this$getUnifiedUpperType) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$getUnifiedUpperType;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Set<ConeKotlinType> set;
            Collection collection;
            block4: {
                block3: {
                    void statement;
                    TypeStatement typeStatement = (TypeStatement)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    set = statement.getUpperTypesOrNull();
                    if (set == null || (set = CollectionsKt.toList((Iterable)set)) == null) break block3;
                    Collection<ConeKotlinType> it = set;
                    boolean bl2 = false;
                    ConeKotlinType coneKotlinType = ConeTypeIntersector.INSTANCE.intersectTypes(this.context, (Collection<? extends ConeKotlinType>)it);
                    set = coneKotlinType;
                    if (coneKotlinType != null) break block4;
                }
                set = this.context.nullableAnyType();
            }
            collection.add(set);
        }
        List intersectedUpperTypes = (List)destination$iv$iv;
        return TypeUtilsKt.commonSuperTypeOrNull(this.context, intersectedUpperTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final ConeKotlinType getIntersectedLowerType(Collection<? extends TypeStatement> $this$getIntersectedLowerType) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$getIntersectedLowerType;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list2;
            void $this$mapNotNullTo$iv$iv;
            TypeStatement statement = (TypeStatement)element$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = statement.getLowerTypes();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ConeKotlinType it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                DfaType it = (DfaType)element$iv$iv2;
                boolean bl3 = false;
                DfaType.Cone cone = it instanceof DfaType.Cone ? (DfaType.Cone)it : null;
                if ((cone != null ? cone.getType() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List it = list2 = (List)destination$iv$iv2;
            boolean bl5 = false;
            List list3 = !((Collection)it).isEmpty() ? list2 : null;
            if (list3 == null) {
                list3 = CollectionsKt.listOf((Object)this.context.nothingType());
            }
            Iterable list$iv$iv = list3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Object it = (List)destination$iv$iv;
        boolean bl = false;
        ConeKotlinType coneKotlinType = ConeTypeIntersector.INSTANCE.intersectTypes(this.context, (Collection)it);
        it = coneKotlinType;
        boolean bl6 = false;
        return !ConeBuiltinTypeUtilsKt.isNothing((ConeKotlinType)it) ? coneKotlinType : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<DfaType.Symbol> getCommonExcludedValues(Collection<? extends TypeStatement> $this$getCommonExcludedValues) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$getCommonExcludedValues;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterIsInstanceTo$iv$iv;
            TypeStatement it = (TypeStatement)element$iv$iv;
            boolean bl = false;
            Iterable $this$filterIsInstance$iv = it.getLowerTypes();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof DfaType.Symbol)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupingBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupingBy = false;
        Map $this$filterValues$iv = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<DfaType.Symbol, DfaType.Symbol>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            public Iterator<DfaType.Symbol> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                DfaType.Symbol it = (DfaType.Symbol)element;
                boolean bl = false;
                return var2_2;
            }
        }));
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            int it = ((Number)entry$iv.getValue()).intValue();
            boolean bl = false;
            if (!(it == $this$getCommonExcludedValues.size())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return ((Map)result$iv).keySet();
    }

    private static final Implication translateVariableFromConditionInStatements$lambda$0(Implication it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final Unit replaceVariable$lambda$0(LogicSystem this$0, MutableFlow $this_replaceVariable, RealVariable old, RealVariable realVariable) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        this$0.replaceVariable($this_replaceVariable, old, realVariable);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean approveOperationStatement$lambda$2(Operation $operation, LinkedList $queue, LogicSystem this$0, Map $result, boolean $removeApprovedOrImpossible, Implication it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Boolean knownValue = it.getCondition().getOperation().valueIfKnown($operation);
        if (Intrinsics.areEqual((Object)knownValue, (Object)true)) {
            Statement effect = it.getEffect();
            if (effect instanceof OperationStatement) {
                ((Collection)$queue).add(effect);
            } else if (effect instanceof TypeStatement) {
                Object object;
                void $this$getOrPut$iv;
                LogicSystem logicSystem2 = this$0;
                Map map2 = $result;
                DataFlowVariable key$iv = ((TypeStatement)effect).getVariable();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    LogicSystem logicSystem3 = logicSystem2;
                    boolean bl = false;
                    logicSystem2 = logicSystem3;
                    MutableTypeStatement answer$iv = new MutableTypeStatement(((TypeStatement)effect).getVariable(), null, null, 6, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                logicSystem2.plusAssign((MutableTypeStatement)object, (TypeStatement)effect);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return $removeApprovedOrImpossible && knownValue != null;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Operation.values().length];
            try {
                nArray[Operation.EqTrue.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operation.EqFalse.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

