/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirInlineDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirPropertyWithExplicitBackingFieldResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ExplicitFieldsUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ/\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "loadExperimentalitiesFromExplicitField", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality;", "dispatchReceiver", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Ljava/util/Set;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInUsageAccessChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInUsageAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n39#2:84\n1#3:85\n*S KotlinDebug\n*F\n+ 1 FirOptInUsageAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker\n*L\n57#1:84\n*E\n"})
public final class FirOptInUsageAccessChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirOptInUsageAccessChecker INSTANCE = new FirOptInUsageAccessChecker();

    private FirOptInUsageAccessChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirStatement expression) {
        KtSourceElementKind sourceKind;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KtSourceElement ktSourceElement = expression.getSource();
        Object object = sourceKind = ktSourceElement != null ? ktSourceElement.getKind() : null;
        if (sourceKind instanceof KtFakeSourceElementKind.DataClassGeneratedMembers || sourceKind instanceof KtFakeSourceElementKind.PropertyFromParameter) {
            return;
        }
        if (FirHelpersKt.isLhsOfAssignment(context2, expression)) {
            return;
        }
        Object object2 = ReferenceUtilsKt.toReference(expression, context2.getSession());
        if (object2 == null || (object2 = FirReferenceUtilsKt.toResolvedBaseSymbol$default((FirReference)object2, false, 1, null)) == null) {
            return;
        }
        Object resolvedSymbol = object2;
        FirOptInUsageBaseChecker $this$check_u24lambda_u240 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        FirStatement firStatement = expression;
        if (firStatement instanceof FirVariableAssignment) {
            Set experimentalities = SetsKt.plus($this$check_u24lambda_u240.loadExperimentalities(context2, (FirBasedSymbol<?>)resolvedSymbol, true, null), (Iterable)$this$check_u24lambda_u240.loadExperimentalitiesFromTypeArguments(context2, CollectionsKt.emptyList()));
            FirOptInUsageBaseChecker.reportNotAcceptedExperimentalities$default($this$check_u24lambda_u240, context2, reporter, experimentalities, ((FirVariableAssignment)expression).getLValue(), null, 16, null);
        } else if (firStatement instanceof FirQualifiedAccessExpression) {
            ConeKotlinType coneKotlinType;
            FirExpression firExpression = ((FirQualifiedAccessExpression)expression).getDispatchReceiver();
            ConeKotlinType dispatchReceiverType = firExpression != null && (coneKotlinType = FirTypeUtilsKt.getResolvedType(firExpression)) != null ? TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, coneKotlinType) : null;
            Set experimentalities = SetsKt.plus((Set)SetsKt.plus($this$check_u24lambda_u240.loadExperimentalities(context2, (FirBasedSymbol<?>)resolvedSymbol, false, dispatchReceiverType), (Iterable)$this$check_u24lambda_u240.loadExperimentalitiesFromTypeArguments(context2, ((FirQualifiedAccessExpression)expression).getTypeArguments())), (Iterable)INSTANCE.loadExperimentalitiesFromExplicitField(context2, expression, dispatchReceiverType));
            KtSourceElement ktSourceElement2 = ((FirQualifiedAccessExpression)expression).getSource();
            KtSourceElement source = ktSourceElement2 != null ? SourceHelpersKt.delegatedPropertySourceOrThis(context2, ktSourceElement2) : null;
            $this$check_u24lambda_u240.reportNotAcceptedExperimentalities(context2, reporter, experimentalities, expression, source);
        } else if (firStatement instanceof FirDelegatedConstructorCall && resolvedSymbol instanceof FirConstructorSymbol) {
            FirCallableSymbol $this$isFromEnumClass$iv = (FirCallableSymbol)resolvedSymbol;
            boolean $i$f$isFromEnumClass = false;
            Set<FirOptInUsageBaseChecker.Experimentality> experimentalities = $this$isFromEnumClass$iv.getRawStatus().isFromEnumClass() ? $this$check_u24lambda_u240.loadExperimentalities(context2, (FirBasedSymbol<?>)resolvedSymbol, false, null) : $this$check_u24lambda_u240.loadExperimentalitiesFromConstructor(context2, (FirConstructorSymbol)resolvedSymbol);
            FirOptInUsageBaseChecker.reportNotAcceptedExperimentalities$default($this$check_u24lambda_u240, context2, reporter, experimentalities, ((FirDelegatedConstructorCall)expression).getCalleeReference(), null, 16, null);
        }
    }

    @NotNull
    public final Set<FirOptInUsageBaseChecker.Experimentality> loadExperimentalitiesFromExplicitField(@NotNull CheckerContext context2, @NotNull FirStatement expression, @Nullable ConeKotlinType dispatchReceiver) {
        FirPropertySymbol firPropertySymbol;
        FirPropertyWithExplicitBackingFieldResolvedNamedReference reference;
        block7: {
            block6: {
                FirPropertySymbol firPropertySymbol2;
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (!(expression instanceof FirPropertyAccessExpression)) {
                    return SetsKt.emptySet();
                }
                FirNamedReference firNamedReference = ((FirPropertyAccessExpression)expression).getCalleeReference();
                FirPropertyWithExplicitBackingFieldResolvedNamedReference firPropertyWithExplicitBackingFieldResolvedNamedReference = firNamedReference instanceof FirPropertyWithExplicitBackingFieldResolvedNamedReference ? (FirPropertyWithExplicitBackingFieldResolvedNamedReference)firNamedReference : null;
                if (firPropertyWithExplicitBackingFieldResolvedNamedReference == null) {
                    return SetsKt.emptySet();
                }
                reference = firPropertyWithExplicitBackingFieldResolvedNamedReference;
                firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(reference, false, 1, null);
                if (firPropertySymbol == null) break block6;
                FirPropertySymbol it = firPropertySymbol2 = firPropertySymbol;
                boolean bl = false;
                firPropertySymbol = DeclarationAttributesKt.getHasExplicitBackingField(it) ? firPropertySymbol2 : null;
                if (firPropertySymbol != null) break block7;
            }
            return SetsKt.emptySet();
        }
        FirPropertySymbol property = firPropertySymbol;
        FirInlineDeclarationChecker.InlineFunctionBodyContext inlineFunctionBodyContext = context2.getInlineFunctionBodyContext();
        FirBackingFieldSymbol firBackingFieldSymbol = ExplicitFieldsUtilsKt.tryAccessExplicitFieldSymbol(reference, inlineFunctionBodyContext != null ? inlineFunctionBodyContext.getInlineFunction() : null, context2.getSession());
        if (firBackingFieldSymbol == null) {
            return SetsKt.emptySet();
        }
        FirBackingFieldSymbol field2 = firBackingFieldSymbol;
        return Intrinsics.areEqual((Object)property.getBackingFieldSymbol(), (Object)field2) ? FirOptInUsageBaseChecker.INSTANCE.loadExperimentalities(context2, field2, false, dispatchReceiver) : SetsKt.emptySet();
    }
}

