/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.CallableIdKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B?\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\f\"\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ-\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0002H\u0016R\u00020\u0017R\u00020\u0019j\u0006\u0010\u0018\u001a\u00020\u0017j\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001cR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/AbstractAtomicReferenceToPrimitiveCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "appropriateCandidatesForArgument", "", "Lorg/jetbrains/kotlin/name/ClassId;", "mppKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "firstProblematicCallableId", "Lorg/jetbrains/kotlin/name/CallableId;", "remainingProblematicCallableIds", "", "<init>", "(Ljava/util/Map;Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;Lorg/jetbrains/kotlin/name/CallableId;[Lorg/jetbrains/kotlin/name/CallableId;)V", "getAppropriateCandidatesForArgument", "()Ljava/util/Map;", "problematicCallableIds", "", "getProblematicCallableIds", "()Ljava/util/Set;", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "checkers"})
public abstract class AbstractAtomicReferenceToPrimitiveCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    private final Map<ClassId, ClassId> appropriateCandidatesForArgument;
    @NotNull
    private final Set<CallableId> problematicCallableIds;

    public AbstractAtomicReferenceToPrimitiveCallChecker(@NotNull Map<ClassId, ClassId> appropriateCandidatesForArgument, @NotNull MppCheckerKind mppKind, @NotNull CallableId firstProblematicCallableId, CallableId ... remainingProblematicCallableIds) {
        Intrinsics.checkNotNullParameter(appropriateCandidatesForArgument, (String)"appropriateCandidatesForArgument");
        Intrinsics.checkNotNullParameter((Object)((Object)mppKind), (String)"mppKind");
        Intrinsics.checkNotNullParameter((Object)firstProblematicCallableId, (String)"firstProblematicCallableId");
        Intrinsics.checkNotNullParameter((Object)remainingProblematicCallableIds, (String)"remainingProblematicCallableIds");
        super(mppKind);
        this.appropriateCandidatesForArgument = appropriateCandidatesForArgument;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)firstProblematicCallableId);
        spreadBuilder.addSpread((Object)remainingProblematicCallableIds);
        this.problematicCallableIds = SetsKt.setOf((Object[])spreadBuilder.toArray((Object[])new CallableId[spreadBuilder.size()]));
    }

    @NotNull
    public final Map<ClassId, ClassId> getAppropriateCandidatesForArgument() {
        return this.appropriateCandidatesForArgument;
    }

    @NotNull
    public final Set<CallableId> getProblematicCallableIds() {
        return this.problematicCallableIds;
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(expression.getCalleeReference());
        Object object = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
        FirFunctionSymbol firFunctionSymbol = object instanceof FirFunctionSymbol ? (FirFunctionSymbol)object : null;
        if (firFunctionSymbol == null) {
            return;
        }
        FirFunctionSymbol callable = firFunctionSymbol;
        object = expression.getDispatchReceiver();
        if (object == null || (coneKotlinType2 = FirTypeUtilsKt.getResolvedType((FirExpression)object)) == null || (coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, coneKotlinType2)) == null) {
            return;
        }
        ConeKotlinType receiverType = coneKotlinType;
        ClassId classId = ConeTypeUtilsKt.getClassId(receiverType);
        if (classId == null) {
            return;
        }
        ClassId atomicReferenceClassId = classId;
        CallableId fullyExpandedCallableId = CallableIdKt.withClassId((CallableId)callable.getCallableId(), (ClassId)atomicReferenceClassId);
        if (this.problematicCallableIds.contains(fullyExpandedCallableId)) {
            FirHelpersKt.reportAtomicToPrimitiveProblematicAccess(context2, reporter, receiverType, expression.getSource(), atomicReferenceClassId, this.appropriateCandidatesForArgument);
        }
    }
}

