/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ThrowableRunnable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    @NotNull
    public static Throwable getRootCause(@NotNull Throwable e) {
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(0);
        }
        while (true) {
            if (e.getCause() == null) {
                Throwable throwable = e;
                if (throwable == null) {
                    ExceptionUtil.$$$reportNull$$$0(1);
                }
                return throwable;
            }
            e = e.getCause();
        }
    }

    public static <T> T findCause(Throwable e, Class<T> klass) {
        return (T)ExceptionUtilRt.findCause((Throwable)e, klass);
    }

    public static boolean causedBy(Throwable e, Class<?> klass) {
        return ExceptionUtilRt.causedBy((Throwable)e, klass);
    }

    public static <T> @Unmodifiable @NotNull List<T> findCauseAndSuppressed(@NotNull Throwable error, @NotNull Class<T> klass) {
        if (error == null) {
            ExceptionUtil.$$$reportNull$$$0(2);
        }
        if (klass == null) {
            ExceptionUtil.$$$reportNull$$$0(3);
        }
        List list = ExceptionUtil.causeAndSuppressed(error, klass).collect(Collectors.toList());
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @ApiStatus.Internal
    @NotNull
    public static <T> Stream<T> causeAndSuppressed(@NotNull Throwable error, @NotNull Class<T> klass) {
        if (error == null) {
            ExceptionUtil.$$$reportNull$$$0(5);
        }
        if (klass == null) {
            ExceptionUtil.$$$reportNull$$$0(6);
        }
        LinkedHashSet<Throwable> allThrowables = new LinkedHashSet<Throwable>();
        ArrayDeque<Throwable> deque = new ArrayDeque<Throwable>();
        deque.add(error);
        while (!deque.isEmpty()) {
            Throwable t = (Throwable)deque.removeFirst();
            if (!allThrowables.add(t)) continue;
            for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
                deque.addLast(cause);
            }
            for (Throwable s : t.getSuppressed()) {
                deque.addLast(s);
            }
        }
        Stream<Object> stream = allThrowables.stream().filter(klass::isInstance).map(klass::cast);
        if (stream == null) {
            ExceptionUtil.$$$reportNull$$$0(7);
        }
        return stream;
    }

    @NotNull
    public static Throwable makeStackTraceRelative(@NotNull Throwable th, @NotNull Throwable relativeTo) {
        if (th == null) {
            ExceptionUtil.$$$reportNull$$$0(8);
        }
        if (relativeTo == null) {
            ExceptionUtil.$$$reportNull$$$0(9);
        }
        StackTraceElement[] trace = th.getStackTrace();
        StackTraceElement[] rootTrace = relativeTo.getStackTrace();
        int len = Math.min(trace.length, rootTrace.length);
        for (int i = 0; i < len; ++i) {
            if (trace[trace.length - i - 1].equals(rootTrace[rootTrace.length - i - 1])) continue;
            int newDepth = trace.length - i;
            th.setStackTrace(Arrays.copyOf(trace, newDepth));
            break;
        }
        Throwable throwable = th;
        if (throwable == null) {
            ExceptionUtil.$$$reportNull$$$0(10);
        }
        return throwable;
    }

    @NotNull
    public static String currentStackTrace() {
        return ExceptionUtil.getThrowableText(new Throwable());
    }

    @NlsSafe
    @NotNull
    public static String getThrowableText(@NotNull Throwable t) {
        if (t == null) {
            ExceptionUtil.$$$reportNull$$$0(11);
        }
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        String string = writer.getBuffer().toString();
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable, @NotNull String stackFrameSkipPattern) {
        if (aThrowable == null) {
            ExceptionUtil.$$$reportNull$$$0(13);
        }
        if (stackFrameSkipPattern == null) {
            ExceptionUtil.$$$reportNull$$$0(14);
        }
        String string = ExceptionUtilRt.getThrowableText((Throwable)aThrowable, (String)stackFrameSkipPattern);
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getUserStackTrace(@NotNull Throwable throwable, @NotNull Logger logger) {
        String result;
        if (throwable == null) {
            ExceptionUtil.$$$reportNull$$$0(16);
        }
        if (logger == null) {
            ExceptionUtil.$$$reportNull$$$0(17);
        }
        if ((result = ExceptionUtil.getThrowableText(throwable, "com.intellij.")).contains("\n\tat") || throwable.getStackTrace().length <= 0) {
            String string = result.trim() + " (no stack trace)";
            if (string == null) {
                ExceptionUtil.$$$reportNull$$$0(18);
            }
            return string;
        }
        logger.error(throwable);
        String string = result;
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NlsSafe
    @Nullable
    public static String getMessage(@NotNull Throwable e) {
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(20);
        }
        String result = e.getMessage();
        String exceptionPattern = "Exception: ";
        String errorPattern = "Error: ";
        while (e.getCause() != null && (result == null || result.contains(exceptionPattern) || result.contains(errorPattern))) {
            e = e.getCause();
            result = e.getMessage();
        }
        if (result != null) {
            result = ExceptionUtil.extractMessage(result, exceptionPattern);
            result = ExceptionUtil.extractMessage(result, errorPattern);
        }
        return result;
    }

    @NotNull
    private static String extractMessage(@NotNull String result, @NotNull String errorPattern) {
        if (result == null) {
            ExceptionUtil.$$$reportNull$$$0(21);
        }
        if (errorPattern == null) {
            ExceptionUtil.$$$reportNull$$$0(22);
        }
        if (result.lastIndexOf(errorPattern) >= 0) {
            result = result.substring(result.lastIndexOf(errorPattern) + errorPattern.length());
        }
        String string = result;
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    public static void rethrowUnchecked(@Nullable Throwable t) throws RuntimeException, Error {
        ExceptionUtilRt.rethrowUnchecked((Throwable)t);
    }

    @Contract(value="!null->fail")
    public static void rethrowAll(@Nullable Throwable t) throws Exception {
        ExceptionUtilRt.rethrowAll((Throwable)t);
    }

    @Contract(value="_->fail")
    public static void rethrow(@Nullable Throwable throwable) throws RuntimeException, Error {
        ExceptionUtil.rethrowUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    @Contract(value="!null->fail")
    public static void rethrowAllAsUnchecked(@Nullable Throwable t) throws RuntimeException, Error {
        if (t != null) {
            ExceptionUtil.rethrow(t);
        }
    }

    @NotNull
    @NlsSafe
    public static String getNonEmptyMessage(@NotNull Throwable t, @NotNull @Nls String defaultMessage) {
        String message;
        if (t == null) {
            ExceptionUtil.$$$reportNull$$$0(24);
        }
        if (defaultMessage == null) {
            ExceptionUtil.$$$reportNull$$$0(25);
        }
        String string = !StringUtilRt.isEmptyOrSpaces((CharSequence)(message = t.getMessage())) ? message : defaultMessage;
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Nullable
    public static Exception runAndCatch(@NotNull ThrowableRunnable<? extends Exception> runnable) {
        if (runnable == null) {
            ExceptionUtil.$$$reportNull$$$0(27);
        }
        try {
            runnable.run();
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    @SafeVarargs
    public static <E extends Exception> void runAllAndRethrowAllExceptions(@NotNull Class<? extends E> exampleClass, @NotNull Supplier<E> exampleSupplier, ThrowableRunnable<? extends Exception> ... potentiallyFailingTasks) throws E {
        if (exampleClass == null) {
            ExceptionUtil.$$$reportNull$$$0(28);
        }
        if (exampleSupplier == null) {
            ExceptionUtil.$$$reportNull$$$0(29);
        }
        if (potentiallyFailingTasks == null) {
            ExceptionUtil.$$$reportNull$$$0(30);
        }
        Function<List, Exception> combiner = exceptions -> {
            Throwable exception = null;
            for (Throwable e : exceptions) {
                if (exception == null) {
                    if (exampleClass.isAssignableFrom(e.getClass())) {
                        exception = (Exception)e;
                        continue;
                    }
                    exception = (Exception)exampleSupplier.get();
                    exception.addSuppressed(e);
                    continue;
                }
                exception.addSuppressed(e);
            }
            return exception;
        };
        ExceptionUtil.runAllAndRethrowAllExceptions(combiner, potentiallyFailingTasks);
    }

    @SafeVarargs
    @ApiStatus.Internal
    public static <E extends Exception> void runAllAndRethrowAllExceptions(@NotNull Function<? super List<? extends Throwable>, E> exceptionsCombiner, ThrowableRunnable<? extends Exception> ... potentiallyFailingTasks) throws E {
        if (exceptionsCombiner == null) {
            ExceptionUtil.$$$reportNull$$$0(31);
        }
        if (potentiallyFailingTasks == null) {
            ExceptionUtil.$$$reportNull$$$0(32);
        }
        ArrayList<Throwable> exceptions = null;
        for (ThrowableRunnable<? extends Exception> potentiallyFailingTask : potentiallyFailingTasks) {
            try {
                potentiallyFailingTask.run();
            }
            catch (Throwable e) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Throwable>();
                }
                exceptions.add(e);
            }
        }
        if (exceptions != null) {
            throw (Exception)exceptionsCombiner.apply(exceptions);
        }
    }

    @NotNull
    public static Throwable unwrapException(@NotNull Throwable throwable, @NotNull Class<? extends Throwable> classToUnwrap) {
        if (throwable == null) {
            ExceptionUtil.$$$reportNull$$$0(33);
        }
        if (classToUnwrap == null) {
            ExceptionUtil.$$$reportNull$$$0(34);
        }
        Throwable throwable2 = ExceptionUtilRt.unwrapException((Throwable)throwable, classToUnwrap);
        if (throwable2 == null) {
            ExceptionUtil.$$$reportNull$$$0(35);
        }
        return throwable2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ExceptionUtil";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeTo";
                break;
            }
            case 11: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameSkipPattern";
                break;
            }
            case 16: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorPattern";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMessage";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exampleClass";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exampleSupplier";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "potentiallyFailingTasks";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionsCombiner";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToUnwrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ExceptionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootCause";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findCauseAndSuppressed";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "causeAndSuppressed";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "makeStackTraceRelative";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserStackTrace";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMessage";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonEmptyMessage";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootCause";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 35: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findCauseAndSuppressed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "causeAndSuppressed";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "makeStackTraceRelative";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUserStackTrace";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "extractMessage";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptyMessage";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "runAndCatch";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "runAllAndRethrowAllExceptions";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "unwrapException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

