/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrAnnotationCollector;
import org.jetbrains.plugins.groovy.lang.resolve.ElementResolveResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0007H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\rH\u0016J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u000bH\u0016J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0007H\u0016J\b\u0010\u001c\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationMethodReference;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyReference;", "element", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/annotation/GrAnnotationNameValuePair;", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/annotation/GrAnnotationNameValuePair;)V", "getElement", "Lcom/intellij/psi/PsiElement;", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getCanonicalText", "", "isReferenceTo", "", "resolve", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "incomplete", "multiResolveFromAlias", "", "alias", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/annotation/GrAnnotation;", "name", "annotationCollector", "Lcom/intellij/psi/PsiAnnotation;", "handleElementRename", "newElementName", "bindToElement", "isSoft", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nGrAnnotationMethodReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrAnnotationMethodReference.kt\norg/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationMethodReference\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,84:1\n11561#2:85\n11896#2,3:86\n11896#2,3:89\n*S KotlinDebug\n*F\n+ 1 GrAnnotationMethodReference.kt\norg/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationMethodReference\n*L\n47#1:85\n47#1:86,3\n60#1:89,3\n*E\n"})
public final class GrAnnotationMethodReference
implements GroovyReference {
    @NotNull
    private final GrAnnotationNameValuePair element;

    public GrAnnotationMethodReference(@NotNull GrAnnotationNameValuePair element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.element = element;
    }

    @NotNull
    public PsiElement getElement() {
        return this.element;
    }

    @NotNull
    public TextRange getRangeInElement() {
        PsiElement psiElement = this.element.getNameIdentifierGroovy();
        Intrinsics.checkNotNull((Object)psiElement);
        PsiElement nameId = psiElement;
        TextRange textRange = nameId.getTextRange().shiftLeft(this.element.getTextRange().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftLeft(...)");
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeInElement().substring(this.element.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof PsiMethod && element.getManager().areElementsEquivalent(element, this.resolve());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<GroovyResolveResult> resolve(boolean incomplete) {
        PsiAnnotation collector;
        String name;
        GrAnnotation grAnnotation = PsiImplUtil.getAnnotation(this.element);
        if (grAnnotation == null) {
            return CollectionsKt.emptyList();
        }
        GrAnnotation annotation = grAnnotation;
        GrCodeReferenceElement grCodeReferenceElement = annotation.getClassReference();
        Intrinsics.checkNotNullExpressionValue((Object)grCodeReferenceElement, (String)"getClassReference(...)");
        GrCodeReferenceElement ref2 = grCodeReferenceElement;
        PsiElement psiElement = ref2.resolve();
        PsiClass psiClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass resolved = psiClass;
        String string = this.element.getName();
        if (string == null) {
            string = name = "value";
        }
        if ((collector = GrAnnotationCollector.findAnnotationCollector(resolved)) != null) {
            return this.multiResolveFromAlias(annotation, name, collector);
        }
        if (resolved.isAnnotationType()) {
            void $this$mapTo$iv$iv;
            PsiMethod[] psiMethodArray = resolved.findMethodsByName(name, false);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
            Object[] $this$map$iv = psiMethodArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                PsiMethod psiMethod = (PsiMethod)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ElementResolveResult<PsiElement>((PsiElement)p0));
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final List<GroovyResolveResult> multiResolveFromAlias(GrAnnotation alias, String name, PsiAnnotation annotationCollector) {
        List annotations = new ArrayList();
        GrAnnotationCollector.collectAnnotations(annotations, alias, annotationCollector);
        List result2 = new ArrayList();
        for (GrAnnotation annotation : annotations) {
            void $this$mapTo$iv;
            PsiClass clazz;
            PsiElement psiElement = annotation.getClassReference().resolve();
            PsiClass psiClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
            if (psiClass == null || !(clazz = psiClass).isAnnotationType() || Intrinsics.areEqual((Object)clazz.getQualifiedName(), (Object)"groovy.transform.AnnotationCollector")) continue;
            PsiMethod[] psiMethodArray = clazz.findMethodsByName(name, false);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
            Object[] objectArray = psiMethodArray;
            Collection destination$iv = result2;
            boolean $i$f$mapTo = false;
            for (void item$iv : $this$mapTo$iv) {
                void p0;
                PsiMethod psiMethod = (PsiMethod)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                collection.add(new ElementResolveResult<PsiElement>((PsiElement)p0));
            }
        }
        return result2;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        PsiElement nameElement = this.element.getNameIdentifierGroovy();
        ASTNode aSTNode = GroovyPsiElementFactory.getInstance(this.element.getProject()).createReferenceNameFromText(newElementName).getNode();
        Intrinsics.checkNotNull((Object)aSTNode);
        ASTNode newNameNode = aSTNode;
        if (nameElement != null) {
            ASTNode node = nameElement.getNode();
            this.element.getNode().replaceChild(node, newNameNode);
        } else {
            PsiElement psiElement = this.element.getFirstChild();
            ASTNode anchorBefore = psiElement != null ? psiElement.getNode() : null;
            this.element.getNode().addLeaf(GroovyTokenTypes.mASSIGN, (CharSequence)"=", anchorBefore);
            this.element.getNode().addChild(newNameNode, anchorBefore);
        }
        return this.element;
    }

    @NotNull
    public PsiElement bindToElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        throw new IncorrectOperationException("NYI");
    }

    public boolean isSoft() {
        return false;
    }
}

