#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.50.2
visibility:           public
id:                   hledger-web-1.50.2-4f66kpV5dzC3v54uhLXFE5
key:                  hledger-web-1.50.2-4f66kpV5dzC3v54uhLXFE5
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  e9c62e8a87a95d17ffe74a0589864fa9
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-web-1.50.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-web-1.50.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-web-1.50.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.50.2-4f66kpV5dzC3v54uhLXFE5
depends:
    Decimal-0.5.2-IIe9wLiWUhH4Fx4Eysbzm9
    aeson-2.1.2.1-JZeWX2s1eQL7Ta3HF3w6fW base-4.18.2.1
    base64-1.0-3wiRQUXKhf52k6Dt5xaYz6
    blaze-html-0.9.2.0-LUjYdeknUl1Ef7LhdtXXgs
    blaze-markup-0.8.3.0-Donjg3mDQKIJPFMPJHNoUU bytestring-0.11.5.3
    case-insensitive-1.2.1.0-LnNRkIvaVf25YvATjz2MZ1
    clientsession-0.9.3.0-5C2rytyTvSEDD0XGJnjktp
    cmdargs-0.10.22-E2EkQI5shziHkHOdPiVHiM
    conduit-1.3.6.1-JmvSlylEAqiI8LFhx2lxVp
    conduit-extra-1.3.8-GJ8Ijj1CXjtIz1f8rXkRx2 containers-0.6.7
    data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz directory-1.3.8.5
    extra-1.7.16-LWra3MmVE7hIjr4mBFp6lZ
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    githash-0.1.6.3-1Ht0cPVU7ZGKXTqeGDFgaK
    hjsmin-0.2.1-1ODSAykwJaHr2xRbkabqy
    hledger-1.50.2-CigMhgd3MbV8yC5K1t6TTo
    hledger-lib-1.50.2-4ekRkFuTMHa3jBreHk6XTU
    hspec-2.11.4-DsuBXVi1VAG3EB3oodlHQU
    http-client-0.7.19-B5USSZypF8s1UPWufciwbp
    http-conduit-2.3.9.1-5YDZP1W1TG7LHVkUDM627s
    http-types-0.12.4-Ab6499xPt6j7ocIybq2ygA
    megaparsec-9.7.0-I0qZdfD2x7QA5TPaNUjmTK mtl-2.3.1
    network-3.1.4.0-DqImTC0JtBs7wAjAQOfbw6
    safe-0.3.21-EsRFO8M87PCEtDqVSuBNfo
    shakespeare-2.1.7-9GhatDl4bgQKJXbbqjeqzs template-haskell-2.20.0.0
    text-2.0.2 time-1.12.2 transformers-0.6.1.0
    unix-compat-0.7.4.1-HX6CmWtGzNSCIQWePfXCFw
    unordered-containers-0.2.20.1-8SON4238u8N3rDHPceHjHx
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1
    wai-3.2.4-L3dKuQqjqvcGg94VR3jCz4
    wai-cors-0.2.7-7DdzWeEevoLGhcgpUdtWjB
    wai-extra-3.1.18-2f6rFhhByJDESekjCjUoPV
    wai-handler-launch-3.0.3.1-K8MycKPKJnqDOUc3aOLTlg
    warp-3.4.0-LPhizoV0zB3FM7W9iJLTSy
    yaml-0.11.11.2-CS9jj0skP8B8obc9v5e4bH
    yesod-1.6.2.1-JOxTC9kI8bmGBmufGt5w0I
    yesod-core-1.6.27.1-GuIK91GYWiY3LbbkZm3xHw
    yesod-form-1.7.9-2PzXLXqD7ZPFr5LOQlZelR
    yesod-static-1.6.1.0-pDLKZdpeENAwts7u1lAnk
    yesod-test-1.6.23-JcRzAwKNOhL6x4PqZPNFZV

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

