---
stage: Verify
group: Runner Core
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: DevOps Research and Assessment (DORA) metrics charts
---

{{< details >}}

- Tier: Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

The [DevOps Research and Assessment (DORA) metrics](dora_metrics.md) dashboard displays the evolution of each DORA metric over time, for the last week, month, 90 days, or 180 days.
This information provides insights into the health of your organization.

## View DORA metrics analytics

You can view the DORA metrics dashboard for a group or project.

Prerequisites:

- To view DORA metrics, the group or project must have an environment in the [production deployment tier](../../ci/environments/_index.md#deployment-tier-of-environments).

### For a group

To view the DORA metrics dashboard for a group:

1. On the top bar, select **Search or go to** and find your group.
1. Select **Analyze** > **Analytics Dashboards**.
1. Select **DORA metrics dashboard**.

### For a project

To view the DORA metrics dashboard for a project:

1. On the top bar, select **Search or go to** and find your project.
1. Select **Analyze** > **Analytics Dashboards**.
1. Select **DORA metrics dashboard**.
