---
stage: Software Supply Chain Security
group: Compliance
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: プロジェクトとグループに適用されたコンプライアンスフレームワークを表示し、フレームワークの割り当てを管理、フィルタリング、エクスポートするオプションがあります。
title: コンプライアンスプロジェクトレポート
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 15.10で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/387910)されました。
- GitLab 16.5で[コンプライアンスフレームワークレポートから名称変更](https://gitlab.com/gitlab-org/gitlab/-/issues/422963)されました。

{{< /history >}}

コンプライアンスプロジェクトレポートを使用すると、グループ、サブグループ、またはプロジェクト内のプロジェクトに適用されるコンプライアンスフレームワークを表示できます。レポートの各行には、以下が表示されます:

- プロジェクト名。
- プロジェクトのパス。
- プロジェクトに1つ以上の割り当てがある場合のコンプライアンスフレームワークのラベル。

グループのデフォルトフレームワークには、**デフォルト**バッジが付いています。

## コンプライアンスプロジェクトレポートを表示する {#view-the-compliance-projects-report}

前提要件: 

- 管理者であるか、プロジェクトまたはグループのオーナーロールを持っている必要があります。

コンプライアンスプロジェクトレポートを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **コンプライアンスセンター**を選択します。
1. ページで、**プロジェクト**タブを選択します。

## グループ内のプロジェクトにコンプライアンスフレームワークを適用する {#apply-a-compliance-framework-to-projects-in-a-group}

{{< history >}}

- 一括操作を使用したコンプライアンスフレームワークの追加は、GitLab 15.11で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/383209)されました。
- 一括操作を使用しないコンプライアンスフレームワークの追加は、GitLab 16.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/394795)されました。
- サブグループにコンプライアンスフレームワークを追加する機能は、GitLab 17.2で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/469004)されました。
- プロジェクトにコンプライアンスフレームワークを追加する機能は、GitLab 17.9で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/507986)されました。

{{< /history >}}

グループ、サブグループ、またはプロジェクト内のプロジェクトに、1つ以上のコンプライアンスフレームワークを適用できます。

前提要件: 

- グループのオーナーロールを持っている必要があります。

グループ内の1つのプロジェクトにコンプライアンスフレームワークを適用するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **コンプライアンスセンター**を選択します。
1. ページで、**プロジェクト**タブを選択します。
1. コンプライアンスフレームワークを追加するプロジェクトの横にある{{< icon name="pencil" >}}アクションを選択します。
1. 既存のコンプライアンスフレームワークを1つ以上選択するか、新しいフレームワークを作成します。

グループ内の複数のプロジェクトにコンプライアンスフレームワークを適用するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **コンプライアンスセンター**を選択します。
1. ページで、**プロジェクト**タブを選択します。
1. 複数のプロジェクトを選択します。
1. **一括操作を選択**ドロップダウンリストから、**Apply framework to selected projects**（選択したプロジェクトにフレームワークを適用）を選択します。
1. 適用するフレームワークを選択します。
1. **適用**を選択します。

## グループ内のプロジェクトからコンプライアンスフレームワークを削除する {#remove-a-compliance-framework-from-projects-in-a-group}

{{< history >}}

- 一括操作を使用したコンプライアンスフレームワークの削除は、GitLab 15.11で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/383209)されました。
- 一括操作を使用しないコンプライアンスフレームワークの削除は、GitLab 16.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/394795)されました。
- サブグループからコンプライアンスフレームワークを削除する機能は、GitLab 17.2で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/469004)されました。
- プロジェクトからコンプライアンスフレームワークを削除する機能は、GitLab 17.9で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/507986)されました。

{{< /history >}}

グループ、サブグループ、またはプロジェクト内のプロジェクトから、コンプライアンスフレームワークを削除できます。

前提要件: 

- グループのオーナーロールを持っている必要があります。

グループ内の1つのプロジェクトからコンプライアンスフレームワークを削除するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **コンプライアンスセンター**を選択します。
1. ページで、**プロジェクト**タブを選択します。
1. プロジェクトから削除するコンプライアンスフレームワークの横にある、フレームワークのラベルの{{< icon name="close" >}}を選択します。

グループ内の複数のプロジェクトからコンプライアンスフレームワークを削除するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **コンプライアンスセンター**を選択します。
1. ページで、**プロジェクト**タブを選択します。
1. 複数のプロジェクトを選択します。
1. **一括操作を選択**ドロップダウンリストから、**Remove framework from selected projects**（選択したプロジェクトからフレームワークを削除）を選択します。
1. **削除**を選択します。

## グループ内のプロジェクトに関するコンプライアンスフレームワークのレポートをエクスポートする {#export-a-report-of-compliance-frameworks-on-projects-in-a-group}

{{< history >}}

- GitLab 16.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/387912)されました。

{{< /history >}}

グループ内のプロジェクトに適用されるコンプライアンスフレームワークのレポートをエクスポートします。レポート:

- フレームワークレポートでフィルターを使用しないでください。
- メールの添付ファイルが大きくなりすぎないように、15 MBで切り詰められます。

前提要件: 

- グループの管理者であるか、オーナーロールを持っている必要があります。

グループ内のプロジェクトに関するコンプライアンスフレームワークのレポートをエクスポートするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **コンプライアンスセンター**を選択します。
1. 右上隅で、**エクスポート**を選択します。
1. **プロジェクトフレームワークのリストをエクスポートします**を選択します。

レポートがコンパイルされ、添付ファイルとしてメールの受信箱に配信されます。

## コンプライアンスプロジェクトレポートをフィルタリングする {#filter-the-compliance-projects-report}

{{< history >}}

- GitLab 15.11で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/387911)されました。

{{< /history >}}

コンプライアンスフレームワークのリストをフィルタリングするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **コンプライアンスセンター**を選択します。
1. ページで、**プロジェクト**タブを選択します。
1. 検索ボックス:
   1. フィルタリングする属性を選択します。
   1. 演算子を選択します。
   1. オプションのリストから選択するか、検索のテキストを入力します。
1. **検索**を選択します。

複数の属性でフィルタリングするには、このプロセスを繰り返します。

## 新しいコンプライアンスフレームワークを作成する {#create-a-new-compliance-framework}

トップレベルグループで新しいコンプライアンスフレームワークを作成できます。

前提要件: 

- グループの管理者であるか、オーナーロールを持っている必要があります。

コンプライアンスプロジェクトレポートから新しいコンプライアンスフレームワークを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **コンプライアンスセンター**を選択します。
1. ページで、**プロジェクト**タブを選択します。
1. **\+ Add framework**（+ フレームワークを追加）を選択します。
1. **新しいフレームワークを作成**を選択します。
1. **フレームワークを追加**を選択して、コンプライアンスフレームワークを作成します。

## コンプライアンスフレームワークを編集する {#edit-a-compliance-framework}

トップレベルグループのコンプライアンスフレームワークを編集できます。

前提要件: 

- グループの管理者であるか、オーナーロールを持っている必要があります。

コンプライアンスプロジェクトレポートからコンプライアンスフレームワークを編集するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **コンプライアンスセンター**を選択します。
1. ページで、**プロジェクト**タブを選択します。
1. フレームワークにカーソルを合わせる、**フレームワークを編集**を選択します。
1. **変更を保存**を選択して、コンプライアンスフレームワークを編集します。

## コンプライアンスフレームワークを削除する {#delete-a-compliance-framework}

トップレベルグループからコンプライアンスフレームワークを削除できます。

前提要件: 

- グループの管理者であるか、オーナーロールを持っている必要があります。

コンプライアンスプロジェクトレポートからコンプライアンスフレームワークを削除するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **コンプライアンスセンター**を選択します。
1. ページで、**プロジェクト**タブを選択します。
1. フレームワークにカーソルを合わせる、**フレームワークを編集**を選択します。
1. **フレームワークを削除**を選択して、コンプライアンスフレームワークを削除します。
