---
stage: Fulfillment
group: Utilization
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: GitLabクレジットの仕組みを理解し、クレジットの使用状況を確認します。
title: GitLabクレジット
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed

{{< /details >}}

{{< history >}}

- GitLab 18.7で導入。

{{< /history >}}

GitLabクレジットは、使用量に応じた請求を行うための標準化された消費通貨です。[GitLab Duo Agent Platform](../user/duo_agent_platform/_index.md)ではクレジットが使用され、各使用アクションで一定数のクレジットが消費されます。クレジットは、クレジット乗算テーブルにリストされている、使用する機能とモデルに基づいて計算されます。

GitLabでは、クレジットを取得する方法が3つあります:

- 含まれるクレジット
- 月次コミットメントプール
- オンデマンドクレジット

クレジットの価格については、[GitLabの価格](https://about.gitlab.com/pricing/)をご覧ください。

## 含まれるクレジット {#included-credits}

含まれるクレジットは、PremiumまたはUltimateプランのすべてのユーザーに割り当てられます。これらのクレジットは個人用であり、ユーザー間で共有することはできません。含まれるクレジットは、毎月1日の開始時にリセットされます。未使用のクレジットが翌月にロールオーバーされることはありません。

含まれるクレジットの詳細については、[GitLabプロモーションの利用規約](https://about.gitlab.com/pricing/terms/)をご覧ください。

## 月次コミットメントプール {#monthly-commitment-pool}

月次コミットメントプールは、サブスクリプションのすべてのユーザーが利用できる、クレジットの共有プールです。サブスクリプションのすべてのユーザーは、含まれるクレジットを消費した後、この共有プールから引き出すことができます。

月次コミットメントプールは、年間または複数年の定期期間として購入できます。年間購入したクレジット数は12で割られます。

たとえば、年間12,000 GitLabクレジットを購入するとします。月あたり1,000にアクセスでき、これは月次コミットメントプールを表します。

GitLabアカウントチームを通じて、いつでもコミットメントを増やすことができます。追加のコミットメントは、契約期間の残りの期間に適用されます。コミットメントを減らすことができるのは、更新時のみです。

段階的割引が組み込まれたクレジットのコミットメントを購入できます。このコミットメントは、契約期間の開始時に前払いで請求されます。

クレジットは購入後すぐに利用可能になり、毎月1日にリセットされます。未使用のクレジットが翌月にロールオーバーされることはありません。

## オンデマンドクレジット {#on-demand-credits}

オンデマンドクレジットは、含まれるすべてのクレジットと月次コミットメントプールのクレジットを使用した後に発生した使用量をカバーします。オンデマンドクレジットは毎月請求されます。

オンデマンドクレジットは、使用量請求条件に同意した後に使用できます。これらの条件は、月次コミットメントを購入するとき、またはGitLabクレジットダッシュボードで直接同意できます。

使用量請求条件に同意していない場合、GitLab Duo Agent Platformを使用したり、オンデマンドクレジットを消費したりすることはできません。月次コミットメントを購入するか、使用量請求条件に同意することで、GitLab Duo Agent Platformへのアクセスを回復できます。

たとえば、サブスクリプションの月次コミットメントが月あたり50クレジットであるとします。その月に75クレジットが使用された場合、最初の50クレジットは月次コミットメントプールの一部であり、追加の25はオンデマンド使用量として請求されます。

## 使用順序 {#usage-order}

GitLabクレジットは、次の順序で使用されます:

1. 含まれるクレジットは、最初に各ユーザーが使用します。
1. すべての含まれるクレジットが消費された後、クレジットの月次コミットメントプールが使用されます。
1. オンデマンドクレジットは、利用可能な他のすべてのクレジット（含まれるクレジットおよび月次コミットメントプール（該当する場合））が枯渇し、使用量請求条件が署名された後に使用されます。

## GitLabクレジットを購入 {#buy-gitlab-credits}

GitLabクレジットを購入するには、[セールスチームにお問い合わせください](https://about.gitlab.com/sales/)。

GitLabクレジットは、カスタマーポータルのサブスクリプションカードと、GitLabクレジットダッシュボードに表示されます。

## クレジット乗数 {#credit-multipliers}

クレジットの使用量は、使用する機能とモデルに基づいて計算されます。一部の機能には、選択できるモデルオプションが複数ありますが、モデルを1つしか使用しない機能もあります。

### モデル {#models}

次の表に、さまざまなモデルに対して1つのGitLabクレジットで実行できるリクエストの数を示します。新しい、より複雑なモデルは、より高い乗数を持ち、より多くのクレジットを必要とします。

基本的なインテグレーションを備えた補助モデルの場合:

| モデル | 1つのクレジットでのリクエスト |
|-------|------------------------|
| gpt-5-mini | 8.0 |
| gemini-2.5-flash | 8.0 |
| codestral-2501 | 8.0 |
| claude-3-haiku | 8.0 |
| gemini-2.0-flash-lite | 8.0 |

最適化されたインテグレーションを備えたプレミアムモデルの場合:

| モデル | 1つのクレジットでのリクエスト |
|-------|------------------------|
| claude-4.5-haiku（デフォルトAgentic Chatモデル） | 6.7 |
| gpt-5-codex | 3.3|
| gpt-5 | 3.3 |
| gpt-5.2 | 2.5 |
| claude-3.7-sonnet | 2.0 |
| claude-3.5-sonnet | 2.0 |
| claude-sonnet-4 <=200kトークン（デフォルトモデル） | 2.0 |
| claude-sonnet-4 >200kトークン | 1.1 |
| claude-sonnet-4.5 <=200kトークン | 2.0 |
| claude-sonnet-4.5 >200kトークン | 1.1 |

### 機能 {#features}

次の表に、固定モデルを使用する機能に対して1つのGitLabクレジットで実行できるリクエストの数を示します。一般に利用可能な機能に対して課金されます。

| 機能 | 1つのクレジットでのリクエスト |
|---------|---------------------------|
| [GitLab Duoコード提案](../user/project/repository/code_suggestions/_index.md) | 50 |
| [GitLab Duo Chat（エージェント）](../user/gitlab_duo_chat/agentic_chat.md) | 6.7 <sup>1</sup> |

**脚注**: 

1. デフォルトモデル（claude-4.5-haiku）でのリクエストの場合。クレジットのコストは、リクエストに選択されたモデルによって異なります。

## GitLabクレジットダッシュボード {#gitlab-credits-dashboard}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed

{{< /details >}}

{{< history >}}

- GitLab 18.7で導入。

{{< /history >}}

GitLabクレジットダッシュボードには、GitLabクレジットの使用状況に関する情報が表示されます。ダッシュボードを使用して、クレジットの消費を追跡し、傾向を追跡し、使用パターンを特定します。

ダッシュボードでは、使用済みクレジットは利用可能なクレジットからの差し引きを表します。超過（オンデマンドクレジット）の場合、使用済みクレジットは、使用量請求条件に同意した場合、後で支払われるオンデマンド使用量を表します。

クレジットの消費を管理するために、GitLabは次の情報を管理者とサブスクリプションオーナーにメールで送信します:

- 毎月のクレジット使用状況の概要
- クレジット使用量が50％、80％、100％のしきい値に達した場合の通知 

ダッシュボードには、カスタマーポータルとGitLabからアクセスできます。

{{< alert type="note" >}}

使用状況データはリアルタイムで表示されません。データはダッシュボードに定期的に同期されるため、使用状況データは実際の消費から数時間以内に表示されるはずです。これは、ダッシュボードに最近の使用状況が表示されることを意味しますが、過去数時間に行われたアクションが反映されない場合があります。

{{< /alert >}}

### カスタマーポータル内 {#in-customers-portal}

カスタマーポータルのGitLabクレジットダッシュボードは、使用状況とコストの最も詳細なビューを提供します。

ダッシュボードには、主要なメトリクスの概要カードが表示されます:

- 当月の使用量: 当月中に使用されたGitLabクレジットの合計（月次コミットメントがある場合）
- 含まれるクレジット: サブスクリプションに含まれるクレジットの合計（月次コミットメントがある場合）
- コミットメントされたクレジット: 月次コミットメントプールからのクレジット（該当する場合）
- 月次ウェイバー: ウェイバーからの残りのクレジット（該当する場合）
- オンデマンド使用量: 含まれる金額とコミットメントされた金額を超えて消費されたクレジット。すべてのオンデマンドクレジットを相殺するのに十分なウェイバークレジットがある場合、GitLabクレジットダッシュボードは**On-Demand**カードを非表示にし、代わりに**Monthly Waiver**カードを表示します。

### GitLab内 {#in-gitlab}

GitLabのGitLabクレジットダッシュボードは、組織内のクレジットの使用状況を運用的に可視化します。ダッシュボードを使用して、どのユーザー、グループ、またはプロジェクトが使用量を推進しているかを理解し、リソース割り当てについて十分な情報に基づいた意思決定を行います。

ダッシュボードには、次の情報が表示されます:

- 組織の使用状況: GitLabインスタンスまたはグループ全体のクレジットの総使用量
- ユーザー別の詳細なクレジット使用状況: 各ユーザーが使用したクレジットの数

### GitLabクレジットダッシュボードを表示 {#view-the-gitlab-credits-dashboard}

{{< tabs >}}

{{< tab title="カスタマーポータル" >}}

前提条件: 

- 詳細な使用状況情報を表示するには、請求アカウントマネージャーである必要があります。

1. [カスタマーポータル](https://customers.gitlab.com/)にサインインします。
1. サブスクリプションカードで、**GitLabクレジットダッシュボード**を選択します。

{{< /tab >}}

{{< tab title="GitLab.com" >}}

前提条件: 

- グループのオーナーロールが必要です。

1. 左側のサイドバーで、**検索または移動先**を選択して、トップレベルグループを見つけます。
1. 左側のサイドバーで、**設定**>**使用状況**を選択します。

{{< /tab >}}

{{< tab title="GitLab Self-Managed" >}}

前提条件: 

- 管理者である必要があります。
- お使いのインスタンスは、サブスクリプションデータをGitLabと同期できる必要があります。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. 左側のサイドバーの下部にある**モニタリング**>**使用状況**を選択します。

{{< /tab >}}

{{< /tabs >}}
