/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.rich;

import ghidra.app.util.bin.format.pe.rich.MSProductType;
import ghidra.app.util.bin.format.pe.rich.RichHeaderUtils;
import ghidra.app.util.bin.format.pe.rich.RichProduct;

public class CompId {
    private final int id;
    private final int productId;
    private final int buildNumber;

    public CompId(int id) {
        this.id = id;
        this.productId = id >> 16;
        this.buildNumber = id & 0xFFFF;
    }

    public int getValue() {
        return this.id;
    }

    public int getProductId() {
        return this.productId;
    }

    public String getProductDescription() {
        MSProductType prodType;
        RichProduct prod = RichHeaderUtils.getProduct(this.getProductId());
        StringBuilder sb = new StringBuilder();
        String prodVersion = prod == null ? "Unknown Product (" + Integer.toHexString(this.getProductId()) + ")" : prod.getProductVersion();
        MSProductType mSProductType = prodType = prod == null ? MSProductType.Unknown : prod.getProductType();
        if (prodType != MSProductType.Unknown) {
            sb.append((Object)prodType).append(" from ").append(prodVersion);
        } else {
            sb.append(prodVersion);
        }
        return sb.toString();
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public String toString() {
        return this.getProductDescription() + ", build " + this.getBuildNumber();
    }
}

