/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.sourcefilestable;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.DialogComponentProvider;
import docking.action.builder.ActionBuilder;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.values.GValuesMap;
import docking.widgets.values.ValuesMapDialog;
import generic.theme.GIcon;
import ghidra.app.plugin.core.sourcefilestable.SourceFileRowObject;
import ghidra.app.plugin.core.sourcefilestable.SourceFilesTableModel;
import ghidra.app.plugin.core.sourcefilestable.SourceFilesTablePlugin;
import ghidra.app.plugin.core.sourcefilestable.SourceMapEntryRowObject;
import ghidra.app.plugin.core.sourcefilestable.SourceMapEntryTableModel;
import ghidra.app.plugin.core.sourcefilestable.TransformerTableModel;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.util.SearchConstants;
import ghidra.app.util.query.TableService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.database.sourcemap.SourceFile;
import ghidra.program.database.sourcemap.UserDataPathTransformer;
import ghidra.program.model.listing.Program;
import ghidra.program.model.sourcemap.SourcePathTransformRecord;
import ghidra.program.model.sourcemap.SourcePathTransformer;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.util.HelpLocation;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.table.GhidraFilterTable;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.function.IntSupplier;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import resources.Icons;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class SourceFilesTableProvider
extends ComponentProviderAdapter {
    private JSplitPane splitPane;
    private SourceFilesTablePlugin sourceFilesTablePlugin;
    private SourceFilesTableModel sourceFilesTableModel;
    private GhidraFilterTable<SourceFileRowObject> sourceFilesTable;
    private TransformerTableModel transformsModel;
    private GhidraFilterTable<SourcePathTransformRecord> transformsTable;
    private boolean isStale;
    private static final String DESTINATION = "Dest";
    private static final String SOURCE = "Src";

    public SourceFilesTableProvider(SourceFilesTablePlugin sourceFilesPlugin) {
        super(sourceFilesPlugin.getTool(), "Source Files and Transforms", sourceFilesPlugin.getName());
        this.sourceFilesTablePlugin = sourceFilesPlugin;
        this.tool.addComponentProvider((ComponentProvider)this, false);
        this.buildMainPanel();
        this.createActions();
        this.setHelpLocation(new HelpLocation(this.sourceFilesTablePlugin.getName(), "Source_Files_Table_Plugin"));
        this.setIsStale(false);
    }

    public JComponent getComponent() {
        return this.splitPane;
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (event != null) {
            return this.getActionContext(event.getSource());
        }
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return this.getActionContext(kfm.getFocusOwner());
    }

    public void componentShown() {
        this.reloadModels(this.sourceFilesTablePlugin.getCurrentProgram());
    }

    public void componentHidden() {
        this.reloadModels(null);
    }

    void programActivated(Program program) {
        if (this.isVisible()) {
            this.reloadModels(program);
        }
    }

    void clearTableModels() {
        this.reloadModels(null);
    }

    void setIsStale(boolean b) {
        this.isStale = b;
        this.contextChanged();
    }

    /*
     * Exception decompiling
     */
    void handleProgramChange(ProgramChangeRecord rec) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=26,807
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void reloadModels(Program program) {
        this.sourceFilesTableModel.reloadProgram(program);
        this.transformsModel.reloadProgram(program);
        this.setIsStale(false);
    }

    private ActionContext getActionContext(Object source) {
        if (source == this.sourceFilesTable.getTable()) {
            return new SourceFilesTableActionContext();
        }
        if (source == this.transformsTable.getTable()) {
            return new TransformTableActionContext();
        }
        return null;
    }

    private void buildMainPanel() {
        this.sourceFilesTableModel = new SourceFilesTableModel(this.sourceFilesTablePlugin);
        this.sourceFilesTable = new GhidraFilterTable(this.sourceFilesTableModel);
        this.sourceFilesTable.setAccessibleNamePrefix("Source Files");
        JPanel sourceFilesPanel = this.buildTitledTablePanel("Source Files", this.sourceFilesTable, () -> this.sourceFilesTableModel.getUnfilteredRowCount());
        this.transformsModel = new TransformerTableModel(this.sourceFilesTablePlugin);
        this.transformsTable = new GhidraFilterTable(this.transformsModel);
        this.transformsTable.setAccessibleNamePrefix("Transformations");
        JPanel transformsPanel = this.buildTitledTablePanel("Transforms", this.transformsTable, () -> this.transformsModel.getUnfilteredRowCount());
        this.splitPane = new JSplitPane(0);
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setDividerSize(10);
        this.splitPane.setLeftComponent(sourceFilesPanel);
        this.splitPane.setRightComponent(transformsPanel);
        this.splitPane.setPreferredSize(new Dimension(1000, 800));
    }

    private JPanel buildTitledTablePanel(String title, GhidraFilterTable<?> table, IntSupplier nonFilteredRowCount) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 2, 10, 2));
        JLabel titleLabel = new JLabel(title);
        panel.add((Component)titleLabel, "North");
        panel.add((Component)((Object)table), "Center");
        RowObjectTableModel model = table.getModel();
        model.addTableModelListener(e -> {
            int rowCount = model.getRowCount();
            String text = title + "  - " + rowCount + " rows";
            int nonFilteredSize = nonFilteredRowCount.getAsInt();
            if (nonFilteredSize != rowCount) {
                text = text + "   (Filtered from " + nonFilteredSize + " rows)";
            }
            titleLabel.setText(text);
        });
        return panel;
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Show Source Map Entries", this.getName()).popupMenuPath(new String[]{"Show Source Map Entries"})).description("Show a table of the source map entries associated with a SourceFile")).helpLocation(new HelpLocation(this.sourceFilesTablePlugin.getName(), "Show_Source_Map_Entries"))).withContext(SourceFilesTableActionContext.class).enabledWhen(c -> c.getSelectedRowCount() == 1).onAction(this::showSourceMapEntries).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("View Source File", this.getName()).popupMenuPath(new String[]{"View Source File"})).description("View the Source File")).helpLocation(new HelpLocation(this.sourceFilesTablePlugin.getName(), "View_Source_File"))).withContext(SourceFilesTableActionContext.class).enabledWhen(c -> c.getSelectedRowCount() == 1).onAction(this::viewSourceFile).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Transform File", this.getName()).popupMenuPath(new String[]{"Tranform File"})).description("Enter a file transform for a SourceFile")).helpLocation(new HelpLocation(this.sourceFilesTablePlugin.getName(), "Transform_File"))).withContext(SourceFilesTableActionContext.class).enabledWhen(c -> c.getSelectedRowCount() == 1).onAction(this::transformSourceFileAction).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Transform Directory", this.getName()).popupMenuPath(new String[]{"Transform Directory"})).description("Add a directory transform based on this file's path")).helpLocation(new HelpLocation(this.sourceFilesTablePlugin.getName(), "Transform_Directory"))).withContext(SourceFilesTableActionContext.class).enabledWhen(c -> c.getSelectedRowCount() == 1).onAction(this::transformPath).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Remove Transform", this.getName()).popupMenuPath(new String[]{"Remove Transform"})).description("Remove a transform")).helpLocation(new HelpLocation(this.sourceFilesTablePlugin.getName(), "Remove_Transform"))).withContext(TransformTableActionContext.class).enabledWhen(c -> c.getSelectedRowCount() == 1).onAction(this::removeTransform).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Edit Transform", this.getName()).popupMenuPath(new String[]{"Edit Transform"})).description("Edit the transform")).helpLocation(new HelpLocation(this.sourceFilesTablePlugin.getName(), "Edit_Transform"))).withContext(TransformTableActionContext.class).onAction(c -> this.editTransform()).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Reload Source File Table", this.getName()).toolBarIcon(Icons.REFRESH_ICON)).description("Reloads the Source File Table")).helpLocation(new HelpLocation(this.sourceFilesTablePlugin.getName(), "Reload_Source_Files_Model"))).enabledWhen(c -> this.isStale)).onAction(c -> this.reloadModels(this.sourceFilesTablePlugin.getCurrentProgram()))).buildAndInstallLocal((ComponentProvider)this);
    }

    private void removeTransform(TransformTableActionContext actionContext) {
        SourcePathTransformRecord rowObject = (SourcePathTransformRecord)this.transformsTable.getSelectedRowObject();
        SourcePathTransformer pathTransformer = UserDataPathTransformer.getPathTransformer((Program)this.transformsModel.getProgram());
        String source = rowObject.source();
        if (rowObject.isDirectoryTransform()) {
            pathTransformer.removeDirectoryTransform(source);
        } else {
            pathTransformer.removeFileTransform(rowObject.sourceFile());
        }
        this.transformsModel.reload();
        this.sourceFilesTableModel.refresh();
    }

    private void editTransform() {
        SourcePathTransformRecord transformRecord = (SourcePathTransformRecord)this.transformsTable.getSelectedRowObject();
        if (transformRecord.isDirectoryTransform()) {
            this.editDirectoryTransform(transformRecord);
        } else {
            SourceFile sourceFile = transformRecord.sourceFile();
            this.transformSourceFile(sourceFile);
        }
    }

    private void editDirectoryTransform(SourcePathTransformRecord transformRecord) {
        SourcePathTransformer pathTransformer = UserDataPathTransformer.getPathTransformer((Program)this.sourceFilesTableModel.getProgram());
        String source = transformRecord.source();
        GValuesMap valueMap = new GValuesMap();
        valueMap.defineDirectory(DESTINATION, new File(transformRecord.target()));
        valueMap.setValidator((map, status) -> {
            File directory = valueMap.getFile(DESTINATION);
            if (directory == null || !directory.exists()) {
                status.setStatusText("Directory does not exist", MessageType.ERROR);
                return false;
            }
            if (!directory.isDirectory()) {
                status.setStatusText("Must select a directory", MessageType.ERROR);
                return false;
            }
            return true;
        });
        ValuesMapDialog mapDialog = new ValuesMapDialog("Enter Directory Transform", "Transform for " + source, valueMap);
        this.tool.showDialog((DialogComponentProvider)mapDialog, (ComponentProvider)this);
        GValuesMap results = mapDialog.getValues();
        if (results == null) {
            return;
        }
        try {
            String canonical = results.getFile(DESTINATION).getCanonicalPath();
            URI uri = new File(canonical).toURI().normalize();
            Object transformedPath = uri.getPath();
            if (!((String)transformedPath).endsWith("/")) {
                transformedPath = (String)transformedPath + "/";
            }
            pathTransformer.addDirectoryTransform(source, (String)transformedPath);
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), this.sourceFilesTable, (String)"IOException getting canonical path", (Object)e.getMessage());
        }
        this.sourceFilesTableModel.refresh();
        this.transformsModel.reload();
    }

    private void transformPath(SourceFilesTableActionContext actionContext) {
        SourceFile sourceFile = ((SourceFileRowObject)this.sourceFilesTable.getSelectedRowObject()).getSourceFile();
        String path = sourceFile.getPath();
        GValuesMap valueMap = new GValuesMap();
        ArrayList<Object> parentDirs = new ArrayList<Object>();
        String[] directories = path.split("/");
        parentDirs.add("/");
        for (int i = 1; i < directories.length - 1; ++i) {
            String latest = (String)parentDirs.get(i - 1);
            parentDirs.add(latest + directories[i] + "/");
        }
        valueMap.defineChoice(SOURCE, (String)parentDirs.getLast(), parentDirs.toArray(new String[0]));
        valueMap.defineDirectory(DESTINATION, null);
        valueMap.setValidator((map, status) -> {
            File directory = valueMap.getFile(DESTINATION);
            if (directory == null || !directory.exists()) {
                status.setStatusText("Directory does not exist", MessageType.ERROR);
                return false;
            }
            if (!directory.isDirectory()) {
                status.setStatusText("Must select a directory", MessageType.ERROR);
                return false;
            }
            return true;
        });
        ValuesMapDialog mapDialog = new ValuesMapDialog("Enter Directory Transform", null, valueMap);
        this.tool.showDialog((DialogComponentProvider)mapDialog, (ComponentProvider)this);
        GValuesMap results = mapDialog.getValues();
        if (results == null) {
            return;
        }
        SourcePathTransformer pathTransformer = UserDataPathTransformer.getPathTransformer((Program)this.sourceFilesTableModel.getProgram());
        String source = results.getChoice(SOURCE);
        try {
            String canonical = results.getFile(DESTINATION).getCanonicalPath();
            URI uri = new File(canonical).toURI().normalize();
            Object transformedPath = uri.getPath();
            if (!((String)transformedPath).endsWith("/")) {
                transformedPath = (String)transformedPath + "/";
            }
            pathTransformer.addDirectoryTransform(source, (String)transformedPath);
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), this.sourceFilesTable, (String)"IOException getting canonical path", (Object)e.getMessage());
        }
        this.sourceFilesTableModel.refresh();
        this.transformsModel.reload();
    }

    private void transformSourceFileAction(SourceFilesTableActionContext actionContext) {
        SourceFile sourceFile = ((SourceFileRowObject)this.sourceFilesTable.getSelectedRowObject()).getSourceFile();
        this.transformSourceFile(sourceFile);
    }

    private void transformSourceFile(SourceFile sourceFile) {
        SourcePathTransformer pathTransformer = UserDataPathTransformer.getPathTransformer((Program)this.sourceFilesTableModel.getProgram());
        String existing = pathTransformer.getTransformedPath(sourceFile, true);
        GValuesMap valueMap = new GValuesMap();
        valueMap.defineFile(DESTINATION, new File(existing));
        valueMap.setValidator((map, status) -> {
            File targetFile = valueMap.getFile(DESTINATION);
            if (targetFile == null || !targetFile.exists()) {
                status.setStatusText("File does not exist", MessageType.ERROR);
                return false;
            }
            if (targetFile.isDirectory()) {
                status.setStatusText("Must specify a file", MessageType.ERROR);
                return false;
            }
            return true;
        });
        ValuesMapDialog mapDialog = new ValuesMapDialog("Enter File Tranform", "Transform for " + sourceFile.toString(), valueMap);
        this.tool.showDialog((DialogComponentProvider)mapDialog, (ComponentProvider)this);
        GValuesMap results = mapDialog.getValues();
        if (results == null) {
            return;
        }
        try {
            String path = results.getFile(DESTINATION).getCanonicalPath();
            URI uri = new File(path).toURI().normalize();
            pathTransformer.addFileTransform(sourceFile, uri.getPath());
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), this.sourceFilesTable, (String)"IOException getting canonical path", (Object)e.getMessage());
        }
        this.sourceFilesTableModel.refresh();
        this.transformsModel.reload();
    }

    private void showSourceMapEntries(SourceFilesTableActionContext actionContext) {
        TableService tableService = (TableService)this.sourceFilesTablePlugin.getTool().getService(TableService.class);
        if (tableService == null) {
            Msg.showWarn((Object)((Object)this), null, (String)"No Table Service", (Object)"Please add the TableServicePlugin.");
            return;
        }
        SourceFileRowObject sourceFileRow = (SourceFileRowObject)this.sourceFilesTable.getSelectedRowObject();
        GIcon markerIcon = new GIcon("icon.plugin.codebrowser.cursor.marker");
        SourceFile sourceFile = sourceFileRow.getSourceFile();
        String title = "Source Map Entries for " + sourceFile.getFilename();
        SourceMapEntryTableModel tableModel = new SourceMapEntryTableModel((ServiceProvider)this.sourceFilesTablePlugin.getTool(), this.sourceFilesTablePlugin.getCurrentProgram(), TaskMonitor.DUMMY, sourceFile);
        TableComponentProvider<SourceMapEntryRowObject> provider = tableService.showTableWithMarkers(title, "SourceMapEntries", tableModel, (Color)SearchConstants.SEARCH_HIGHLIGHT_COLOR, (Icon)markerIcon, title, null);
        provider.setTabText(sourceFile.getFilename());
        provider.setHelpLocation(new HelpLocation(this.sourceFilesTablePlugin.getName(), "Show_Source_Map_Entries"));
    }

    private void viewSourceFile(SourceFilesTableActionContext actionContext) {
        TableService tableService = (TableService)this.sourceFilesTablePlugin.getTool().getService(TableService.class);
        if (tableService == null) {
            Msg.showWarn((Object)((Object)this), null, (String)"No Table Service", (Object)"Please add the TableServicePlugin.");
            return;
        }
        SourceFileRowObject sourceFileRow = (SourceFileRowObject)this.sourceFilesTable.getSelectedRowObject();
        SourceFile sourceFile = sourceFileRow.getSourceFile();
        this.sourceFilesTablePlugin.openInViewer(sourceFile, 1);
    }

    private class SourceFilesTableActionContext
    extends DefaultActionContext {
        SourceFilesTableActionContext() {
            super((ComponentProvider)SourceFilesTableProvider.this);
        }

        public int getSelectedRowCount() {
            return SourceFilesTableProvider.this.sourceFilesTable.getTable().getSelectedRowCount();
        }
    }

    private class TransformTableActionContext
    extends DefaultActionContext {
        TransformTableActionContext() {
            super((ComponentProvider)SourceFilesTableProvider.this);
        }

        public int getSelectedRowCount() {
            return SourceFilesTableProvider.this.transformsTable.getTable().getSelectedRowCount();
        }
    }
}

