/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.overview.entropy;

import ghidra.app.plugin.core.overview.entropy.EntropyRecord;

public enum EntropyKnot {
    NONE("None", null),
    X86("x86 code", new EntropyRecord("x86", 5.94, 0.4)),
    ARM("ARM code", new EntropyRecord("arm", 5.1252, 0.51)),
    THUMB("THUMB code", new EntropyRecord("thumb", 6.2953, 0.5)),
    POWER_PC("PowerPC code", new EntropyRecord("powerpc", 5.6674, 0.52)),
    ASCII("ASCII strings", new EntropyRecord("ascii", 4.7, 0.5)),
    COMPRESSED("Compressed", new EntropyRecord("compressed", 8.0, 0.5)),
    UTF16("Unicode UTF16", new EntropyRecord("utf16", 3.21, 0.2));

    private String label;
    private EntropyRecord record;

    private EntropyKnot(String label, EntropyRecord rec) {
        this.label = label;
        this.record = rec;
    }

    public String toString() {
        return this.label;
    }

    public EntropyRecord getRecord() {
        return this.record;
    }
}

