/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.tracermi;

import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.debug.api.tracermi.TraceRmiConnection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.util.Swing;

public abstract class AbstractTraceRmiConnection
implements TraceRmiConnection {
    protected abstract DebuggerTraceManagerService getTraceManager();

    protected abstract DebuggerControlService getControlService();

    protected abstract boolean ownsTrace(Trace var1);

    protected boolean followsPresent(Trace trace) {
        DebuggerControlService controlService = this.getControlService();
        if (controlService == null) {
            return true;
        }
        return controlService.getCurrentMode(trace).followsPresent();
    }

    protected void doActivate(TraceObject object, Trace trace, TraceSnapshot snapshot) {
        DebuggerCoordinates coords = this.getTraceManager().getCurrent();
        if (coords.getTrace() != trace) {
            coords = DebuggerCoordinates.NOWHERE.trace(trace);
        }
        if (snapshot != null && this.followsPresent(trace)) {
            coords = snapshot.getKey() > 0L || snapshot.getSchedule() == null ? coords.snap(snapshot.getKey()) : coords.time(snapshot.getSchedule());
        }
        DebuggerCoordinates finalCoords = object == null ? coords : coords.object(object);
        Swing.runLater(() -> {
            DebuggerTraceManagerService traceManager = this.getTraceManager();
            if (traceManager == null) {
                return;
            }
            if (!traceManager.getOpenTraces().contains(trace)) {
                traceManager.openTrace(trace);
                traceManager.activate(finalCoords, DebuggerTraceManagerService.ActivationCause.SYNC_MODEL);
                return;
            }
            Trace currentTrace = traceManager.getCurrentTrace();
            if (currentTrace == null || this.ownsTrace(currentTrace)) {
                traceManager.activate(finalCoords, DebuggerTraceManagerService.ActivationCause.SYNC_MODEL);
                return;
            }
            traceManager.activate(finalCoords, DebuggerTraceManagerService.ActivationCause.SYNC_MODEL);
        });
    }
}

