/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.address;

import ghidra.pcodeCPort.address.Address;
import ghidra.pcodeCPort.address.AddressUtils;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.translate.Translate;
import java.io.PrintStream;

public class Range
implements Comparable<Range> {
    private AddrSpace spc;
    private long first;
    private long last;

    public Range(AddrSpace s, long f, long l) {
        this.spc = s;
        this.first = f;
        this.last = l;
    }

    public Range() {
    }

    public AddrSpace getSpace() {
        return this.spc;
    }

    public long getFirst() {
        return this.first;
    }

    public long getLast() {
        return this.last;
    }

    public Address getFirstAddr() {
        return new Address(this.spc, this.first);
    }

    public Address getLastAddr() {
        return new Address(this.spc, this.last);
    }

    @Override
    public int compareTo(Range other) {
        int result = this.spc.compareTo(other.spc);
        if (result != 0) {
            return result;
        }
        return AddressUtils.unsignedCompare(this.first, other.first);
    }

    void printBounds(PrintStream s) {
        s.append(this.spc.getName());
        s.append(": ");
        s.append(Long.toHexString(this.first));
        s.append('-');
        s.append(Long.toHexString(this.last));
    }

    public Address getLastAddrOpen(Translate trans) {
        long curlast = this.last;
        AddrSpace curspc = this.spc;
        if (curlast == curspc.getMask()) {
            curspc = trans.getNextSpaceInOrder(curspc);
            curlast = 0L;
        } else {
            ++curlast;
        }
        if (curspc == null) {
            return new Address(Address.mach_extreme.m_maximal);
        }
        return new Address(curspc, curlast);
    }
}

