/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassFieldMsAttributes;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsTypeField;
import java.math.BigInteger;

public abstract class AbstractBaseClassMsType
extends AbstractMsType
implements MsTypeField {
    protected RecordNumber baseClassRecordNumber;
    protected ClassFieldMsAttributes attribute;
    protected BigInteger offset;

    public AbstractBaseClassMsType(AbstractPdb pdb, PdbByteReader reader) {
        super(pdb, reader);
    }

    public AbstractBaseClassMsType(AbstractPdb pdb, RecordNumber baseClassRecordNumber, long offset, ClassFieldMsAttributes attribute) throws PdbException {
        super(pdb, null);
        this.baseClassRecordNumber = baseClassRecordNumber;
        this.offset = BigInteger.valueOf(offset);
        this.attribute = attribute;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        this.attribute.emit(builder);
        builder.append(":");
        builder.append(this.pdb.getTypeRecord(this.baseClassRecordNumber));
        builder.append("<@");
        builder.append(this.offset);
        builder.append(">");
    }

    public BigInteger getOffset() {
        return this.offset;
    }

    public ClassFieldMsAttributes getAttributes() {
        return this.attribute;
    }

    public RecordNumber getBaseClassRecordNumber() {
        return this.baseClassRecordNumber;
    }
}

