/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control.dnd;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.jungrapht.visualization.LayeredIcon;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.util.PointUtils;

public class VertexImageDropTargetListener<V, E>
extends DropTargetAdapter {
    private DropTarget dropTarget;
    private VisualizationViewer<V, E> viewer;
    private BiConsumer<V, Icon> iconConsumer;

    public VertexImageDropTargetListener(VisualizationViewer<V, E> viewer, BiConsumer<V, Icon> iconConsumer) {
        this.viewer = viewer;
        this.iconConsumer = iconConsumer;
        this.dropTarget = new DropTarget(viewer.getComponent(), 1, this, true, null);
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        try {
            DropTarget dropTarget = (DropTarget)event.getSource();
            Component component = dropTarget.getComponent();
            java.awt.Point dropPoint = component.getMousePosition();
            Point layoutDropPoint = PointUtils.convert(this.viewer.getRenderContext().getMultiLayerTransformer().inverseTransform(dropPoint));
            Transferable transferable = event.getTransferable();
            if (event.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                Image image = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
                LayeredIcon icon = new LayeredIcon(image);
                if (icon != null) {
                    Object vertex = this.viewer.getVisualizationModel().getGraph().addVertex();
                    this.viewer.getVertexSpatial().recalculate();
                    this.iconConsumer.accept(vertex, icon);
                    this.viewer.getVisualizationModel().getLayoutModel().set(vertex, layoutDropPoint);
                    event.dropComplete(true);
                }
            } else {
                event.rejectDrop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            event.rejectDrop();
        }
    }
}

