/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.annotations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.annotations.Annotation;
import org.jungrapht.visualization.annotations.AnnotationRenderer;
import org.jungrapht.visualization.transform.AffineTransformer;
import org.jungrapht.visualization.transform.LensTransformer;
import org.jungrapht.visualization.transform.MutableTransformer;

public class AnnotationPaintable
implements VisualizationServer.Paintable {
    protected Set<Annotation> annotations = new HashSet<Annotation>();
    protected AnnotationRenderer annotationRenderer;
    protected RenderContext<?, ?> rc;
    protected AffineTransformer layoutTransformer;

    public AnnotationPaintable(RenderContext<?, ?> rc, AnnotationRenderer annotationRenderer) {
        this.rc = rc;
        this.annotationRenderer = annotationRenderer;
        MutableTransformer mt = rc.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
        if (mt instanceof AffineTransformer) {
            this.layoutTransformer = (AffineTransformer)((Object)mt);
        } else if (mt instanceof LensTransformer) {
            this.layoutTransformer = (AffineTransformer)((Object)((LensTransformer)mt).getDelegate());
        }
    }

    public void add(Annotation<?> annotation) {
        this.annotations.add(annotation);
    }

    public void remove(Annotation<?> annotation) {
        this.annotations.remove(annotation);
    }

    public Set<Annotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Color oldColor = g.getColor();
        for (Annotation annotation : this.annotations) {
            Object ann = annotation.getAnnotation();
            if (ann instanceof Shape) {
                Shape shape = (Shape)ann;
                Paint paint = annotation.getPaint();
                Shape s = this.layoutTransformer.transform(shape);
                g2d.setPaint(paint);
                if (annotation.isFill()) {
                    g2d.fill(s);
                    continue;
                }
                g2d.draw(s);
                continue;
            }
            if (!(ann instanceof String)) continue;
            Point2D p = annotation.getLocation();
            String label = (String)ann;
            Component component = this.prepareRenderer(this.rc, this.annotationRenderer, label);
            component.setForeground((Color)annotation.getPaint());
            if (annotation.isFill()) {
                ((JComponent)component).setOpaque(true);
                component.setBackground((Color)annotation.getPaint());
                component.setForeground(Color.black);
            }
            Dimension d = component.getPreferredSize();
            AffineTransform old = g2d.getTransform();
            AffineTransform base = new AffineTransform(old);
            AffineTransform xform = this.layoutTransformer.getTransform();
            double rotation = this.layoutTransformer.getRotation();
            AffineTransform unrotate = AffineTransform.getRotateInstance(-rotation, p.getX(), p.getY());
            base.concatenate(xform);
            base.concatenate(unrotate);
            g2d.setTransform(base);
            this.rc.getRendererPane().paintComponent(g, component, this.rc.getScreenDevice(), (int)p.getX(), (int)p.getY(), d.width, d.height, true);
            g2d.setTransform(old);
        }
        g.setColor(oldColor);
    }

    public Component prepareRenderer(RenderContext<?, ?> rc, AnnotationRenderer annotationRenderer, Object value) {
        return annotationRenderer.getAnnotationRendererComponent(rc.getScreenDevice(), value);
    }

    @Override
    public boolean useTransform() {
        return true;
    }
}

