/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.local;

import ghidra.framework.store.FolderItem;
import ghidra.framework.store.TextDataItem;
import ghidra.framework.store.Version;
import ghidra.framework.store.local.ItemPropertyFile;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.framework.store.local.LocalFolderItem;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class LocalTextDataItem
extends LocalFolderItem
implements TextDataItem {
    private static final String TEXT_PROPERTY = "TEXT";
    private static final String VERSION_CREATE_USER = "CREATE_USER";
    private static final String VERSION_CREATE_TIME = "CREATE_TIME";
    private static final String VERSION_CREATE_COMMENT = "CREATE_COMMENT";

    public LocalTextDataItem(LocalFileSystem fileSystem, ItemPropertyFile propertyFile) throws IOException {
        super(fileSystem, propertyFile, false, false);
    }

    public LocalTextDataItem(LocalFileSystem fileSystem, ItemPropertyFile propertyFile, String fileID, String contentType, String textData) throws IOException {
        super(fileSystem, propertyFile, false, true);
        if (StringUtils.isBlank((CharSequence)contentType)) {
            this.abortCreate();
            throw new IllegalArgumentException("Missing content-type");
        }
        if (StringUtils.isBlank((CharSequence)textData)) {
            this.abortCreate();
            throw new IllegalArgumentException("Missing text data");
        }
        propertyFile.putInt("FILE_TYPE", 2);
        propertyFile.putBoolean("READ_ONLY", false);
        propertyFile.putString("CONTENT_TYPE", contentType);
        if (fileID != null) {
            propertyFile.setFileID(fileID);
        }
        propertyFile.putString(TEXT_PROPERTY, textData);
        propertyFile.writeState();
    }

    @Override
    public String getTextData() {
        return this.propertyFile.getString(TEXT_PROPERTY, null);
    }

    @Override
    public long length() throws IOException {
        return 0L;
    }

    @Override
    public void updateCheckout(FolderItem versionedFolderItem, boolean updateItem, TaskMonitor monitor) throws IOException {
        throw new IOException("Versioning updates not supported");
    }

    @Override
    public void updateCheckout(FolderItem item, int checkoutVersion) throws IOException {
        throw new IOException("Versioning updates not supported");
    }

    @Override
    void deleteMinimumVersion(String user) throws IOException {
        throw new UnsupportedOperationException("Versioning updates not supported");
    }

    @Override
    void deleteCurrentVersion(String user) throws IOException {
        throw new UnsupportedOperationException("Versioning updates not supported");
    }

    @Override
    public void output(File outputFile, int version, TaskMonitor monitor) throws IOException {
        throw new IOException("Output not supported");
    }

    @Override
    int getMinimumVersion() {
        return this.getCurrentVersion();
    }

    @Override
    public int getCurrentVersion() {
        return 1;
    }

    @Override
    public boolean canRecover() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersionInfo(Version version) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (!this.isVersioned()) {
                throw new UnsupportedOperationException("Versioning not supported");
            }
            this.propertyFile.putString(VERSION_CREATE_USER, version.getUser());
            this.propertyFile.putLong(VERSION_CREATE_TIME, version.getCreateTime());
            this.propertyFile.putString(VERSION_CREATE_COMMENT, version.getComment());
            this.propertyFile.writeState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Version[] getVersions() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (!this.isVersioned) {
                throw new UnsupportedOperationException("Non-versioned item does not support getVersions");
            }
            String createUser = this.propertyFile.getString(VERSION_CREATE_USER, "");
            long createTime = this.propertyFile.getLong(VERSION_CREATE_TIME, 0L);
            String comment = this.propertyFile.getString(VERSION_CREATE_COMMENT, null);
            return new Version[]{new Version(1, createTime, createUser, comment)};
        }
    }
}

