/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.breakpoint;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.menu.MultiActionDockingAction;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableColumnModel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.RowWrappedEnumeratedColumnTableModel;
import docking.widgets.table.TableFilter;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.InvokeActionEntryAction;
import ghidra.app.plugin.core.debug.gui.breakpoint.BreakpointLocationRow;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerBreakpointLocationsActionContext;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerBreakpointStateTableCellEditor;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerBreakpointStateTableCellRenderer;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerBreakpointsPlugin;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerLogicalBreakpointsActionContext;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerMakeBreakpointsEffectiveActionContext;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerSleighExpressionInputDialog;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerSleighSemanticInputDialog;
import ghidra.app.plugin.core.debug.gui.breakpoint.LogicalBreakpointRow;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerLogicalBreakpointService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.GoToService;
import ghidra.debug.api.breakpoint.LogicalBreakpoint;
import ghidra.debug.api.breakpoint.LogicalBreakpointsChangeListener;
import ghidra.debug.api.control.ControlMode;
import ghidra.debug.api.target.ActionName;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.pcode.exec.SleighUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.Program;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceUniqueObject;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceBreakpointLocation;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.database.ObjectKey;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DebuggerBreakpointsProvider
extends ComponentProviderAdapter
implements LogicalBreakpointsChangeListener,
DebuggerControlService.ControlModeChangeListener {
    private final DebuggerBreakpointsPlugin plugin;
    DebuggerLogicalBreakpointService breakpointService;
    @AutoServiceConsumed
    private DebuggerListingService listingService;
    @AutoServiceConsumed
    DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerConsoleService consoleService;
    private DebuggerControlService controlService;
    @AutoServiceConsumed
    private GoToService goToService;
    private AutoService.Wiring autoServiceWiring;
    private final Map<Trace, ForBreakpointLocationsTraceListener> listenersByTrace = new HashMap<Trace, ForBreakpointLocationsTraceListener>();
    Trace currentTrace;
    private final JSplitPane mainPanel = new JSplitPane(0);
    LogicalBreakpointTableModel breakpointTableModel = new LogicalBreakpointTableModel(this);
    GhidraTable breakpointTable;
    GhidraTableFilterPanel<LogicalBreakpointRow> breakpointFilterPanel;
    BreakpointLocationTableModel locationTableModel = new BreakpointLocationTableModel(this);
    GhidraTable locationTable;
    GhidraTableFilterPanel<BreakpointLocationRow> locationFilterPanel;
    private final LocationsBySelectedBreakpointsTableFilter filterLocationsBySelectedBreakpoints = new LocationsBySelectedBreakpointsTableFilter();
    private ActionContext myActionContext;
    private final DebuggerMakeBreakpointsEffectiveActionContext makeEffectiveResolutionContext = new DebuggerMakeBreakpointsEffectiveActionContext();
    SetBreakpointAction actionSetBreakpoint;
    EnableSelectedBreakpointsAction actionEnableSelectedBreakpoints;
    EnableAllBreakpointsAction actionEnableAllBreakpoints;
    DisableSelectedBreakpointsAction actionDisableSelectedBreakpoints;
    DisableAllBreakpointsAction actionDisableAllBreakpoints;
    ClearSelectedBreakpointsAction actionClearSelectedBreakpoints;
    ClearAllBreakpointsAction actionClearAllBreakpoints;
    MakeBreakpointsEffectiveAction actionMakeBreakpointsEffective;
    MakeBreakpointsEffectiveResolutionAction actionMakeBreakpointsEffectiveResolution;
    ToggleDockingAction actionFilterByCurrentTrace;
    ToggleDockingAction actionFilterLocationsByBreakpoints;
    DockingAction actionSetCondition;
    DockingAction actionSetInjection;
    private static final Set<TraceBreakpointKind> EXECUTE_KINDS = Set.of(TraceBreakpointKind.SW_EXECUTE, TraceBreakpointKind.HW_EXECUTE);

    protected static boolean contextHasMatchingBreakpoints(ActionContext context, Predicate<? super LogicalBreakpointRow> logicalCase, Predicate<? super BreakpointLocationRow> locationCase) {
        if (context == null) {
            return false;
        }
        if (context instanceof DebuggerLogicalBreakpointsActionContext) {
            DebuggerLogicalBreakpointsActionContext ctx = (DebuggerLogicalBreakpointsActionContext)context;
            return ctx.getSelection().stream().anyMatch(logicalCase);
        }
        if (context instanceof DebuggerBreakpointLocationsActionContext) {
            DebuggerBreakpointLocationsActionContext ctx = (DebuggerBreakpointLocationsActionContext)context;
            return ctx.getSelection().stream().anyMatch(locationCase);
        }
        return false;
    }

    protected static boolean contextIsNonEmptyBreakpoints(ActionContext context) {
        return DebuggerBreakpointsProvider.contextHasMatchingBreakpoints(context, lb -> true, loc -> true);
    }

    public DebuggerBreakpointsProvider(DebuggerBreakpointsPlugin plugin) {
        super(plugin.getTool(), "Breakpoints", plugin.getName());
        this.plugin = plugin;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.setIcon(DebuggerResources.ICON_PROVIDER_BREAKPOINTS);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_BREAKPOINTS);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.setDefaultWindowPosition(WindowPosition.RIGHT);
        this.setVisible(true);
        this.createActions();
    }

    protected void dispose() {
        if (this.consoleService != null && this.actionMakeBreakpointsEffectiveResolution != null) {
            this.consoleService.removeResolutionAction((DockingActionIf)this.actionMakeBreakpointsEffectiveResolution);
        }
    }

    public void contextChanged() {
        super.contextChanged();
        if (this.consoleService == null) {
            return;
        }
        if (this.actionMakeBreakpointsEffective != null && this.actionMakeBreakpointsEffective.isEnabledForContext(this.myActionContext)) {
            if (!this.consoleService.logContains((ActionContext)this.makeEffectiveResolutionContext)) {
                this.consoleService.log(DebuggerResources.ICON_PROVIDER_BREAKPOINTS, "There are ineffective breakpoints that can be placed", (ActionContext)this.makeEffectiveResolutionContext);
            }
        } else {
            this.consoleService.removeFromLog((ActionContext)this.makeEffectiveResolutionContext);
        }
    }

    @AutoServiceConsumed
    private void setBreakpointService(DebuggerLogicalBreakpointService breakpointService) {
        if (this.breakpointService != null) {
            this.breakpointService.removeChangeListener((LogicalBreakpointsChangeListener)this);
            this.breakpointTableModel.clear();
        }
        this.breakpointService = breakpointService;
        if (this.breakpointService != null) {
            this.breakpointService.addChangeListener((LogicalBreakpointsChangeListener)this);
            this.loadBreakpoints();
        }
        this.contextChanged();
    }

    @AutoServiceConsumed
    private void setConsoleService(DebuggerConsoleService consoleService) {
        if (consoleService != null && this.actionMakeBreakpointsEffectiveResolution != null) {
            consoleService.addResolutionAction((DockingActionIf)this.actionMakeBreakpointsEffectiveResolution);
        }
    }

    @AutoServiceConsumed
    private void setControlService(DebuggerControlService editingService) {
        if (this.controlService != null) {
            this.controlService.removeModeChangeListener((DebuggerControlService.ControlModeChangeListener)this);
        }
        this.controlService = editingService;
        if (this.controlService != null) {
            this.controlService.addModeChangeListener((DebuggerControlService.ControlModeChangeListener)this);
        }
    }

    public void modeChanged(Trace trace, ControlMode mode) {
        Swing.runIfSwingOrRunLater(() -> {
            this.reloadBreakpointLocations(trace);
            this.contextChanged();
        });
    }

    protected void loadBreakpoints() {
        Set all = this.breakpointService.getAllBreakpoints();
        this.breakpointTableModel.addAllItems(all);
    }

    public void breakpointAdded(LogicalBreakpoint lb) {
        Swing.runIfSwingOrRunLater(() -> {
            this.breakpointTableModel.addItem(lb);
            this.contextChanged();
        });
    }

    public void breakpointsAdded(Collection<LogicalBreakpoint> clb) {
        Swing.runIfSwingOrRunLater(() -> {
            this.breakpointTableModel.addAllItems(clb);
            this.contextChanged();
        });
    }

    public void breakpointUpdated(LogicalBreakpoint lb) {
        Swing.runIfSwingOrRunLater(() -> {
            this.breakpointTableModel.updateItem(lb);
            this.breakpointLocationsUpdated(lb.getTraceBreakpoints());
            this.contextChanged();
        });
    }

    public void breakpointsUpdated(Collection<LogicalBreakpoint> clb) {
        Swing.runIfSwingOrRunLater(() -> {
            this.breakpointTableModel.updateAllItems(clb);
            this.breakpointLocationsUpdated(clb.stream().flatMap(lb -> lb.getTraceBreakpoints().stream()).collect(Collectors.toSet()));
            this.contextChanged();
        });
    }

    public void breakpointRemoved(LogicalBreakpoint lb) {
        Swing.runIfSwingOrRunLater(() -> {
            this.breakpointTableModel.deleteItem(lb);
            this.contextChanged();
        });
    }

    public void breakpointsRemoved(Collection<LogicalBreakpoint> clb) {
        Swing.runIfSwingOrRunLater(() -> {
            this.breakpointTableModel.deleteAllItems(clb);
            this.contextChanged();
        });
    }

    private void loadBreakpointLocations(Trace trace) {
        ControlMode mode = this.controlService == null ? ControlMode.DEFAULT : this.controlService.getCurrentMode(trace);
        DebuggerCoordinates currentFor = this.traceManager.getCurrentFor(trace);
        Target target = currentFor.getTarget();
        if (!mode.useEmulatedBreakpoints() && target == null) {
            return;
        }
        Lifespan span = Lifespan.at((long)currentFor.getSnap());
        ArrayList<TraceBreakpointLocation> visible = new ArrayList<TraceBreakpointLocation>();
        for (AddressRange range : trace.getBaseAddressFactory().getAddressSet()) {
            Collection breaks = trace.getBreakpointManager().getBreakpointsIntersecting(span, range);
            if (mode.useEmulatedBreakpoints()) {
                visible.addAll(breaks);
                continue;
            }
            for (TraceBreakpointLocation l : breaks) {
                if (!target.isBreakpointValid(l)) continue;
                visible.add(l);
            }
        }
        this.locationTableModel.addAllItems(visible);
    }

    private void unloadBreakpointLocations(Trace trace) {
        this.locationTableModel.deleteItemsWith(l -> l.getTrace() == trace);
    }

    private void reloadBreakpointLocations(Trace trace) {
        this.unloadBreakpointLocations(trace);
        this.loadBreakpointLocations(trace);
    }

    private void breakpointLocationAdded(TraceBreakpointLocation location) {
        this.locationTableModel.addItem(location);
    }

    private void breakpointLocationUpdated(TraceBreakpointLocation location) {
        this.locationTableModel.updateItem(location);
    }

    private void breakpointLocationsUpdated(Collection<TraceBreakpointLocation> locations) {
        this.locationTableModel.updateAllItems(locations);
    }

    private void breakpointLocationRemoved(TraceBreakpointLocation location) {
        this.locationTableModel.deleteItem(location);
    }

    private void doTrackTrace(Trace trace) {
        if (this.listenersByTrace.containsKey(trace)) {
            Msg.warn((Object)((Object)this), (Object)"Already tracking trace breakpoints");
            return;
        }
        this.listenersByTrace.put(trace, new ForBreakpointLocationsTraceListener(trace));
        this.loadBreakpointLocations(trace);
    }

    private void doUntrackTrace(Trace trace) {
        ForBreakpointLocationsTraceListener l = this.listenersByTrace.remove(trace);
        if (l != null) {
            l.dispose();
            this.unloadBreakpointLocations(trace);
        }
    }

    protected void traceOpened(Trace trace) {
        this.doTrackTrace(trace);
    }

    protected void traceClosed(Trace trace) {
        this.doUntrackTrace(trace);
    }

    public ActionContext getActionContext(MouseEvent event) {
        return this.myActionContext;
    }

    protected void buildMainPanel() {
        this.mainPanel.setContinuousLayout(true);
        JPanel breakpointPanel = new JPanel(new BorderLayout());
        this.breakpointTable = new GhidraTable((TableModel)((Object)this.breakpointTableModel));
        this.breakpointTable.setSelectionMode(2);
        breakpointPanel.add(new JScrollPane((Component)this.breakpointTable));
        this.breakpointTable.setAutoLookupColumn(LogicalBreakpointTableColumns.ADDRESS.ordinal());
        this.breakpointFilterPanel = new GhidraTableFilterPanel((JTable)this.breakpointTable, (RowObjectTableModel)this.breakpointTableModel);
        breakpointPanel.add((Component)this.breakpointFilterPanel, "South");
        this.mainPanel.setLeftComponent(breakpointPanel);
        String namePrefix = "Breakpoints";
        this.breakpointTable.setAccessibleNamePrefix(namePrefix);
        this.breakpointFilterPanel.setAccessibleNamePrefix(namePrefix);
        JPanel locationPanel = new JPanel(new BorderLayout());
        this.locationTable = new GhidraTable((TableModel)((Object)this.locationTableModel));
        this.locationTable.setSelectionMode(2);
        locationPanel.add(new JScrollPane((Component)this.locationTable));
        this.locationFilterPanel = new GhidraTableFilterPanel((JTable)this.locationTable, (RowObjectTableModel)this.locationTableModel);
        this.locationFilterPanel.setSecondaryFilter((TableFilter)this.filterLocationsBySelectedBreakpoints);
        locationPanel.add((Component)this.locationFilterPanel, "South");
        this.mainPanel.setRightComponent(locationPanel);
        this.mainPanel.setResizeWeight(0.5);
        String locationsNamePrefix = "Breakpoint Locations";
        this.locationTable.setAccessibleNamePrefix(locationsNamePrefix);
        this.locationFilterPanel.setAccessibleNamePrefix(locationsNamePrefix);
        this.breakpointTable.getSelectionModel().addListSelectionListener(evt -> {
            List sel = this.breakpointFilterPanel.getSelectedItems();
            if (!sel.isEmpty()) {
                this.locationTable.clearSelection();
                this.locationTable.getSelectionManager().clearSavedSelection();
            }
            this.myActionContext = new DebuggerLogicalBreakpointsActionContext(sel);
            if (this.isFilterLocationsByBreakpoints()) {
                this.locationTableModel.fireTableDataChanged();
            }
            this.contextChanged();
        });
        this.breakpointTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                if (e.getClickCount() != 2) {
                    return;
                }
                DebuggerBreakpointsProvider.this.navigateToSelectedBreakpoint();
            }
        });
        this.breakpointTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 10 || e.getModifiersEx() != 0) {
                    return;
                }
                DebuggerBreakpointsProvider.this.navigateToSelectedBreakpoint();
            }
        });
        this.locationTable.getSelectionModel().addListSelectionListener(evt -> {
            List sel = this.locationFilterPanel.getSelectedItems();
            if (!sel.isEmpty()) {
                this.breakpointTable.clearSelection();
                this.breakpointTable.getSelectionManager().clearSavedSelection();
            }
            this.myActionContext = new DebuggerBreakpointLocationsActionContext(sel);
            this.contextChanged();
        });
        this.locationTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                if (e.getClickCount() != 2) {
                    return;
                }
                DebuggerBreakpointsProvider.this.navigateToSelectedLocation();
            }
        });
        this.locationTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 10 || e.getModifiersEx() != 0) {
                    return;
                }
                DebuggerBreakpointsProvider.this.navigateToSelectedLocation();
            }
        });
        TableColumnModel bptColModel = this.breakpointTable.getColumnModel();
        TableColumn bptEnCol = bptColModel.getColumn(LogicalBreakpointTableColumns.STATE.ordinal());
        bptEnCol.setCellRenderer((TableCellRenderer)((Object)new DebuggerBreakpointStateTableCellRenderer()));
        bptEnCol.setCellEditor(new DebuggerBreakpointStateTableCellEditor<LogicalBreakpointRow>(this.breakpointFilterPanel){

            @Override
            protected LogicalBreakpoint.State getToggledState(LogicalBreakpointRow row, LogicalBreakpoint.State current) {
                boolean mapped = row.isMapped();
                if (!mapped) {
                    DebuggerBreakpointsProvider.this.tool.setStatusInfo("Breakpoint has no locations. Only toggling its bookmark.", true);
                }
                return current.getToggled(mapped);
            }
        });
        bptEnCol.setMaxWidth(24);
        bptEnCol.setMinWidth(24);
        TableColumn bptNameCol = bptColModel.getColumn(LogicalBreakpointTableColumns.NAME.ordinal());
        bptNameCol.setPreferredWidth(150);
        TableColumn bptAddrCol = bptColModel.getColumn(LogicalBreakpointTableColumns.ADDRESS.ordinal());
        bptAddrCol.setPreferredWidth(150);
        bptAddrCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn bptImgCol = bptColModel.getColumn(LogicalBreakpointTableColumns.IMAGE.ordinal());
        bptImgCol.setPreferredWidth(100);
        TableColumn lenCol = bptColModel.getColumn(LogicalBreakpointTableColumns.LENGTH.ordinal());
        lenCol.setPreferredWidth(60);
        lenCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_ULONG_HEX);
        TableColumn kindCol = bptColModel.getColumn(LogicalBreakpointTableColumns.KINDS.ordinal());
        kindCol.setPreferredWidth(150);
        TableColumn locsCol = bptColModel.getColumn(LogicalBreakpointTableColumns.LOCATIONS.ordinal());
        locsCol.setPreferredWidth(20);
        TableColumn bptSleighCol = bptColModel.getColumn(LogicalBreakpointTableColumns.SLEIGH.ordinal());
        bptSleighCol.setMaxWidth(30);
        bptSleighCol.setMinWidth(30);
        GTableColumnModel locColModel = (GTableColumnModel)this.locationTable.getColumnModel();
        TableColumn locEnCol = locColModel.getColumn(BreakpointLocationTableColumns.STATE.ordinal());
        locEnCol.setCellRenderer((TableCellRenderer)((Object)new DebuggerBreakpointStateTableCellRenderer()));
        locEnCol.setCellEditor(new DebuggerBreakpointStateTableCellEditor<BreakpointLocationRow>(this.locationFilterPanel){

            @Override
            protected LogicalBreakpoint.State getToggledState(BreakpointLocationRow row, LogicalBreakpoint.State current) {
                return current.getToggled(false);
            }
        });
        locEnCol.setMaxWidth(24);
        locEnCol.setMinWidth(24);
        TableColumn locAddrCol = locColModel.getColumn(BreakpointLocationTableColumns.ADDRESS.ordinal());
        locAddrCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn locThreadsCol = locColModel.getColumn(BreakpointLocationTableColumns.THREADS.ordinal());
        TableColumn locSleighCol = locColModel.getColumn(BreakpointLocationTableColumns.SLEIGH.ordinal());
        locSleighCol.setMaxWidth(30);
        locSleighCol.setMinWidth(30);
        locColModel.setVisible(locThreadsCol, false);
        locColModel.setVisible(locSleighCol, false);
    }

    protected void navigateToSelectedBreakpoint() {
        ProgramLocation programLocation;
        LogicalBreakpoint lb;
        if (this.listingService == null) {
            return;
        }
        LogicalBreakpointRow row = (LogicalBreakpointRow)this.breakpointFilterPanel.getSelectedItem();
        if (row == null) {
            return;
        }
        Set traces = (lb = row.getLogicalBreakpoint()).getParticipatingTraces();
        Trace trace = traces.size() == 1 ? (Trace)traces.iterator().next() : this.traceManager.getCurrentTrace();
        Address traceAddress = lb.getTraceAddress(trace);
        if (traceAddress != null) {
            ProgramLocation loc = new ProgramLocation((Program)trace.getProgramView(), traceAddress);
            this.listingService.goTo(loc, true);
        }
        if ((programLocation = lb.getProgramLocation()) != null) {
            this.goToService.goTo(programLocation);
        }
    }

    protected void navigateToSelectedLocation() {
        if (this.listingService == null) {
            return;
        }
        BreakpointLocationRow row = (BreakpointLocationRow)this.locationFilterPanel.getSelectedItem();
        if (row == null) {
            return;
        }
        Trace trace = row.getTraceBreakpoint().getTrace();
        if (trace != this.currentTrace) {
            if (this.traceManager == null) {
                return;
            }
            this.traceManager.activateTrace(trace);
        }
        this.listingService.goTo(row.getProgramLocation(), true);
    }

    protected void createActions() {
        this.actionSetBreakpoint = new SetBreakpointAction();
        this.actionEnableSelectedBreakpoints = new EnableSelectedBreakpointsAction();
        this.actionEnableAllBreakpoints = new EnableAllBreakpointsAction();
        this.actionDisableSelectedBreakpoints = new DisableSelectedBreakpointsAction();
        this.actionDisableAllBreakpoints = new DisableAllBreakpointsAction();
        this.actionClearSelectedBreakpoints = new ClearSelectedBreakpointsAction();
        this.actionClearAllBreakpoints = new ClearAllBreakpointsAction();
        this.actionMakeBreakpointsEffective = new MakeBreakpointsEffectiveAction();
        this.actionFilterByCurrentTrace = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.FilterAction.builder(this.plugin).toolBarIcon(DebuggerResources.ICON_TRACE)).description("Filter locations to those in current trace")).helpLocation(new HelpLocation(this.plugin.getName(), "filter_by_trace"))).onAction(this::toggledFilterByCurrentTrace)).buildAndInstallLocal((ComponentProvider)this);
        this.actionFilterLocationsByBreakpoints = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.FilterAction.builder(this.plugin).description("Filter locations to those in selected breakpoints")).helpLocation(new HelpLocation(this.plugin.getName(), "filter_by_logical"))).onAction(this::toggledFilterLocationsByBreakpoints)).buildAndInstallLocal((ComponentProvider)this);
        this.actionSetCondition = (DockingAction)((ActionBuilder)((ActionBuilder)SetEmulatedBreakpointConditionAction.builder(this.plugin).popupWhen(this::isPopupSetCondition)).onAction(this::activatedSetCondition)).buildAndInstall((Tool)this.tool);
        this.actionSetInjection = (DockingAction)((ActionBuilder)((ActionBuilder)SetEmulatedBreakpointInjectionAction.builder(this.plugin).popupWhen(this::isPopupSetInjection)).onAction(this::activatedSetInjection)).buildAndInstall((Tool)this.tool);
        this.actionMakeBreakpointsEffectiveResolution = new MakeBreakpointsEffectiveResolutionAction(this);
    }

    private Collection<LogicalBreakpoint> getLogicalBreakpoints(ActionContext ctx) {
        if (ctx instanceof DebuggerLogicalBreakpointsActionContext) {
            DebuggerLogicalBreakpointsActionContext lbCtx = (DebuggerLogicalBreakpointsActionContext)ctx;
            return lbCtx.getBreakpoints();
        }
        if (ctx instanceof ProgramLocationActionContext) {
            ProgramLocationActionContext locCtx = (ProgramLocationActionContext)ctx;
            return this.breakpointService.getBreakpointsAt(locCtx.getLocation());
        }
        Object object = ctx.getContextObject();
        if (object instanceof MarkerLocation) {
            MarkerLocation ml = (MarkerLocation)object;
            return this.breakpointService.getBreakpointsAt(new ProgramLocation(ml.getProgram(), ml.getAddr()));
        }
        return null;
    }

    private boolean isAllInvolvedTracesUsingEmulatedBreakpoints(ActionContext ctx) {
        if (this.controlService == null) {
            return false;
        }
        HashSet<Trace> traces = new HashSet<Trace>();
        Collection<LogicalBreakpoint> breakpoints = this.getLogicalBreakpoints(ctx);
        if (breakpoints != null) {
            if (breakpoints.isEmpty()) {
                return false;
            }
            for (LogicalBreakpoint logicalBreakpoint : breakpoints) {
                traces.addAll(logicalBreakpoint.getParticipatingTraces());
            }
        } else if (ctx instanceof DebuggerBreakpointLocationsActionContext) {
            DebuggerBreakpointLocationsActionContext locCtx = (DebuggerBreakpointLocationsActionContext)ctx;
            Collection<TraceBreakpointLocation> locations = locCtx.getLocations();
            if (locations.isEmpty()) {
                return false;
            }
            for (TraceBreakpointLocation loc : locations) {
                traces.add(loc.getTrace());
            }
        } else {
            return false;
        }
        for (Trace trace : traces) {
            if (this.controlService.getCurrentMode(trace).useEmulatedBreakpoints()) continue;
            return false;
        }
        return true;
    }

    private boolean isAllBreakpointsExecution(ActionContext ctx) {
        Collection<LogicalBreakpoint> breakpoints = this.getLogicalBreakpoints(ctx);
        if (breakpoints != null) {
            for (LogicalBreakpoint lb : breakpoints) {
                if (EXECUTE_KINDS.containsAll(lb.getKinds())) continue;
                return false;
            }
            return true;
        }
        if (ctx instanceof DebuggerBreakpointLocationsActionContext) {
            DebuggerBreakpointLocationsActionContext locCtx = (DebuggerBreakpointLocationsActionContext)ctx;
            for (TraceBreakpointLocation loc : locCtx.getLocations()) {
                long snap;
                if (EXECUTE_KINDS.containsAll(loc.getKinds(snap = this.traceManager.getCurrentFor(loc.getTrace()).getSnap()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isPopupSetCondition(ActionContext ctx) {
        return this.isAllInvolvedTracesUsingEmulatedBreakpoints(ctx) && this.isAllBreakpointsExecution(ctx);
    }

    private boolean isPopupSetInjection(ActionContext ctx) {
        return this.isAllInvolvedTracesUsingEmulatedBreakpoints(ctx) && this.isAllBreakpointsExecution(ctx);
    }

    private String deriveCurrentSleigh(ActionContext ctx) {
        String sleigh = null;
        Collection<LogicalBreakpoint> breakpoints = this.getLogicalBreakpoints(ctx);
        if (breakpoints != null) {
            for (LogicalBreakpoint lb : breakpoints) {
                String s = lb.getEmuSleigh();
                if (sleigh != null && !sleigh.equals(s)) {
                    return null;
                }
                sleigh = s;
            }
            return sleigh;
        }
        if (ctx instanceof DebuggerBreakpointLocationsActionContext) {
            DebuggerBreakpointLocationsActionContext locCtx = (DebuggerBreakpointLocationsActionContext)ctx;
            for (TraceBreakpointLocation loc : locCtx.getLocations()) {
                long snap = this.traceManager.getCurrentFor(loc.getTrace()).getSnap();
                String s = loc.getEmuSleigh(snap);
                if (sleigh != null && !sleigh.equals(s)) {
                    return null;
                }
                sleigh = s;
            }
            return sleigh;
        }
        return null;
    }

    private String deriveCurrentCondition(ActionContext ctx) {
        String sleigh = this.deriveCurrentSleigh(ctx);
        return sleigh == null ? null : SleighUtils.recoverConditionFromBreakpoint((String)sleigh);
    }

    private void injectSleigh(ActionContext ctx, String sleigh) {
        Collection<LogicalBreakpoint> breakpoints = this.getLogicalBreakpoints(ctx);
        if (breakpoints != null) {
            for (LogicalBreakpoint lb : breakpoints) {
                lb.setEmuSleigh(sleigh);
            }
        } else if (ctx instanceof DebuggerBreakpointLocationsActionContext) {
            DebuggerBreakpointLocationsActionContext locCtx = (DebuggerBreakpointLocationsActionContext)ctx;
            for (TraceBreakpointLocation loc : locCtx.getLocations()) {
                long snap = this.traceManager.getCurrentFor(loc.getTrace()).getSnap();
                loc.setEmuSleigh(snap, sleigh);
            }
        } else {
            throw new AssertionError();
        }
    }

    private void activatedSetCondition(ActionContext ctx) {
        String condition;
        String curCondition = this.deriveCurrentCondition(ctx);
        if (curCondition == null) {
            curCondition = "1:1";
        }
        if ((condition = DebuggerSleighExpressionInputDialog.INSTANCE.prompt(this.tool, curCondition)) == null) {
            return;
        }
        this.injectSleigh(ctx, SleighUtils.sleighForConditionalBreak((String)condition));
    }

    private void activatedSetInjection(ActionContext ctx) {
        String sleigh;
        String curSleigh = this.deriveCurrentSleigh(ctx);
        if (curSleigh == null) {
            curSleigh = "emu_swi();\nemu_exec_decoded();\n";
        }
        if ((sleigh = DebuggerSleighSemanticInputDialog.INSTANCE.prompt(this.tool, curSleigh)) == null) {
            return;
        }
        this.injectSleigh(ctx, sleigh);
    }

    private void toggledFilterByCurrentTrace(ActionContext ignored) {
        this.breakpointTableModel.fireTableDataChanged();
        this.locationTableModel.fireTableDataChanged();
    }

    public boolean isFilterByCurrentTrace() {
        return this.actionFilterByCurrentTrace.isSelected();
    }

    private void toggledFilterLocationsByBreakpoints(ActionContext ignored) {
        this.locationTableModel.fireTableDataChanged();
    }

    public boolean isFilterLocationsByBreakpoints() {
        return this.actionFilterLocationsByBreakpoints.isSelected();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void setTrace(Trace trace) {
        this.currentTrace = trace;
        if (this.isFilterByCurrentTrace()) {
            this.breakpointTableModel.fireTableDataChanged();
            this.locationTableModel.fireTableDataChanged();
        }
    }

    public void setSelectedBreakpoints(Set<LogicalBreakpoint> sel) {
        DebuggerResources.setSelectedRows(sel, arg_0 -> ((LogicalBreakpointTableModel)this.breakpointTableModel).getRow(arg_0), (GTable)this.breakpointTable, this.breakpointTableModel, this.breakpointFilterPanel);
    }

    public void setSelectedLocations(Set<TraceBreakpointLocation> sel) {
        DebuggerResources.setSelectedRows(sel, arg_0 -> ((BreakpointLocationTableModel)this.locationTableModel).getRow(arg_0), (GTable)this.locationTable, this.locationTableModel, this.locationFilterPanel);
    }

    protected void breakpointError(String title, String message, Throwable ex) {
        if (this.consoleService == null) {
            Msg.showError((Object)((Object)this), null, (String)title, (Object)message, (Throwable)ex);
            return;
        }
        Msg.error((Object)((Object)this), (Object)message, (Throwable)ex);
        this.consoleService.log(DebuggerResources.ICON_LOG_ERROR, message, ex);
    }

    protected static class LogicalBreakpointTableModel
    extends RowWrappedEnumeratedColumnTableModel<LogicalBreakpointTableColumns, LogicalBreakpoint, LogicalBreakpointRow, LogicalBreakpoint> {
        public LogicalBreakpointTableModel(DebuggerBreakpointsProvider provider) {
            super(provider.getTool(), "Breakpoints", LogicalBreakpointTableColumns.class, lb -> lb, lb -> new LogicalBreakpointRow(provider, (LogicalBreakpoint)lb), LogicalBreakpointRow::getLogicalBreakpoint);
        }

        public List<LogicalBreakpointTableColumns> defaultSortOrder() {
            return List.of(LogicalBreakpointTableColumns.IMAGE, LogicalBreakpointTableColumns.ADDRESS, LogicalBreakpointTableColumns.NAME);
        }
    }

    protected static class BreakpointLocationTableModel
    extends RowWrappedEnumeratedColumnTableModel<BreakpointLocationTableColumns, ObjectKey, BreakpointLocationRow, TraceBreakpointLocation> {
        public BreakpointLocationTableModel(DebuggerBreakpointsProvider provider) {
            super(provider.getTool(), "Locations", BreakpointLocationTableColumns.class, TraceUniqueObject::getObjectKey, loc -> new BreakpointLocationRow(provider, (TraceBreakpointLocation)loc), BreakpointLocationRow::getTraceBreakpoint);
        }

        public List<BreakpointLocationTableColumns> defaultSortOrder() {
            return List.of(BreakpointLocationTableColumns.ADDRESS, BreakpointLocationTableColumns.NAME);
        }
    }

    class LocationsBySelectedBreakpointsTableFilter
    implements TableFilter<BreakpointLocationRow> {
        LocationsBySelectedBreakpointsTableFilter() {
        }

        public boolean acceptsRow(BreakpointLocationRow locationRow) {
            if (DebuggerBreakpointsProvider.this.isFilterByCurrentTrace() && locationRow.getTraceBreakpoint().getTrace() != DebuggerBreakpointsProvider.this.currentTrace) {
                return false;
            }
            if (DebuggerBreakpointsProvider.this.isFilterLocationsByBreakpoints()) {
                List selBreakRows = DebuggerBreakpointsProvider.this.breakpointFilterPanel.getSelectedItems();
                if (selBreakRows == null || selBreakRows.isEmpty()) {
                    return true;
                }
                for (LogicalBreakpointRow breakRow : selBreakRows) {
                    if (!breakRow.getLogicalBreakpoint().getTraceBreakpoints().contains(locationRow.getTraceBreakpoint())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        public boolean isSubFilterOf(TableFilter<?> tableFilter) {
            return false;
        }
    }

    protected class MakeBreakpointsEffectiveResolutionAction
    extends CommonMakeBreakpointsEffectiveAction {
        protected MakeBreakpointsEffectiveResolutionAction(DebuggerBreakpointsProvider this$0) {
        }

        public boolean isValidContext(ActionContext context) {
            return context instanceof DebuggerMakeBreakpointsEffectiveActionContext;
        }
    }

    protected class MakeBreakpointsEffectiveAction
    extends CommonMakeBreakpointsEffectiveAction {
        public MakeBreakpointsEffectiveAction() {
            DebuggerBreakpointsProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(false);
        }

        public boolean isEnabledForContext(ActionContext context) {
            if (DebuggerBreakpointsProvider.this.breakpointService == null) {
                return false;
            }
            Set all = DebuggerBreakpointsProvider.this.breakpointService.getAllBreakpoints();
            for (LogicalBreakpoint lb : all) {
                if (lb.computeState() != LogicalBreakpoint.State.INEFFECTIVE_ENABLED || lb.getMappedTraces().isEmpty()) continue;
                return true;
            }
            return false;
        }
    }

    protected class ForBreakpointLocationsTraceListener
    extends TraceDomainObjectListener {
        private final Trace trace;

        public ForBreakpointLocationsTraceListener(Trace trace) {
            this.trace = trace;
            this.listenForUntyped((EventType)DomainObjectEvent.RESTORED, e -> this.objectRestored());
            this.listenFor((TraceEvent)TraceEvents.BREAKPOINT_ADDED, this::locationAdded);
            this.listenFor((TraceEvent)TraceEvents.BREAKPOINT_CHANGED, this::locationChanged);
            this.listenFor((TraceEvent)TraceEvents.BREAKPOINT_LIFESPAN_CHANGED, this::locationLifespanChanged);
            this.listenFor((TraceEvent)TraceEvents.BREAKPOINT_DELETED, this::locationDeleted);
            trace.addListener((DomainObjectListener)this);
        }

        private void objectRestored() {
            DebuggerBreakpointsProvider.this.reloadBreakpointLocations(this.trace);
        }

        private boolean isVisible(TraceBreakpointLocation location) {
            long snap = DebuggerBreakpointsProvider.this.traceManager.getCurrentFor(this.trace).getSnap();
            return location.isValid(snap);
        }

        private void locationAdded(TraceBreakpointLocation location) {
            if (!this.isVisible(location)) {
                return;
            }
            DebuggerBreakpointsProvider.this.breakpointLocationAdded(location);
        }

        private void locationChanged(TraceBreakpointLocation location) {
            if (!this.isVisible(location)) {
                return;
            }
            DebuggerBreakpointsProvider.this.breakpointLocationUpdated(location);
        }

        private void locationLifespanChanged(TraceBreakpointLocation location, Lifespan oldSpan, Lifespan newSpan) {
            boolean isLiveNew;
            long snap = DebuggerBreakpointsProvider.this.traceManager.getCurrentFor(this.trace).getSnap();
            boolean isLiveOld = oldSpan.contains(snap);
            if (isLiveOld == (isLiveNew = newSpan.contains(snap))) {
                return;
            }
            if (isLiveOld) {
                DebuggerBreakpointsProvider.this.breakpointLocationRemoved(location);
            } else {
                DebuggerBreakpointsProvider.this.breakpointLocationAdded(location);
            }
        }

        private void locationDeleted(TraceBreakpointLocation location) {
            if (!this.isVisible(location)) {
                return;
            }
            DebuggerBreakpointsProvider.this.breakpointLocationRemoved(location);
        }

        private void dispose() {
            this.trace.removeListener((DomainObjectListener)this);
        }
    }

    protected static enum LogicalBreakpointTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<LogicalBreakpointTableColumns, LogicalBreakpointRow>
    {
        STATE("State", LogicalBreakpoint.State.class, LogicalBreakpointRow::getState, LogicalBreakpointRow::setState, true),
        NAME("Name", String.class, LogicalBreakpointRow::getName, LogicalBreakpointRow::setName, LogicalBreakpointRow::isNamable, true),
        ADDRESS("Address", Address.class, LogicalBreakpointRow::getAddress, true),
        IMAGE("Image", String.class, LogicalBreakpointRow::getImageName, true),
        LENGTH("Length", Long.class, LogicalBreakpointRow::getLength, true),
        KINDS("Kinds", String.class, LogicalBreakpointRow::getKinds, true),
        LOCATIONS("Locations", Integer.class, LogicalBreakpointRow::getLocationCount, true),
        SLEIGH("Sleigh", Boolean.class, LogicalBreakpointRow::hasSleigh, true);

        private final String header;
        private final Class<?> cls;
        private final Function<LogicalBreakpointRow, ?> getter;
        private final BiConsumer<LogicalBreakpointRow, Object> setter;
        private final Predicate<LogicalBreakpointRow> editable;
        private final boolean sortable;

        private <T> LogicalBreakpointTableColumns(String header, Class<T> cls, Function<LogicalBreakpointRow, T> getter, boolean sortable) {
            this(header, cls, getter, null, null, sortable);
        }

        private <T> LogicalBreakpointTableColumns(String header, Class<T> cls, Function<LogicalBreakpointRow, T> getter, BiConsumer<LogicalBreakpointRow, T> setter, boolean sortable) {
            this(header, cls, getter, setter, null, sortable);
        }

        private <T> LogicalBreakpointTableColumns(String header, Class<T> cls, Function<LogicalBreakpointRow, T> getter, BiConsumer<LogicalBreakpointRow, T> setter, Predicate<LogicalBreakpointRow> editable, boolean sortable) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
            this.editable = editable;
            this.sortable = sortable;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(LogicalBreakpointRow row) {
            return this.getter.apply(row);
        }

        public String getHeader() {
            return this.header;
        }

        public boolean isEditable(LogicalBreakpointRow row) {
            return this.setter != null && (this.editable == null || this.editable.test(row));
        }

        public boolean isSortable() {
            return this.sortable;
        }

        public void setValueOf(LogicalBreakpointRow row, Object value) {
            this.setter.accept(row, value);
        }
    }

    protected static enum BreakpointLocationTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<BreakpointLocationTableColumns, BreakpointLocationRow>
    {
        STATE("State", LogicalBreakpoint.State.class, BreakpointLocationRow::getState, BreakpointLocationRow::setState, true, true),
        NAME("Name", String.class, BreakpointLocationRow::getName, BreakpointLocationRow::setName, true, true),
        ADDRESS("Address", Address.class, BreakpointLocationRow::getAddress, true, true),
        TRACE("Trace", String.class, BreakpointLocationRow::getTraceName, true, true),
        THREADS("Threads", String.class, BreakpointLocationRow::getThreads, true, false),
        COMMENT("Comment", String.class, BreakpointLocationRow::getComment, BreakpointLocationRow::setComment, true, true),
        EXPRESSION("Expression", String.class, BreakpointLocationRow::getExpression, true, true),
        SLEIGH("Sleigh", Boolean.class, BreakpointLocationRow::hasSleigh, true, true);

        private final String header;
        private final Function<BreakpointLocationRow, ?> getter;
        private final BiConsumer<BreakpointLocationRow, Object> setter;
        private final boolean sortable;
        private final boolean visible;
        private final Class<?> cls;

        private <T> BreakpointLocationTableColumns(String header, Class<T> cls, Function<BreakpointLocationRow, T> getter, boolean sortable, boolean visible) {
            this(header, cls, getter, null, sortable, visible);
        }

        private <T> BreakpointLocationTableColumns(String header, Class<T> cls, Function<BreakpointLocationRow, T> getter, BiConsumer<BreakpointLocationRow, T> setter, boolean sortable, boolean visible) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
            this.sortable = sortable;
            this.visible = visible;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(BreakpointLocationRow row) {
            return this.getter.apply(row);
        }

        public String getHeader() {
            return this.header;
        }

        public boolean isEditable(BreakpointLocationRow row) {
            return this.setter != null;
        }

        public boolean isSortable() {
            return this.sortable;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setValueOf(BreakpointLocationRow row, Object value) {
            this.setter.accept(row, value);
        }
    }

    protected class SetBreakpointAction
    extends MultiActionDockingAction {
        public static final String GROUP = "Dbg6. Breakpoints";
        private final List<DockingActionIf> stub;

        public SetBreakpointAction() {
            super("Set Breakpoint", DebuggerBreakpointsProvider.this.plugin.getName());
            this.stub = List.of(new StubSetBreakpointAction(DebuggerBreakpointsProvider.this));
            this.setToolBarData(new ToolBarData(DebuggerResources.ICON_ADD, GROUP));
            this.setHelpLocation(DebuggerResources.AbstractSetBreakpointAction.help(DebuggerBreakpointsProvider.this.plugin));
            DebuggerBreakpointsProvider.this.addLocalAction((DockingActionIf)this);
        }

        public List<DockingActionIf> getActionList(ActionContext context) {
            if (DebuggerBreakpointsProvider.this.traceManager == null) {
                return this.stub;
            }
            Trace trace = DebuggerBreakpointsProvider.this.traceManager.getCurrentTrace();
            if (trace == null) {
                return this.stub;
            }
            if (DebuggerBreakpointsProvider.this.controlService == null) {
                return this.stub;
            }
            ControlMode mode = DebuggerBreakpointsProvider.this.controlService.getCurrentMode(trace);
            if (!mode.isTarget()) {
                return this.stub;
            }
            Target target = DebuggerBreakpointsProvider.this.traceManager.getCurrent().getTarget();
            if (target == null) {
                return this.stub;
            }
            ArrayList<DockingActionIf> result = new ArrayList<DockingActionIf>();
            for (Target.ActionEntry entry : target.collectActions(ActionName.BREAK_EXT, context, Target.ObjectArgumentPolicy.CURRENT_AND_RELATED).values()) {
                result.add((DockingActionIf)new GenericSetBreakpointAction(DebuggerBreakpointsProvider.this, entry));
            }
            if (result.isEmpty()) {
                return this.stub;
            }
            Collections.sort(result, Comparator.comparing(a -> a.getName()));
            return result;
        }
    }

    protected class EnableSelectedBreakpointsAction
    extends DebuggerResources.AbstractEnableSelectedBreakpointsAction {
        public static final String GROUP = "Dbg6. Breakpoints";

        public EnableSelectedBreakpointsAction() {
            super(DebuggerBreakpointsProvider.this.plugin);
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            this.setPopupMenuData(new MenuData(new String[]{"Enable"}, ICON, GROUP));
            DebuggerBreakpointsProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            Collection<LogicalBreakpoint> sel;
            DefaultActionContext ctx;
            if (context == null) {
                return;
            }
            if (context instanceof DebuggerLogicalBreakpointsActionContext) {
                Trace trace;
                ctx = (DebuggerLogicalBreakpointsActionContext)context;
                sel = ctx.getBreakpoints();
                String status = DebuggerBreakpointsProvider.this.breakpointService.generateStatusEnable(sel, trace = DebuggerBreakpointsProvider.this.isFilterByCurrentTrace() ? DebuggerBreakpointsProvider.this.currentTrace : null);
                if (status != null) {
                    DebuggerBreakpointsProvider.this.tool.setStatusInfo(status, true);
                }
                DebuggerBreakpointsProvider.this.breakpointService.enableAll(sel, trace).exceptionally(ex -> {
                    DebuggerBreakpointsProvider.this.breakpointError("Enable Breakpoints", "Could not enable breakpoints", (Throwable)ex);
                    return null;
                });
            }
            if (context instanceof DebuggerBreakpointLocationsActionContext) {
                ctx = (DebuggerBreakpointLocationsActionContext)context;
                sel = ctx.getLocations();
                DebuggerBreakpointsProvider.this.breakpointService.enableLocs(sel).exceptionally(ex -> {
                    DebuggerBreakpointsProvider.this.breakpointError("Enable Breakpoints", "Could not enable breakpoints", (Throwable)ex);
                    return null;
                });
            }
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerBreakpointsProvider.contextHasMatchingBreakpoints(context, row -> row.getState() != LogicalBreakpoint.State.ENABLED, row -> row.getState() != LogicalBreakpoint.State.ENABLED);
        }

        public boolean isAddToPopup(ActionContext context) {
            return this.isEnabledForContext(context);
        }
    }

    protected class EnableAllBreakpointsAction
    extends DebuggerResources.AbstractEnableAllBreakpointsAction {
        public static final String GROUP = "Dbg6. Breakpoints";

        public EnableAllBreakpointsAction() {
            super(DebuggerBreakpointsProvider.this.plugin);
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            DebuggerBreakpointsProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            Trace trace;
            Set all = DebuggerBreakpointsProvider.this.breakpointService.getAllBreakpoints();
            String status = DebuggerBreakpointsProvider.this.breakpointService.generateStatusEnable((Collection)all, trace = DebuggerBreakpointsProvider.this.isFilterByCurrentTrace() ? DebuggerBreakpointsProvider.this.currentTrace : null);
            if (status != null) {
                DebuggerBreakpointsProvider.this.tool.setStatusInfo(status, true);
            }
            DebuggerBreakpointsProvider.this.breakpointService.enableAll((Collection)all, trace).exceptionally(ex -> {
                DebuggerBreakpointsProvider.this.breakpointError("Enable All Breakpoints", "Could not enable breakpoints", (Throwable)ex);
                return null;
            });
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerBreakpointsProvider.this.breakpointService != null && !DebuggerBreakpointsProvider.this.breakpointService.getAllBreakpoints().isEmpty();
        }
    }

    protected class DisableSelectedBreakpointsAction
    extends DebuggerResources.AbstractDisableSelectedBreakpointsAction {
        public static final String GROUP = "Dbg6. Breakpoints";

        public DisableSelectedBreakpointsAction() {
            super(DebuggerBreakpointsProvider.this.plugin);
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            this.setPopupMenuData(new MenuData(new String[]{"Disable"}, ICON, GROUP));
            DebuggerBreakpointsProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            Collection<LogicalBreakpoint> sel;
            DefaultActionContext ctx;
            if (context == null) {
                return;
            }
            if (context instanceof DebuggerLogicalBreakpointsActionContext) {
                ctx = (DebuggerLogicalBreakpointsActionContext)context;
                sel = ctx.getBreakpoints();
                DebuggerBreakpointsProvider.this.breakpointService.disableAll(sel, null).exceptionally(ex -> {
                    DebuggerBreakpointsProvider.this.breakpointError("Disable Breakpoints", "Could not disable breakpoints", (Throwable)ex);
                    return null;
                });
            }
            if (context instanceof DebuggerBreakpointLocationsActionContext) {
                ctx = (DebuggerBreakpointLocationsActionContext)context;
                sel = ctx.getLocations();
                DebuggerBreakpointsProvider.this.breakpointService.disableLocs(sel).exceptionally(ex -> {
                    DebuggerBreakpointsProvider.this.breakpointError("Disable Breakpoints", "Could not disable breakpoints", (Throwable)ex);
                    return null;
                });
            }
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerBreakpointsProvider.contextHasMatchingBreakpoints(context, row -> row.getState() != LogicalBreakpoint.State.DISABLED, row -> row.getState() != LogicalBreakpoint.State.DISABLED);
        }

        public boolean isAddToPopup(ActionContext context) {
            return this.isEnabledForContext(context);
        }
    }

    protected class DisableAllBreakpointsAction
    extends DebuggerResources.AbstractDisableAllBreakpointsAction {
        public static final String GROUP = "Dbg6. Breakpoints";

        public DisableAllBreakpointsAction() {
            super(DebuggerBreakpointsProvider.this.plugin);
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            DebuggerBreakpointsProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            Set all = DebuggerBreakpointsProvider.this.breakpointService.getAllBreakpoints();
            DebuggerBreakpointsProvider.this.breakpointService.disableAll((Collection)all, null).exceptionally(ex -> {
                DebuggerBreakpointsProvider.this.breakpointError("Disable All Breakpoints", "Could not disable breakpoints", (Throwable)ex);
                return null;
            });
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerBreakpointsProvider.this.breakpointService != null && !DebuggerBreakpointsProvider.this.breakpointService.getAllBreakpoints().isEmpty();
        }
    }

    protected class ClearSelectedBreakpointsAction
    extends DebuggerResources.AbstractClearSelectedBreakpointsAction {
        public static final String GROUP = "Dbg6. BreakpointsClear";

        public ClearSelectedBreakpointsAction() {
            super(DebuggerBreakpointsProvider.this.plugin);
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            this.setPopupMenuData(new MenuData(new String[]{"Clear"}, ICON, GROUP));
            DebuggerBreakpointsProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            Collection<LogicalBreakpoint> sel;
            DefaultActionContext ctx;
            if (context instanceof DebuggerLogicalBreakpointsActionContext) {
                ctx = (DebuggerLogicalBreakpointsActionContext)context;
                sel = ctx.getBreakpoints();
                DebuggerBreakpointsProvider.this.breakpointService.deleteAll(sel, null).exceptionally(ex -> {
                    DebuggerBreakpointsProvider.this.breakpointError("Clear Breakpoints", "Could not clear breakpoints", (Throwable)ex);
                    return null;
                });
            }
            if (context instanceof DebuggerBreakpointLocationsActionContext) {
                ctx = (DebuggerBreakpointLocationsActionContext)context;
                sel = ctx.getLocations();
                DebuggerBreakpointsProvider.this.breakpointService.deleteLocs(sel).exceptionally(ex -> {
                    DebuggerBreakpointsProvider.this.breakpointError("Clear Breakpoints", "Could not clear breakpoints", (Throwable)ex);
                    return null;
                });
            }
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerBreakpointsProvider.contextIsNonEmptyBreakpoints(context);
        }
    }

    protected class ClearAllBreakpointsAction
    extends DebuggerResources.AbstractClearAllBreakpointsAction {
        public static final String GROUP = "Dbg6. BreakpointsClear";

        public ClearAllBreakpointsAction() {
            super(DebuggerBreakpointsProvider.this.plugin);
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            DebuggerBreakpointsProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            Set all = DebuggerBreakpointsProvider.this.breakpointService.getAllBreakpoints();
            DebuggerBreakpointsProvider.this.breakpointService.deleteAll((Collection)all, null).exceptionally(ex -> {
                DebuggerBreakpointsProvider.this.breakpointError("Clear All Breakpoints", "Could not clear breakpoints", (Throwable)ex);
                return null;
            });
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerBreakpointsProvider.this.breakpointService != null && !DebuggerBreakpointsProvider.this.breakpointService.getAllBreakpoints().isEmpty();
        }
    }

    static interface SetEmulatedBreakpointConditionAction {
        public static final String NAME = "Set Condition (Emulator)";
        public static final String DESCRIPTION = "Set a Sleigh condition for this emulated breakpoint";
        public static final String GROUP = "Dbg6. Breakpoints";
        public static final String HELP_ANCHOR = "set_condition";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{NAME})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface SetEmulatedBreakpointInjectionAction {
        public static final String NAME = "Set Injection (Emulator)";
        public static final String DESCRIPTION = "Set a Sleigh injection for this emulated breakpoint";
        public static final String GROUP = "Dbg6. Breakpoints";
        public static final String HELP_ANCHOR = "set_injection";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{NAME})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    protected abstract class CommonMakeBreakpointsEffectiveAction
    extends DebuggerResources.AbstractMakeBreakpointsEffectiveAction {
        public static final String GROUP = "Dbg6. Breakpoints";

        public CommonMakeBreakpointsEffectiveAction() {
            super(DebuggerBreakpointsProvider.this.plugin);
            this.setToolBarData(new ToolBarData(ICON, GROUP));
        }

        public void actionPerformed(ActionContext context) {
            Set enablable = DebuggerBreakpointsProvider.this.breakpointService.getAllBreakpoints().stream().filter(lb -> lb.computeState() == LogicalBreakpoint.State.INEFFECTIVE_ENABLED && !lb.getMappedTraces().isEmpty()).collect(Collectors.toSet());
            DebuggerBreakpointsProvider.this.breakpointService.enableAll(enablable, null).exceptionally(ex -> {
                DebuggerBreakpointsProvider.this.breakpointError("Make Breakpoints Effective", "Could not enable breakpoints", (Throwable)ex);
                return null;
            });
        }
    }

    protected class StubSetBreakpointAction
    extends DockingAction {
        public StubSetBreakpointAction(DebuggerBreakpointsProvider this$0) {
            super("(Use the Listings to Set Breakpoints)", this$0.plugin.getName());
            this.setMenuBarData(new MenuData(new String[]{this.getName()}));
            this.setHelpLocation(DebuggerResources.AbstractSetBreakpointAction.help(this$0.plugin));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionContext context) {
        }
    }

    protected class GenericSetBreakpointAction
    extends InvokeActionEntryAction {
        public GenericSetBreakpointAction(DebuggerBreakpointsProvider this$0, Target.ActionEntry entry) {
            super(this$0.plugin, entry);
            this.setMenuBarData(new MenuData(new String[]{this.getName()}, entry.icon()));
            this.setHelpLocation(DebuggerResources.AbstractSetBreakpointAction.help(this$0.plugin));
        }
    }
}

